/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.ParamKeyValueFilterConverterFactory;
import org.infinispan.server.resp.filter.ComposedFilterConverter;
import org.infinispan.server.resp.filter.GlobMatchFilterConverterFactory;
import org.infinispan.server.resp.filter.RespTypeFilterConverterFactory;

public class ComposedFilterConverterFactory
implements ParamKeyValueFilterConverterFactory<byte[], Object, Object> {
    private static final byte GLOB_FILTER = 0;
    private static final byte TYPE_FILTER = 1;

    public KeyValueFilterConverter<byte[], Object, Object> getFilterConverter(Object[] params) {
        assert ((params.length & 1) == 0) : "Should have an even number of parameters.";
        ArrayList filterConverters = new ArrayList();
        int i = 0;
        block4: while (i < params.length) {
            byte[] type = (byte[])params[i++];
            byte[] arguments = (byte[])params[i++];
            switch (type[0]) {
                case 0: {
                    KeyValueFilterConverter<byte[], byte[], byte[]> filter = GlobMatchFilterConverterFactory.create(arguments, false);
                    filterConverters.add(filter);
                    continue block4;
                }
                case 1: {
                    filterConverters.add(RespTypeFilterConverterFactory.create(arguments));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unknown filter with type: " + type[0]);
        }
        return new ComposedFilterConverter(filterConverters);
    }

    public boolean binaryParam() {
        return true;
    }

    public static Map.Entry<Class<?>, List<byte[]>> convertFiltersFormat(Map<Class<?>, List<byte[]>> filters) {
        if (filters.size() == 1) {
            return filters.entrySet().stream().findFirst().orElse(null);
        }
        ArrayList<byte[]> arguments = new ArrayList<byte[]>(4);
        for (Map.Entry<Class<?>, List<byte[]>> e : filters.entrySet()) {
            arguments.add(ComposedFilterConverterFactory.clazzToByte(e.getKey()));
            arguments.addAll((Collection)e.getValue());
        }
        return Map.entry(ComposedFilterConverterFactory.class, arguments);
    }

    private static byte[] clazzToByte(Class<?> clazz) {
        if (clazz == GlobMatchFilterConverterFactory.class) {
            return new byte[]{0};
        }
        if (clazz == RespTypeFilterConverterFactory.class) {
            return new byte[]{1};
        }
        throw new IllegalArgumentException("Unknown filter: " + clazz.getName());
    }
}

