/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.server.resp.BaseRespDecoder;
import org.infinispan.server.resp.Intrinsics;
import org.infinispan.server.resp.RespCommand;

public class RespDecoder
extends BaseRespDecoder {
    private int state;
    private int requestBytes;
    private RespCommand resp3x_bulkCommand;
    private byte[] resp3x_readTerminatedBytes;
    private int resp3x_readSizeAndCheckRemainder;
    private long resp3x_readNumber;
    private byte[] resp3x_bulkArray;
    private List<byte[]> resp3x_arguments;
    private String resp3x_simpleString;
    private RespCommand resp3x_simpleCommand;
    private RespCommand resp3x_command;
    private byte[] resp3x_array;
    private String resp3x_bulkString;
    private byte resp3x_singleByte;
    private final List<byte[]> reusedList = new ArrayList<byte[]>(16);

    RespCommand getCommand() {
        return this.resp3x_command;
    }

    List<byte[]> getArguments() {
        return this.resp3x_arguments;
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            if (!ctx.channel().config().isAutoRead()) {
                log.tracef("Auto read was disabled, not reading next bytes yet", new Object[0]);
                return;
            }
            log.tracef("Auto read was enabled, reading next bytes", new Object[0]);
            while (this.switch0(ctx, buf, out)) {
            }
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                int pos = buf.readerIndex();
                this.resp3x_singleByte = Intrinsics.singleByte(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 2;
            }
            case 2: {
                if (this.resp3x_singleByte != 42) {
                    throw new UnsupportedOperationException("Only array types are supported, received: " + this.resp3x_singleByte);
                }
                this.reusedList.clear();
                this.state = 3;
            }
            case 3: {
                int pos = buf.readerIndex();
                this.resp3x_readNumber = Intrinsics.readNumber(buf, this.longProcessor);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 5;
                return true;
            }
            case 4: {
                int pos = buf.readerIndex();
                this.resp3x_singleByte = Intrinsics.singleByte(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 6;
                return true;
            }
            case 5: {
                --this.resp3x_readNumber;
                this.state = 4;
                return true;
            }
            case 6: {
                switch (this.resp3x_singleByte) {
                    case 36: {
                        this.state = 8;
                        return true;
                    }
                    case 43: {
                        this.state = 9;
                        return true;
                    }
                }
                throw new UnsupportedOperationException("Type not supported: " + this.resp3x_singleByte);
            }
            case 7: {
                if (this.resp3x_readNumber > 16L) {
                    this.state = 11;
                    return true;
                }
                if (this.resp3x_readNumber >= 1L) {
                    this.state = 12;
                    return true;
                }
                this.resp3x_arguments = Collections.emptyList();
                this.state = 10;
                return true;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.resp3x_bulkCommand = Intrinsics.bulkCommand(buf, this.longProcessor);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.resp3x_command = this.resp3x_bulkCommand;
                this.state = 7;
                return true;
            }
            case 9: {
                int pos = buf.readerIndex();
                this.resp3x_simpleCommand = Intrinsics.simpleCommand(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.resp3x_command = this.resp3x_simpleCommand;
                this.state = 7;
                return true;
            }
            case 10: {
                if (this.resp3x_readNumber == 0L) {
                    this.state = 13;
                    return true;
                }
                --this.resp3x_readNumber;
                this.state = 14;
                return true;
            }
            case 11: {
                this.resp3x_arguments = new ArrayList<byte[]>((int)this.resp3x_readNumber);
                this.state = 10;
                return true;
            }
            case 12: {
                this.resp3x_arguments = this.reusedList;
                this.state = 10;
                return true;
            }
            case 13: {
                if (out.add((Object)this)) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 14: {
                int pos = buf.readerIndex();
                this.resp3x_singleByte = Intrinsics.singleByte(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 15;
            }
            case 15: {
                switch (this.resp3x_singleByte) {
                    case 36: {
                        this.state = 17;
                        return true;
                    }
                    case 43: {
                        this.state = 18;
                        return true;
                    }
                    case 58: {
                        this.state = 19;
                        return true;
                    }
                }
                throw new UnsupportedOperationException("Type not supported: " + this.resp3x_singleByte);
            }
            case 16: {
                this.resp3x_arguments.add(this.resp3x_array);
                this.state = 10;
                return true;
            }
            case 17: {
                int pos = buf.readerIndex();
                this.resp3x_bulkArray = Intrinsics.bulkArray(buf, this.longProcessor);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.resp3x_array = this.resp3x_bulkArray;
                this.state = 16;
                return true;
            }
            case 18: {
                int pos = buf.readerIndex();
                this.resp3x_readTerminatedBytes = Intrinsics.readTerminatedBytes(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.resp3x_array = this.resp3x_readTerminatedBytes;
                this.state = 16;
                return true;
            }
            case 19: {
                int pos = buf.readerIndex();
                this.resp3x_readTerminatedBytes = Intrinsics.readTerminatedBytes(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.resp3x_array = this.resp3x_readTerminatedBytes;
                this.state = 16;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        throw new IllegalArgumentException();
    }

    private void reset() {
        this.requestBytes = 0;
        this.resp3x_bulkCommand = null;
        this.resp3x_readTerminatedBytes = null;
        this.resp3x_readSizeAndCheckRemainder = 0;
        this.resp3x_readNumber = 0L;
        this.resp3x_bulkArray = null;
        this.resp3x_arguments = null;
        this.resp3x_simpleString = null;
        this.resp3x_simpleCommand = null;
        this.resp3x_command = null;
        this.resp3x_array = null;
        this.resp3x_bulkString = null;
        this.resp3x_singleByte = 0;
    }

    public int requestBytes() {
        return this.requestBytes;
    }
}

