/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.connection;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Commands;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class COMMAND
extends RespCommand
implements Resp3Command {
    public static final String NAME = "COMMAND";
    private static final JavaObjectSerializer<Object> SERIALIZER = (ignore, writer) -> {
        List<RespCommand> commands = Commands.all();
        writer.writeNumericPrefix((byte)42, commands.size());
        for (RespCommand command : commands) {
            COMMAND.describeCommand(command, writer);
        }
    };

    public COMMAND() {
        super(NAME, -1, 0, 0, 0);
    }

    @Override
    public long aclMask() {
        return AclCategory.SLOW | AclCategory.CONNECTION;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        if (!arguments.isEmpty()) {
            handler.writer().customError("COMMAND does not currently support arguments");
        } else {
            handler.writer().write(SERIALIZER);
        }
        return handler.myStage();
    }

    private static void describeCommand(RespCommand command, ResponseWriter writer) {
        writer.writeNumericPrefix((byte)42, 10L);
        writer.simpleString(command.getName());
        writer.integers(command.getArity());
        writer.emptySet();
        writer.integers(command.getFirstKeyPos());
        writer.integers(command.getLastKeyPos());
        writer.integers(command.getSteps());
        writer.emptySet();
        writer.emptySet();
        writer.emptySet();
        writer.emptySet();
    }
}

