/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.sortedset;

import java.util.Arrays;
import java.util.Collection;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.ResponseWriter;

public final class ZSetCommonUtils {
    public static final byte[] WITHSCORES = "WITHSCORES".getBytes();
    public static final byte EXCLUDE = 40;

    private ZSetCommonUtils() {
    }

    public static boolean isWithScoresArg(byte[] arg) {
        return RespUtil.isAsciiBytesEquals(WITHSCORES, arg);
    }

    private static boolean isInf(byte[] arg, char sign) {
        if (arg.length != 4) {
            return false;
        }
        return arg[0] == (byte)sign && arg[1] == 105 && arg[2] == 110 && arg[3] == 102;
    }

    public static Lex parseLex(byte[] arg) {
        if (arg.length == 0) {
            return null;
        }
        Lex lex = new Lex();
        if (arg.length == 1 && arg[0] == 45) {
            lex.unboundedMin = true;
            return lex;
        }
        if (arg.length == 1 && arg[0] == 43) {
            lex.unboundedMax = true;
            return lex;
        }
        boolean bl = lex.include = arg[0] == 91;
        if (!lex.include && arg[0] != 40) {
            return null;
        }
        lex.value = Arrays.copyOfRange(arg, 1, arg.length);
        return lex;
    }

    public static Score parseScore(byte[] arg) {
        try {
            Score score = new Score();
            if (ZSetCommonUtils.isInf(arg, '-')) {
                score.unboundedMin = true;
                return score;
            }
            if (ZSetCommonUtils.isInf(arg, '+')) {
                score.unboundedMax = true;
                return score;
            }
            if (arg[0] == 40) {
                score.value = ArgumentUtils.toDouble(arg, 1);
                score.include = false;
            } else {
                score.value = ArgumentUtils.toDouble(arg);
            }
            return score;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static ZOperationResponse response(Collection<ScoredValue<byte[]>> scoredValues, boolean withScores) {
        return new ZOperationResponse(scoredValues, withScores);
    }

    public static class Lex {
        public boolean include;
        public boolean unboundedMin;
        public boolean unboundedMax;
        public byte[] value;
    }

    public static class Score {
        public boolean unboundedMin;
        public boolean unboundedMax;
        public boolean include = true;
        public Double value;
    }

    public record ZOperationResponse(Collection<ScoredValue<byte[]>> values, boolean withScores) implements JavaObjectSerializer<ZOperationResponse>
    {
        @Override
        public void accept(ZOperationResponse ignore, ResponseWriter writer) {
            if (this.values == null) {
                writer.writeNumericPrefix((byte)42, 0L);
                return;
            }
            writer.writeNumericPrefix((byte)42, this.values.size());
            for (ScoredValue<byte[]> sv : this.values) {
                if (this.withScores) {
                    writer.writeNumericPrefix((byte)42, 2L);
                    writer.string((byte[])sv.getValue());
                    writer.doubles(sv.score());
                    continue;
                }
                writer.string((byte[])sv.getValue());
            }
        }
    }
}

