/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespRequestLimitTest")
public class RespRequestLimitTest
extends SingleNodeRespBaseTest {
    private static final int MAX_BYTE_ARRAY_SIZE = 128;

    public RespRequestLimitTest() {
        this.timeout = 100;
    }

    @Override
    protected RespServerConfigurationBuilder serverConfiguration(int i) {
        RespServerConfigurationBuilder builder = super.serverConfiguration(i);
        return (RespServerConfigurationBuilder)builder.maxContentLength(Integer.toString(128));
    }

    public void testKeyTooLong() {
        RedisCommands redis = this.redisConnection.sync();
        Exceptions.expectException(RedisCommandTimeoutException.class, () -> redis.set((Object)"k1".repeat(65), (Object)"v1"));
    }

    public void testValueTooLong() {
        RedisCommands redis = this.redisConnection.sync();
        Exceptions.expectException(RedisCommandTimeoutException.class, () -> redis.set((Object)"k1", (Object)"v1".repeat(65)));
    }

    public void testArgumentsMax() {
        RedisCommands redis = this.redisConnection.sync();
        Exceptions.expectException(RedisCommandTimeoutException.class, () -> redis.mset(IntStream.range(0, 8).mapToObj(Integer::toString).collect(Collectors.toMap(e -> "k" + e, e -> "v" + e))));
    }
}

