/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.test;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.netty.channel.Channel;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.resp.authentication.RespAuthenticator;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.infinispan.server.resp.test.RespTestingUtil;

public final class RespAuthenticationConfigurer {
    public static RespServerConfigurationBuilder enableAuthentication(RespServerConfigurationBuilder builder) {
        builder.authentication().enable().authenticator((RespAuthenticator)new FakeRespAuthenticator());
        return builder;
    }

    public static RedisClient createAuthenticationClient(int port) {
        RedisURI uri = RedisURI.Builder.redis((String)"127.0.0.1", (int)port).withAuthentication("default", (CharSequence)"password").withTimeout(Duration.ofMillis(15000L)).build();
        return RedisClient.create((RedisURI)uri);
    }

    private static final class FakeRespAuthenticator
    implements RespAuthenticator {
        private FakeRespAuthenticator() {
        }

        public CompletionStage<Subject> clientCertAuth(Channel channel) throws SaslException {
            return CompletableFutures.completedNull();
        }

        public CompletionStage<Subject> usernamePasswordAuth(String username, char[] password) {
            if (username.equals("default") && new String(password).equals("password")) {
                return CompletableFuture.completedFuture(RespTestingUtil.ADMIN);
            }
            return CompletableFutures.completedNull();
        }

        public boolean isClientCertAuthEnabled() {
            return false;
        }
    }
}

