/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.infinispan.commons.CacheException;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespVersion;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.Resp3Type;
import org.infinispan.server.resp.serialization.SerializationHint;

public interface ResponseWriter {
    public static final BiConsumer<Object, ResponseWriter> OK = (ignore, writer) -> writer.ok();
    public static final BiConsumer<CharSequence, ResponseWriter> SIMPLE_STRING = (s, writer) -> writer.simpleString((CharSequence)s);
    public static final BiConsumer<byte[], ResponseWriter> BULK_STRING_BYTES = (b, writer) -> writer.string((byte[])b);
    public static final BiConsumer<CharSequence, ResponseWriter> BULK_STRING = (s, writer) -> writer.string((CharSequence)s);
    public static final BiConsumer<Number, ResponseWriter> INTEGER = (i, writer) -> writer.integers((Number)i);
    public static final BiConsumer<Number, ResponseWriter> DOUBLE = (d, writer) -> writer.doubles((Number)d);
    public static final BiConsumer<Object, ResponseWriter> UNKNOWN = (o, writer) -> writer.serialize(o);
    public static final BiConsumer<JavaObjectSerializer<?>, ResponseWriter> CUSTOM = (res, writer) -> writer.write((JavaObjectSerializer)res);
    public static final BiConsumer<Collection<byte[]>, ResponseWriter> ARRAY_BULK_STRING = (c, writer) -> writer.array((Collection<?>)c, Resp3Type.BULK_STRING);
    public static final BiConsumer<Collection<? extends Number>, ResponseWriter> ARRAY_INTEGER = (c, writer) -> writer.array((Collection<?>)c, Resp3Type.INTEGER);
    public static final BiConsumer<Collection<? extends Number>, ResponseWriter> ARRAY_DOUBLE = (c, writer) -> writer.array((Collection<?>)c, Resp3Type.DOUBLE);
    public static final BiConsumer<Collection<? extends String>, ResponseWriter> ARRAY_STRING = (c, writer) -> writer.array((Collection<?>)c, Resp3Type.BULK_STRING);
    public static final BiConsumer<Set<byte[]>, ResponseWriter> SET_BULK_STRING = (s, writer) -> writer.set((Set<?>)s, Resp3Type.BULK_STRING);
    public static final BiConsumer<Map<byte[], byte[]>, ResponseWriter> MAP_BULK_STRING_KV = (m, writer) -> writer.map((Map<?, ?>)m, Resp3Type.BULK_STRING);

    public boolean isInternal();

    public RespVersion version();

    public void version(RespVersion var1);

    public void nulls();

    public void ok();

    public void queued(Object var1);

    public void simpleString(CharSequence var1);

    public void string(CharSequence var1);

    public void string(byte[] var1);

    public void integers(Number var1);

    public void doubles(Number var1);

    public void booleans(boolean var1);

    public void arrayEmpty();

    public <T> void array(Collection<T> var1, JavaObjectSerializer<T> var2);

    public void array(Collection<?> var1, Resp3Type var2);

    public void emptySet();

    public void set(Set<?> var1, Resp3Type var2);

    public <T> void set(Set<?> var1, JavaObjectSerializer<T> var2);

    public void map(Map<?, ?> var1);

    public void map(Map<?, ?> var1, Resp3Type var2);

    public void map(Map<?, ?> var1, Resp3Type var2, Resp3Type var3);

    public void map(Map<?, ?> var1, SerializationHint.KeyValueHint var2);

    public void error(CharSequence var1);

    public void error(Throwable var1);

    public <T> void write(T var1, JavaObjectSerializer<T> var2);

    public <T> void write(JavaObjectSerializer<T> var1);

    public void serialize(Object var1);

    public void writeNumericPrefix(byte var1, long var2);

    default public void syntaxError() {
        this.error("-ERR syntax error");
    }

    default public void unknownCommand() {
        this.error("-ERR unknown command");
    }

    default public void unauthorized() {
        this.error("-WRONGPASS invalid username-password pair or user is disabled.");
    }

    default public void customError(String error) {
        this.error("-ERR " + error);
    }

    default public void wrongArgumentCount(RespCommand command) {
        this.error("ERR wrong number of arguments for '" + command.getName().toLowerCase() + "' command");
    }

    default public void nanOrInfinity() {
        this.error("-ERR increment would produce NaN or Infinity");
    }

    default public void valueNotInteger() {
        this.error("-ERR value is not an integer or out of range");
    }

    default public void valueNotAValidFloat() {
        this.error("-ERR value is not a valid float");
    }

    default public void minOrMaxNotAValidFloat() {
        this.error("-ERR min or max is not a float");
    }

    default public void minOrMaxNotAValidStringRange() {
        this.error("-ERR min or max not valid string range item");
    }

    default public void transactionAborted() {
        this.error("-EXECABORT Transaction discarded because of previous errors.");
    }

    default public void mustBePositive(String argumentName) {
        this.error("-ERR value for ' " + argumentName + "' is out of range, must be positive");
    }

    default public void mustBePositive() {
        this.error("-ERR value is out of range, must be positive");
    }

    default public void wrongArgumentNumber(RespCommand command) {
        this.error("-ERR wrong number of arguments for '" + command.getName().toLowerCase() + "' command");
    }

    default public void indexOutOfRange() {
        this.error("-ERR index out of range");
    }

    default public void noSuchKey() {
        this.error("-ERR no such key");
    }

    default public void wrongType() {
        this.error("-WRONGTYPE Operation against a key holding the wrong kind of value");
    }

    public static Consumer<ResponseWriter> handleException(Throwable t) {
        Throwable ex = t;
        while (ex instanceof CompletionException || ex instanceof CacheException) {
            ex = ex.getCause();
        }
        if (ex instanceof ClassCastException) {
            return ResponseWriter::wrongType;
        }
        if (ex instanceof IllegalArgumentException && ex.getMessage().contains("No marshaller registered for object of Java type")) {
            return ResponseWriter::wrongType;
        }
        if (ex instanceof IndexOutOfBoundsException) {
            return ResponseWriter::indexOutOfRange;
        }
        if (ex instanceof NumberFormatException) {
            return ResponseWriter::valueNotInteger;
        }
        return null;
    }

    public void arrayStart(int var1);

    public void arrayEnd();

    public void arrayNext();
}

