/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization.bytebuf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.RespConstants;
import org.infinispan.server.resp.serialization.ResponseSerializer;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufferUtils;

class ByteBufPrimitiveSerializer {
    static ResponseSerializer<?, ?>[] BULK_STRING_SERIALIZERS = new ResponseSerializer[]{BulkStringSerializer.INSTANCE, BulkStringSerializer2.INSTANCE};
    static Collection<ResponseSerializer<?, ByteBufPool>> SERIALIZERS = List.of(SimpleStringSerializer.INSTANCE, BulkStringSerializer.INSTANCE, BulkStringSerializer2.INSTANCE, IntegerSerializer.INSTANCE, SimpleErrorSerializer.INSTANCE, BooleanSerializer.INSTANCE);

    ByteBufPrimitiveSerializer() {
    }

    static final class BulkStringSerializer
    implements ResponseSerializer<byte[], ByteBufPool> {
        public static final BulkStringSerializer INSTANCE = new BulkStringSerializer();

        BulkStringSerializer() {
        }

        @Override
        public void accept(byte[] bytes, ByteBufPool alloc) {
            int contentLength = bytes.length;
            ByteBuf buffer = ByteBufferUtils.writeNumericPrefix((byte)36, contentLength, alloc, contentLength + RespConstants.CRLF.length);
            buffer.writeBytes(bytes).writeBytes(RespConstants.CRLF);
        }

        @Override
        public boolean test(Object object) {
            return object instanceof byte[];
        }
    }

    static final class BulkStringSerializer2
    implements ResponseSerializer<CharSequence, ByteBufPool> {
        public static final BulkStringSerializer2 INSTANCE = new BulkStringSerializer2();

        BulkStringSerializer2() {
        }

        @Override
        public void accept(CharSequence charSequence, ByteBufPool alloc) {
            int contentLength = ByteBufUtil.utf8Bytes((CharSequence)charSequence);
            ByteBuf buffer = ByteBufferUtils.writeNumericPrefix((byte)36, contentLength, alloc, contentLength + RespConstants.CRLF.length);
            ByteBufUtil.reserveAndWriteUtf8((ByteBuf)buffer, (CharSequence)charSequence, (int)contentLength);
            buffer.writeBytes(RespConstants.CRLF);
        }

        @Override
        public boolean test(Object object) {
            if (!(object instanceof CharSequence)) {
                return false;
            }
            CharSequence cs = (CharSequence)object;
            if (cs.isEmpty()) {
                return true;
            }
            return cs.charAt(0) != '-';
        }
    }

    static final class SimpleStringSerializer
    implements ResponseSerializer<CharSequence, ByteBufPool> {
        public static final SimpleStringSerializer INSTANCE = new SimpleStringSerializer();

        SimpleStringSerializer() {
        }

        @Override
        public void accept(CharSequence charSequence, ByteBufPool alloc) {
            int contentLength = charSequence.length();
            int size = 1 + contentLength + RespConstants.CRLF.length;
            ByteBuf buffer = alloc.acquire(size).writeByte(43);
            for (int i = 0; i < charSequence.length(); ++i) {
                buffer.writeByte((int)charSequence.charAt(i));
            }
            buffer.writeBytes(RespConstants.CRLF);
        }

        @Override
        public boolean test(Object object) {
            if (!(object instanceof CharSequence)) {
                return false;
            }
            CharSequence cs = (CharSequence)object;
            if (cs.isEmpty()) {
                return false;
            }
            if (cs.charAt(0) == '-') {
                return false;
            }
            for (int i = 0; i < cs.length(); ++i) {
                char c = cs.charAt(i);
                if (c == RespConstants.CRLF[0] || cs.charAt(i) == RespConstants.CRLF[1]) {
                    return false;
                }
                if ((c & 0x80) == 0) continue;
                return false;
            }
            return true;
        }
    }

    static final class IntegerSerializer
    implements ResponseSerializer<Number, ByteBufPool> {
        public static final IntegerSerializer INSTANCE = new IntegerSerializer();

        IntegerSerializer() {
        }

        @Override
        public void accept(Number number, ByteBufPool alloc) {
            ByteBufferUtils.writeNumericPrefix((byte)58, number.longValue(), alloc);
        }

        @Override
        public boolean test(Object object) {
            if (object instanceof Number) {
                return !(object instanceof Double) && !(object instanceof Float) && !(object instanceof BigDecimal);
            }
            return false;
        }
    }

    static final class SimpleErrorSerializer
    implements ResponseSerializer<CharSequence, ByteBufPool> {
        public static final SimpleErrorSerializer INSTANCE = new SimpleErrorSerializer();

        SimpleErrorSerializer() {
        }

        @Override
        public void accept(CharSequence charSequence, ByteBufPool alloc) {
            int length = charSequence.length();
            for (int i = 0; i < charSequence.length(); ++i) {
                char charAt = charSequence.charAt(i);
                if (charAt != '\n' && charAt != '\r') continue;
                ++length;
            }
            int total = length + RespConstants.CRLF.length;
            ByteBuf buffer = alloc.acquire(total);
            block5: for (int i = 0; i < charSequence.length(); ++i) {
                char charAt = charSequence.charAt(i);
                switch (charAt) {
                    case '\n': {
                        buffer.writeByte(92);
                        buffer.writeByte(110);
                        continue block5;
                    }
                    case '\r': {
                        buffer.writeByte(92);
                        buffer.writeByte(114);
                        continue block5;
                    }
                    default: {
                        buffer.writeByte((int)charAt);
                    }
                }
            }
            buffer.writeBytes(RespConstants.CRLF);
        }

        @Override
        public boolean test(Object object) {
            if (!(object instanceof CharSequence)) {
                return false;
            }
            CharSequence cs = (CharSequence)object;
            return !cs.isEmpty() && cs.charAt(0) == '-';
        }
    }

    static final class BooleanSerializer
    implements ResponseSerializer<Boolean, ByteBufPool> {
        public static final BooleanSerializer INSTANCE = new BooleanSerializer();
        private static final byte TRUE = 116;
        private static final byte FALSE = 102;

        BooleanSerializer() {
        }

        @Override
        public void accept(Boolean b, ByteBufPool alloc) {
            int length = 2 + RespConstants.CRLF.length;
            alloc.acquire(length).writeByte(35).writeByte(Boolean.TRUE.equals(b) ? 116 : 102).writeBytes(RespConstants.CRLF);
        }

        @Override
        public boolean test(Object object) {
            return object instanceof Boolean;
        }
    }

    static final class NullSerializer
    implements ResponseSerializer<Object, ByteBufPool> {
        public static final NullSerializer INSTANCE = new NullSerializer();

        NullSerializer() {
        }

        @Override
        public void accept(Object object, ByteBufPool alloc) {
            assert (object == null) : "Only handle null values";
            alloc.acquire(1 + RespConstants.CRLF.length).writeByte(95).writeBytes(RespConstants.CRLF);
        }

        @Override
        public boolean test(Object object) {
            return object == null;
        }
    }
}

