/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.sortedset.internal;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.infinispan.multimap.impl.EmbeddedMultimapSortedSetCache;
import org.infinispan.multimap.impl.SortedSetAddArgs;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.sortedset.ZSetCommonUtils;
import org.infinispan.server.resp.serialization.ResponseWriter;

public abstract class AGGCommand
extends RespCommand
implements Resp3Command {
    private static final BiConsumer<Object, ResponseWriter> SERIALIZER = (res, writer) -> {
        if (res instanceof Long) {
            Long l = (Long)res;
            writer.integers(l);
            return;
        }
        ZSetCommonUtils.ZOperationResponse zres = (ZSetCommonUtils.ZOperationResponse)res;
        writer.write(zres, zres);
    };
    public static final String WEIGHTS = "WEIGHTS";
    public static final String AGGREGATE = "AGGREGATE";
    public static final String WITHSCORES = "WITHSCORES";
    private final AGGCommandType aggCommandType;

    protected AGGCommand(int arity, int firstKeyPos, int lastKeyPos, int steps, AGGCommandType aggCommandType) {
        super(arity, firstKeyPos, lastKeyPos, steps);
        this.aggCommandType = aggCommandType;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        int i;
        int numberOfKeysArg;
        int pos = 0;
        byte[] destination = this.getArity() == -4 ? arguments.get(pos++) : null;
        try {
            numberOfKeysArg = ArgumentUtils.toInt(arguments.get(pos++));
        }
        catch (NumberFormatException ex) {
            handler.writer().valueNotInteger();
            return handler.myStage();
        }
        if (numberOfKeysArg <= 0) {
            handler.writer().customError("at least 1 input key is needed for '" + this.getName().toLowerCase() + "' command");
            return handler.myStage();
        }
        ArrayList<byte[]> keys = new ArrayList<byte[]>(numberOfKeysArg);
        for (int i2 = 0; i2 < numberOfKeysArg && pos < arguments.size(); ++i2) {
            keys.add(arguments.get(pos++));
        }
        if (keys.size() < numberOfKeysArg) {
            handler.writer().syntaxError();
            return handler.myStage();
        }
        ArrayList<Double> weights = new ArrayList<Double>();
        boolean withScores = false;
        SortedSetBucket.AggregateFunction aggOption = SortedSetBucket.AggregateFunction.SUM;
        block17: while (pos < arguments.size()) {
            String arg;
            switch (arg = new String(arguments.get(pos++)).toUpperCase()) {
                case "WITHSCORES": {
                    if (this.getArity() == -3) {
                        withScores = true;
                        continue block17;
                    }
                    handler.writer().syntaxError();
                    return handler.myStage();
                }
                case "AGGREGATE": {
                    if (pos < arguments.size()) {
                        try {
                            aggOption = SortedSetBucket.AggregateFunction.valueOf((String)new String(arguments.get(pos++)).toUpperCase());
                            continue block17;
                        }
                        catch (Exception ex) {
                            handler.writer().syntaxError();
                            return handler.myStage();
                        }
                    }
                    handler.writer().syntaxError();
                    return handler.myStage();
                }
                case "WEIGHTS": {
                    try {
                        for (i = 0; i < numberOfKeysArg && pos < arguments.size(); ++i) {
                            weights.add(ArgumentUtils.toDouble(arguments.get(pos++)));
                        }
                    }
                    catch (NumberFormatException ex) {
                        handler.writer().customError("weight value is not a float");
                        return handler.myStage();
                    }
                    if (weights.size() == numberOfKeysArg) continue block17;
                    handler.writer().syntaxError();
                    return handler.myStage();
                }
            }
            handler.writer().syntaxError();
            return handler.myStage();
        }
        EmbeddedMultimapSortedSetCache<byte[], byte[]> sortedSetCache = handler.getSortedSeMultimap();
        SortedSetBucket.AggregateFunction finalAggFunction = aggOption;
        CompletionStage<Object> aggValues = this.aggCommandType == AGGCommandType.UNION ? sortedSetCache.union((Object)((byte[])keys.get(0)), null, AGGCommand.computeWeight(weights, 0), finalAggFunction) : sortedSetCache.inter((Object)((byte[])keys.get(0)), null, AGGCommand.computeWeight(weights, 0), finalAggFunction);
        for (i = 1; i < keys.size(); ++i) {
            byte[] setName = (byte[])keys.get(i);
            double weight = AGGCommand.computeWeight(weights, i);
            aggValues = aggValues.thenCompose(c1 -> {
                if (this.aggCommandType == AGGCommandType.UNION) {
                    return sortedSetCache.union((Object)setName, c1, weight, finalAggFunction);
                }
                return c1.isEmpty() ? CompletableFuture.completedFuture(c1) : sortedSetCache.inter((Object)setName, c1, weight, finalAggFunction);
            });
        }
        boolean finalWithScores = withScores;
        CompletionStage cs = aggValues.thenCompose(result -> {
            CompletableFuture<ZSetCommonUtils.ZOperationResponse> n = destination != null ? sortedSetCache.addMany((Object)destination, result, SortedSetAddArgs.create().replace().build()) : CompletableFuture.completedFuture(ZSetCommonUtils.response(result, finalWithScores));
            return n;
        });
        return handler.stageToReturn(cs, ctx, SERIALIZER);
    }

    private static double computeWeight(List<Double> weights, int index) {
        return weights.isEmpty() ? 1.0 : weights.get(index);
    }

    protected static enum AGGCommandType {
        UNION,
        INTER;

    }
}

