/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import org.infinispan.server.resp.json.InfinispanJacksonJsonNodeProvider;

public class JSONUtil {
    private static byte JSON_ROOT_BYTE = (byte)36;
    public static byte[] JSON_ROOT = new byte[]{36};
    public static final Configuration configForDefiniteSet = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).options(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    public static ParseContext parserForDefiniteSet = JsonPath.using((Configuration)configForDefiniteSet);
    public static final Configuration configForSet = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    public static ParseContext parserForSet = JsonPath.using((Configuration)configForSet);
    public static final Configuration configForGet = Configuration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST}).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider((JsonProvider)new InfinispanJacksonJsonNodeProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    public static ParseContext parserForGet = JsonPath.using((Configuration)configForGet);
    public static final Configuration configForMod = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    public static ParseContext parserForMod = JsonPath.using((Configuration)configForMod);
    public static final Configuration configForDefiniteMod = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).options(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    public static ParseContext parserForDefiniteMod = JsonPath.using((Configuration)configForMod);
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public static void writeBytes(ObjectOutput output, byte[] b) throws IOException {
        output.writeInt(b.length);
        if (b.length > 0) {
            output.write(b);
        }
    }

    public static byte[] readBytes(ObjectInput input) throws IOException {
        int length = input.readInt();
        if (length < 0) {
            throw new IOException("Length cannot be less than 0");
        }
        byte[] b = new byte[length];
        input.read(b);
        return b;
    }

    public static boolean isRoot(byte[] path) {
        return path != null && path.length == 1 && path[0] == JSON_ROOT_BYTE;
    }

    public static byte[] toJsonPath(byte[] path) {
        if (!JSONUtil.isJsonPath(path)) {
            if (path.length >= 1 && path[0] == 46) {
                if (path.length == 1) {
                    return JSON_ROOT;
                }
                byte[] result = new byte[path.length + 1];
                result[0] = JSON_ROOT_BYTE;
                System.arraycopy(path, 0, result, 1, path.length);
                return result;
            }
            byte[] result = new byte[path.length + 2];
            result[0] = JSON_ROOT_BYTE;
            result[1] = 46;
            System.arraycopy(path, 0, result, 2, path.length);
            return result;
        }
        return path;
    }

    public static boolean isJsonPath(byte[] path) {
        return path != null && path.length > 0 && path[0] == JSON_ROOT_BYTE && (path.length < 2 || path[1] == 46 || path[1] == 91);
    }

    public static boolean isJsonPath(String path) {
        return path == null ? false : JSONUtil.isJsonPath(path.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean isValueInvalid(byte[] value) {
        if (value.length == 0) {
            return true;
        }
        if (value.length == 1) {
            return JSONUtil.isSingleCharInvalid(value[0]);
        }
        if (value.length == 2) {
            return JSONUtil.isDoubleCharInvalid(value);
        }
        return false;
    }

    private static boolean isSingleCharInvalid(byte value) {
        switch (value) {
            case 0: 
            case 10: 
            case 12: 
            case 32: 
            case 39: 
            case 91: 
            case 92: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDoubleCharInvalid(byte[] value) {
        if (value[0] == 92 && (value[1] == 92 || value[1] == 34 || value[1] == 91)) {
            return true;
        }
        if (value[0] == 123 && value[1] == 93) {
            return true;
        }
        return value[0] == 91 && value[1] == 125;
    }
}

