/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

public class JsonClearFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, Integer> {
    public static final String ERR_PATH_CAN_T_BE_NULL = "path can't be null";
    public static final AdvancedExternalizer<JsonClearFunction> EXTERNALIZER = new Externalizer();
    byte[] path;

    public JsonClearFunction(byte[] path) {
        Objects.requireNonNull(path, ERR_PATH_CAN_T_BE_NULL);
        this.path = path;
    }

    public Integer apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        if (doc == null) {
            throw new CacheException("could not perform this operation on a key that doesn't exist");
        }
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext modifiableCtx = JSONUtil.parserForMod.parse((Object)rootNode);
            DocumentContext getForContext = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode pathList = (ArrayNode)modifiableCtx.read(jpath);
            int changed = 0;
            for (JsonNode pathAsNode : pathList) {
                Number numberValue;
                String pathAsText = pathAsNode.asText();
                ArrayNode node = (ArrayNode)getForContext.read(pathAsText, new Predicate[0]);
                JsonNode jsonNode = node.get(0);
                if (JSONUtil.isRoot(pathAsText.getBytes(StandardCharsets.UTF_8))) {
                    ObjectNode clearedNode = null;
                    if (jsonNode.isObject()) {
                        clearedNode = JSONUtil.objectMapper.createObjectNode();
                    } else if (jsonNode.isArray()) {
                        clearedNode = JSONUtil.objectMapper.createArrayNode();
                    } else if (jsonNode.isNumber()) {
                        clearedNode = JSONUtil.objectMapper.valueToTree((Object)0);
                    }
                    if (clearedNode == null) {
                        return 0;
                    }
                    entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)clearedNode)), new MetaParam.Writable[0]);
                    return 1;
                }
                if (jsonNode.isObject()) {
                    ObjectNode objectNode = (ObjectNode)node.get(0);
                    if (objectNode.properties().isEmpty()) continue;
                    modifiableCtx.set(pathAsText, (Object)JSONUtil.objectMapper.createObjectNode(), new Predicate[0]);
                    ++changed;
                    continue;
                }
                if (jsonNode.isArray()) {
                    ArrayNode arrayNode = (ArrayNode)node.get(0);
                    if (arrayNode.isEmpty()) continue;
                    modifiableCtx.set(pathAsText, (Object)JSONUtil.objectMapper.createArrayNode(), new Predicate[0]);
                    ++changed;
                    continue;
                }
                if (!jsonNode.isNumber() || (numberValue = node.get(0).numberValue()).intValue() == 0) continue;
                modifiableCtx.set(pathAsText, (Object)0, new Predicate[0]);
                ++changed;
            }
            if (changed > 0) {
                entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootNode)), new MetaParam.Writable[0]);
            }
            return changed;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonClearFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonClearFunction object) throws IOException {
            JSONUtil.writeBytes(output, object.path);
        }

        public JsonClearFunction readObject(ObjectInput input) throws IOException {
            return new JsonClearFunction(JSONUtil.readBytes(input));
        }

        public Set<Class<? extends JsonClearFunction>> getTypeClasses() {
            return Collections.singleton(JsonClearFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_CLEAR_FUNCTION;
        }
    }
}

