/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

public class JsonTypeFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<String>> {
    public static final String ERR_PATH_CAN_T_BE_NULL = "path can't be null";
    public static final AdvancedExternalizer<JsonTypeFunction> EXTERNALIZER = new Externalizer();
    private static final String STRING = "string";
    private static final String BOOLEAN = "boolean";
    private static final String INTEGER = "integer";
    private static final String NUMBER = "number";
    private static final String ARRAY = "array";
    private static final String NULL = "null";
    private static final String UNKNOWN = "unknown";
    private static final String OBJECT = "object";
    byte[] path;

    public JsonTypeFunction(byte[] path) {
        Objects.requireNonNull(path, ERR_PATH_CAN_T_BE_NULL);
        this.path = path;
    }

    public List<String> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        if (doc == null) {
            return null;
        }
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode nodeList = (ArrayNode)jpCtx.read(jpath);
            ArrayList<String> result = new ArrayList<String>();
            for (JsonNode jsonNode : nodeList) {
                result.add(this.mapType(jsonNode));
            }
            return result;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private String mapType(JsonNode jsonNode) {
        if (jsonNode.isTextual()) {
            return STRING;
        }
        if (jsonNode.isBoolean()) {
            return BOOLEAN;
        }
        if (jsonNode.isInt()) {
            return INTEGER;
        }
        if (jsonNode.isNumber()) {
            return NUMBER;
        }
        if (jsonNode.isArray()) {
            return ARRAY;
        }
        if (jsonNode.isNull()) {
            return NULL;
        }
        if (jsonNode.isObject()) {
            return OBJECT;
        }
        return UNKNOWN;
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonTypeFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonTypeFunction object) throws IOException {
            JSONUtil.writeBytes(output, object.path);
        }

        public JsonTypeFunction readObject(ObjectInput input) throws IOException {
            byte[] path = JSONUtil.readBytes(input);
            return new JsonTypeFunction(path);
        }

        public Set<Class<? extends JsonTypeFunction>> getTypeClasses() {
            return Collections.singleton(JsonTypeFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_TYPE_FUNCTION;
        }
    }
}

