/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.protocol.ProtocolVersion;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.RESPHashFunctionPartitioner;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.infinispan.server.resp.test.RespAuthenticationConfigurer;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.infinispan.server.resp.test.TestSetup;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.AfterClass;

public abstract class AbstractRespTest
extends MultipleCacheManagersTest {
    private List<RespServer> servers;
    private List<AbstractRedisClient> clients;
    private boolean authorization;
    protected int timeout = 15000;
    protected final ControlledTimeService timeService = new ControlledTimeService();

    protected void createCacheManagers() {
        TestSetup setup = this.setup();
        if (this.authorization) {
            setup = TestSetup.authorizationEnabled(setup);
        }
        this.servers = new ArrayList<RespServer>(setup.clusterSize());
        this.clients = new ArrayList<AbstractRedisClient>(setup.clusterSize());
        for (int i = 0; i < setup.clusterSize(); ++i) {
            EmbeddedCacheManager ecm = setup.createCacheManager(this::defaultRespConfiguration, this::amendGlobalConfiguration, this::amendConfiguration);
            TestingUtil.replaceComponent((CacheContainer)ecm, TimeService.class, (Object)this.timeService, (boolean)true);
            this.cacheManagers.add(ecm);
            RespServer server = this.createRespServer(i, ecm);
            this.servers.add(server);
        }
        for (RespServer server : this.servers) {
            RedisClient c = this.createRedisClient(server.getPort());
            if (c == null) continue;
            c.setOptions(this.defineRespClientOptions());
            this.clients.add((AbstractRedisClient)c);
        }
        this.afterSetupFinished();
    }

    protected final <T extends AbstractRespTest> T self() {
        return (T)((Object)this);
    }

    protected <T extends AbstractRespTest> T withAuthorization() {
        this.authorization = true;
        return this.self();
    }

    protected void amendGlobalConfiguration(GlobalConfigurationBuilder builder) {
    }

    protected abstract TestSetup setup();

    protected void amendConfiguration(ConfigurationBuilder configurationBuilder) {
    }

    protected void afterSetupFinished() {
    }

    protected ClientOptions defineRespClientOptions() {
        return ClientOptions.builder().protocolVersion(ProtocolVersion.RESP3).timeoutOptions(TimeoutOptions.enabled((Duration)Duration.of(this.timeout, ChronoUnit.MILLIS))).build();
    }

    protected RedisClient createRedisClient(int port) {
        if (this.authorization) {
            return RespAuthenticationConfigurer.createAuthenticationClient(port);
        }
        return RespTestingUtil.createClient(this.timeout, port);
    }

    protected RespServer createRespServer(int i, EmbeddedCacheManager ecm) {
        RespServerConfiguration serverConfiguration = this.serverConfiguration(i).build();
        return this.authorization ? (RespServer)Security.doAs((Subject)RespTestingUtil.ADMIN, () -> RespTestingUtil.startServer(ecm, serverConfiguration)) : RespTestingUtil.startServer(ecm, serverConfiguration);
    }

    protected RespServerConfigurationBuilder serverConfiguration(int i) {
        String serverName = TestResourceTracker.getCurrentTestShortName();
        RespServerConfigurationBuilder rscb = (RespServerConfigurationBuilder)((RespServerConfigurationBuilder)((RespServerConfigurationBuilder)new RespServerConfigurationBuilder().name(serverName)).host("127.0.0.1")).port(RespTestingUtil.port() + i);
        return this.authorization ? RespAuthenticationConfigurer.enableAuthentication(rscb) : rscb;
    }

    protected final <T extends AbstractRedisClient> T client(int i) {
        return (T)this.clients.get(i);
    }

    protected final RespServer server(int i) {
        return this.servers.get(i);
    }

    protected final Cache<String, String> respCache(int i) {
        return this.manager(i).getCache(((RespServerConfiguration)this.server(i).getConfiguration()).defaultCacheName());
    }

    protected final ConfigurationBuilder defaultRespConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.encoding().key().mediaType(MediaType.APPLICATION_OCTET_STREAM);
        builder.clustering().hash().keyPartitioner((KeyPartitioner)new RESPHashFunctionPartitioner()).numSegments(256);
        return builder;
    }

    protected final boolean isAuthorizationEnabled() {
        return this.authorization;
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        if (this.clients != null) {
            for (AbstractRedisClient client : this.clients) {
                RespTestingUtil.killClient(client);
            }
        }
        if (this.servers != null) {
            for (RespServer server : this.servers) {
                RespTestingUtil.killServer(server);
            }
        }
        super.destroy();
    }

    protected String parameters() {
        return "[authz=" + this.authorization + "]";
    }
}

