/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.ExpireArgs;
import io.lettuce.core.FlushMode;
import io.lettuce.core.KeyScanArgs;
import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.SetArgs;
import io.lettuce.core.SortArgs;
import io.lettuce.core.StrAlgoArgs;
import io.lettuce.core.StringMatchResult;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.json.DefaultJsonParser;
import io.lettuce.core.json.JsonPath;
import io.lettuce.core.json.JsonValue;
import io.lettuce.core.output.ArrayOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.security.auth.Subject;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.test.skip.SkipTestNG;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.security.Security;
import org.infinispan.server.resp.RespTypes;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.commands.Commands;
import org.infinispan.server.resp.test.CommonRespTests;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespSingleNodeTest")
public class RespSingleNodeTest
extends SingleNodeRespBaseTest {
    private CacheMode cacheMode = CacheMode.LOCAL;
    private boolean simpleCache;

    public Object[] factory() {
        return new Object[]{new RespSingleNodeTest(), new RespSingleNodeTest().withAuthorization(), new RespSingleNodeTest().simpleCache(), new RespSingleNodeTest().simpleCache().withAuthorization()};
    }

    protected RespSingleNodeTest simpleCache() {
        this.cacheMode = CacheMode.LOCAL;
        this.simpleCache = true;
        return this;
    }

    @Override
    protected String parameters() {
        return super.parameters() + " -- [simpleCache=" + this.simpleCache + ", cacheMode=" + String.valueOf(this.cacheMode) + "]";
    }

    @Override
    protected void amendConfiguration(ConfigurationBuilder configurationBuilder) {
        if (this.simpleCache) {
            configurationBuilder.clustering().cacheMode(CacheMode.LOCAL).simpleCache(true);
        } else {
            configurationBuilder.clustering().cacheMode(this.cacheMode);
        }
    }

    @Test
    public void testSetMultipleOptions() {
        RedisCommands redis = this.redisConnection.sync();
        SetArgs args = SetArgs.Builder.xx();
        Assertions.assertThat((String)redis.set((Object)"key", (Object)"value", args)).isNull();
        args = SetArgs.Builder.nx();
        Assertions.assertThat((String)redis.set((Object)"key", (Object)"value", args)).isEqualTo("OK");
        Assertions.assertThat((String)((String)redis.get((Object)"key"))).isEqualTo("value");
        Assertions.assertThat((String)redis.set((Object)"key", (Object)"value3", args)).isNull();
        Assertions.assertThat((String)((String)redis.get((Object)"key"))).isEqualTo("value");
        args = SetArgs.Builder.xx();
        Assertions.assertThat((String)redis.set((Object)"key", (Object)"value2", args)).isEqualTo("OK");
        Assertions.assertThat((String)((String)redis.get((Object)"key"))).isEqualTo("value2");
        args = SetArgs.Builder.ex((long)60L);
        Assertions.assertThat((String)((String)redis.setGet((Object)"key", (Object)"value3", args))).isEqualTo("value2");
        CacheEntry entry = this.cache.getAdvancedCache().withMediaType(MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_OCTET_STREAM).getCacheEntry((Object)"key".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThat((String)new String((byte[])entry.getValue())).isEqualTo("value3");
        Assertions.assertThat((long)entry.getLifespan()).isEqualTo(60000L);
        args = SetArgs.Builder.keepttl();
        Assertions.assertThat((String)redis.set((Object)"key", (Object)"value4", args)).isEqualTo("OK");
        entry = this.cache.getAdvancedCache().withMediaType(MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_OCTET_STREAM).getCacheEntry((Object)"key".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThat((String)new String((byte[])entry.getValue())).isEqualTo("value4");
        Assertions.assertThat((long)entry.getLifespan()).isEqualTo(60000L);
        args = SetArgs.Builder.keepttl().xx();
        Assertions.assertThat((String)redis.set((Object)"key", (Object)"value5", args)).isEqualTo("OK");
        entry = this.cache.getAdvancedCache().withMediaType(MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_OCTET_STREAM).getCacheEntry((Object)"key".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThat((String)new String((byte[])entry.getValue())).isEqualTo("value5");
        Assertions.assertThat((long)entry.getLifespan()).isEqualTo(60000L);
        args = SetArgs.Builder.keepttl().nx();
        String res = redis.set((Object)"key", (Object)"value5", args);
        Assertions.assertThat((String)res).isNull();
        args = SetArgs.Builder.keepttl().nx();
        Assertions.assertThat((String)redis.set((Object)"randomKey", (Object)"value", args)).isEqualTo("OK");
        args = SetArgs.Builder.keepttl();
        Assertions.assertThat((String)redis.set((Object)"otherKey", (Object)"value", args)).isEqualTo("OK");
        redis.del((Object[])new String[]{"key", "randomKey", "otherKey"});
    }

    public void testConditionalSetOperationWithReturn() {
        RedisCommands redis = this.redisConnection.sync();
        String key = UUID.randomUUID().toString();
        SetArgs args = SetArgs.Builder.xx();
        Assertions.assertThat((String)((String)redis.setGet((Object)key, (Object)"something", args))).isNull();
        Assertions.assertThat((String)((String)redis.get((Object)key))).isNull();
        args = SetArgs.Builder.nx();
        String res = (String)redis.setGet((Object)key, (Object)"value", args);
        Assertions.assertThat((String)res).isNull();
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo("value");
        Assertions.assertThat((String)((String)redis.setGet((Object)key, (Object)"value2", args))).isEqualTo("value");
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo("value");
        args = SetArgs.Builder.xx();
        Assertions.assertThat((String)((String)redis.setGet((Object)key, (Object)"value2", args))).isEqualTo("value");
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo("value2");
    }

    public void testSetMGet() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)"k1", (Object)"v1");
        redis.set((Object)"k3", (Object)"v3");
        redis.set((Object)"k4", (Object)"v4");
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>(4);
        expected.add(KeyValue.just((Object)"k1", (Object)"v1"));
        expected.add(KeyValue.empty((Object)"k2"));
        expected.add(KeyValue.just((Object)"k3", (Object)"v3"));
        expected.add(KeyValue.just((Object)"k4", (Object)"v4"));
        List results = redis.mget((Object[])new String[]{"k1", "k2", "k3", "k4"});
        Assertions.assertThat((List)results).containsExactlyElementsOf(expected);
    }

    public void testSetEmptyStringMGet() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)"k1", (Object)"");
        redis.set((Object)"k3", (Object)"value2");
        Assertions.assertThat((String)((String)redis.get((Object)"k1"))).isEmpty();
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>(3);
        expected.add(KeyValue.just((Object)"k1", (Object)""));
        expected.add(KeyValue.empty((Object)"k2"));
        expected.add(KeyValue.just((Object)"k3", (Object)"value2"));
        List results = redis.mget((Object[])new String[]{"k1", "k2", "k3"});
        Assertions.assertThat((List)results).containsExactlyElementsOf(expected);
    }

    public void testMSetMGet() {
        RedisCommands redis = this.redisConnection.sync();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("k1", "v1");
        values.put("k3", "v3");
        values.put("k4", "v4");
        redis.mset(values);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>(4);
        expected.add(KeyValue.just((Object)"k1", (Object)"v1"));
        expected.add(KeyValue.empty((Object)"k2"));
        expected.add(KeyValue.just((Object)"k3", (Object)"v3"));
        expected.add(KeyValue.just((Object)"k4", (Object)"v4"));
        List results = redis.mget((Object[])new String[]{"k1", "k2", "k3", "k4"});
        Assertions.assertThat((List)results).containsExactlyElementsOf(expected);
    }

    public void testSetGetDelete() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)"k1", (Object)"v1");
        String v = (String)redis.get((Object)"k1");
        Assertions.assertThat((String)v).isEqualTo("v1");
        redis.del((Object[])new String[]{"k1"});
        Assertions.assertThat((String)((String)redis.get((Object)"k1"))).isNull();
        Assertions.assertThat((String)((String)redis.get((Object)"something"))).isNull();
    }

    @Test
    public void testDelNonStrings() {
        RedisCommands redis = this.redisConnection.sync();
        redis.rpush((Object)"list1", (Object[])new String[]{"v1", "v2", "v3"});
        long c = redis.del((Object[])new String[]{"list1"});
        Assertions.assertThat((long)c).isEqualTo(1L);
        redis.sadd((Object)"set1", (Object[])new String[]{"v1", "v2", "v3"});
        redis.set((Object)"string1", (Object)"v1");
        c = redis.del((Object[])new String[]{"set1", "string1"});
        Assertions.assertThat((long)c).isEqualTo(2L);
        redis.rpush((Object)"list1", (Object[])new String[]{"v1", "v2", "v3"});
        redis.sadd((Object)"set1", (Object[])new String[]{"v1", "v2", "v3"});
        c = redis.del((Object[])new String[]{"list1", "set1"});
        Assertions.assertThat((long)c).isEqualTo(2L);
        redis.sadd((Object)"set1", (Object[])new String[]{"v1", "v2", "v3"});
        c = redis.del((Object[])new String[]{"set1", "non-existent"});
        Assertions.assertThat((long)c).isEqualTo(1L);
    }

    public void testSetGetBigValue() {
        RedisCommands redis = this.redisConnection.sync();
        StringBuilder sb = new StringBuilder();
        String charsToChoose = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        for (int i = 0; i < 10000; ++i) {
            sb.append(charsToChoose.charAt(ThreadLocalRandom.current().nextInt(charsToChoose.length())));
        }
        String actualString = sb.toString();
        redis.set((Object)"k1", (Object)actualString);
        Assertions.assertThat((String)((String)redis.get((Object)"k1"))).isEqualTo(actualString);
    }

    public void testPingNoArg() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.ping()).isEqualTo("PONG");
    }

    @Test
    public void testPingArg() {
        StringCodec codec = StringCodec.UTF8;
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)((String)redis.dispatch((ProtocolKeyword)CommandType.PING, (CommandOutput)new StatusOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).add("Hey")))).isEqualTo("Hey");
    }

    public void testEcho() {
        RedisCommands redis = this.redisConnection.sync();
        String stringToSend = "HI THERE!";
        Assertions.assertThat((String)((String)redis.echo((Object)stringToSend))).isEqualTo(stringToSend);
    }

    public void testCommand() {
        RedisCommands redis = this.redisConnection.sync();
        List commands = redis.command();
        Assertions.assertThat((int)commands.size()).isEqualTo(Commands.all().size());
    }

    public void testAuth() {
        RedisCommands redis = this.redisConnection.sync();
        Exceptions.expectException(RedisCommandExecutionException.class, (String)"WRONGPASS invalid username-password pair or user is disabled.", () -> redis.auth("user", (CharSequence)"pass"));
    }

    public void testNotImplementedCommand() {
        RedisCommands redis = this.redisConnection.sync();
        Exceptions.expectException(RedisCommandExecutionException.class, (String)"ERR unknown command", () -> redis.xdel((Object)"not-supported", new String[]{"should error"}));
    }

    public void testPipeline() throws ExecutionException, InterruptedException, TimeoutException {
        CommonRespTests.testPipeline((StatefulRedisConnection<String, String>)this.redisConnection);
    }

    @Test
    public void testUpperLowercase() {
        RedisCommands redis = this.redisConnection.sync();
        CommandArgs args = new CommandArgs((RedisCodec)StringCodec.UTF8).addValue((Object)"Hello");
        String response = (String)redis.dispatch((ProtocolKeyword)new SimpleCommand("ECHO"), (CommandOutput)new StatusOutput((RedisCodec)StringCodec.UTF8), args);
        AssertJUnit.assertEquals((String)"Hello", (String)response);
        response = (String)redis.dispatch((ProtocolKeyword)new SimpleCommand("echo"), (CommandOutput)new StatusOutput((RedisCodec)StringCodec.UTF8), args);
        AssertJUnit.assertEquals((String)"Hello", (String)response);
    }

    @Test
    public void testInfo() {
        RedisCommands redis = this.redisConnection.sync();
        String info = redis.info();
        Assertions.assertThat((String)info).contains(new CharSequence[]{"# Server"});
        Assertions.assertThat((String)info).contains(new CharSequence[]{"# Client"});
        Assertions.assertThat((String)info).contains(new CharSequence[]{"# Modules"});
        Assertions.assertThat((String)info).contains(new CharSequence[]{"# Persistence"});
        Assertions.assertThat((String)info).contains(new CharSequence[]{"# Keyspace"});
        info = redis.info("server");
        Assertions.assertThat((String)info).contains(new CharSequence[]{"# Server"});
        Assertions.assertThat((String)info).doesNotContain(new CharSequence[]{"# Client"});
    }

    @Test
    public void testModule() {
        RedisCommands redis = this.redisConnection.sync();
        CommandArgs args = new CommandArgs((RedisCodec)StringCodec.UTF8).addValue((Object)"LIST");
        List response = (List)redis.dispatch((ProtocolKeyword)new SimpleCommand("MODULE"), (CommandOutput)new ArrayOutput((RedisCodec)StringCodec.UTF8), args);
        AssertJUnit.assertEquals((int)0, (int)response.size());
    }

    @Test
    public void testDbSize() {
        RedisCommands redis = this.redisConnection.sync();
        Long size = redis.dbsize();
        Assertions.assertThat((Long)size).isEqualTo((long)this.cache.size());
        redis.set((Object)"dbsize-key", (Object)"dbsize-value");
        Assertions.assertThat((Long)redis.dbsize()).isEqualTo(size + 1L);
    }

    @Test
    public void testClient() {
        RedisCommands redis = this.redisConnection.sync();
        Long l = redis.clientId();
        Assertions.assertThat((Long)l).isNotNull();
        String list = redis.clientList();
        Assertions.assertThat((String)list).contains(new CharSequence[]{"id=" + l});
        Assertions.assertThat((String)list).contains(new CharSequence[]{"name= "});
        redis.clientSetname((Object)"test");
        Assertions.assertThat((String)((String)redis.clientGetname())).isEqualTo("test");
        list = redis.clientList();
        Assertions.assertThat((String)list).contains(new CharSequence[]{"name=test"});
        redis.clientSetinfo("lib-ver", "15.0");
        redis.clientSetinfo("lib-name", "Infinispan-RESP");
        list = redis.clientList();
        ((AbstractStringAssert)Assertions.assertThat((String)list).contains(new CharSequence[]{"lib-ver=15.0"})).contains(new CharSequence[]{"lib-name=Infinispan-RESP"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> redis.clientSetinfo("lib-ver", "wrong version")).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR lib-ver cannot contain spaces, newlines or special characters.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> redis.clientSetinfo("lib-name", "Jos\u00e9")).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR lib-name cannot contain spaces, newlines or special characters.");
    }

    @Test
    public void testExists() {
        RedisCommands redis = this.redisConnection.sync();
        IntStream.range(0, 10).map(i -> 2 * i).forEach(i -> redis.set((Object)("key" + i), (Object)("value " + i)));
        Object[] keys = (String[])IntStream.range(0, 21).boxed().map(v -> "key" + v).toArray(String[]::new);
        Assertions.assertThat((Long)redis.exists(keys)).isEqualTo(10L);
    }

    @Test
    public void testExistsMisc() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)"key1", (Object)"value1");
        redis.set((Object)"key2", (Object)"value2");
        redis.set((Object)"key3", (Object)"value3");
        Assertions.assertThat((Long)redis.exists((Object[])new String[]{"key1"})).isEqualTo(1L);
        Assertions.assertThat((Long)redis.exists((Object[])new String[]{"key1", "key2", "key3"})).isEqualTo(3L);
        Assertions.assertThat((Long)redis.exists((Object[])new String[]{"nonexistent-key"})).isEqualTo(0L);
        Assertions.assertThat((Long)redis.exists((Object[])new String[]{"key1", "nonexistent-key", "key2"})).isEqualTo(2L);
        Assertions.assertThat((Long)redis.exists((Object[])new String[]{"key1", "nonexistent-key", "key1"})).isEqualTo(2L);
        Assertions.assertThat((Long)redis.exists((Object[])new String[]{"nonexistent-key", "nonexistent-key", "key1"})).isEqualTo(1L);
    }

    @Test
    public void testFlushDb() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k((int)0), (Object)TestingUtil.v((int)0));
        Assertions.assertThat((Long)redis.dbsize()).isGreaterThan(0L);
        redis.flushdb(FlushMode.SYNC);
        Assertions.assertThat((Long)redis.dbsize()).isEqualTo(0L);
        redis.set((Object)TestingUtil.k((int)0), (Object)TestingUtil.v((int)0));
        Assertions.assertThat((Long)redis.dbsize()).isGreaterThan(0L);
        redis.flushdb(FlushMode.ASYNC);
        RespSingleNodeTest.eventually(() -> redis.dbsize() == 0L);
    }

    @Test
    public void testFlushAll() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k((int)0), (Object)TestingUtil.v((int)0));
        Assertions.assertThat((Long)redis.dbsize()).isGreaterThan(0L);
        redis.flushall(FlushMode.SYNC);
        Assertions.assertThat((Long)redis.dbsize()).isEqualTo(0L);
        redis.set((Object)TestingUtil.k((int)0), (Object)TestingUtil.v((int)0));
        Assertions.assertThat((Long)redis.dbsize()).isGreaterThan(0L);
        redis.flushall(FlushMode.ASYNC);
        RespSingleNodeTest.eventually(() -> redis.dbsize() == 0L);
    }

    @Test
    public void testScan() {
        RedisCommands redis = this.redisConnection.sync();
        redis.flushdb();
        HashSet<String> all = new HashSet<String>();
        for (int i = 0; i < 15; ++i) {
            String k = TestingUtil.k((int)i);
            redis.set((Object)k, (Object)TestingUtil.v((int)i));
            all.add(k);
        }
        HashSet keys = new HashSet();
        KeyScanCursor cursor = redis.scan();
        while (true) {
            keys.addAll(cursor.getKeys());
            if (cursor.isFinished()) break;
            cursor = redis.scan((ScanCursor)cursor);
        }
        Assertions.assertThat(keys).containsExactlyInAnyOrderElementsOf(all);
    }

    @Test
    public void testScanCount() {
        RedisCommands redis = this.redisConnection.sync();
        redis.flushdb();
        HashSet<String> all = new HashSet<String>();
        for (int i = 0; i < 15; ++i) {
            String k = TestingUtil.k((int)i);
            redis.set((Object)k, (Object)TestingUtil.v((int)i));
            all.add(k);
        }
        this.assertScanWithCount(all, 5);
        this.assertScanWithCount(all, 14);
        this.assertScanWithCount(all, 2147483547);
    }

    private void assertScanWithCount(Set<String> all, int count) {
        RedisCommands redis = this.redisConnection.sync();
        HashSet keys = new HashSet();
        ScanArgs args = ScanArgs.Builder.limit((long)count);
        KeyScanCursor cursor = redis.scan(args);
        while (true) {
            if (!cursor.isFinished()) {
                Assertions.assertThat((List)cursor.getKeys()).hasSize(count);
            }
            keys.addAll(cursor.getKeys());
            if (cursor.isFinished()) break;
            cursor = redis.scan((ScanCursor)cursor, args);
        }
        Assertions.assertThat(keys).hasSize(all.size());
        Assertions.assertThat(keys).containsExactlyInAnyOrderElementsOf(all);
    }

    @Test
    public void testScanMatch() {
        RedisCommands redis = this.redisConnection.sync();
        redis.flushdb();
        HashSet<String> all = new HashSet<String>();
        for (int i = 0; i < 15; ++i) {
            String k = TestingUtil.k((int)i);
            redis.set((Object)k, (Object)TestingUtil.v((int)i));
            all.add(k);
        }
        HashSet<String> keys = new HashSet<String>();
        ScanArgs args = ScanArgs.Builder.matches((String)"k1*");
        KeyScanCursor cursor = redis.scan(args);
        while (true) {
            for (String key : cursor.getKeys()) {
                Assertions.assertThat((String)key).startsWith((CharSequence)"k1");
                keys.add(key);
            }
            if (cursor.isFinished()) break;
            cursor = redis.scan((ScanCursor)cursor, args);
        }
    }

    @Test
    public void testLargeScanMatch() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.set((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", (Object)"value")).isEqualTo("OK");
        ScanArgs args = ScanArgs.Builder.matches((String)"a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*b");
        KeyScanCursor cursor = redis.scan(args);
        Assertions.assertThat((List)cursor.getKeys()).isEmpty();
        Assertions.assertThat((boolean)cursor.isFinished()).isTrue();
    }

    @Test
    public void testScanFilters() {
        String k;
        int i;
        RedisCommands redis = this.redisConnection.sync();
        HashSet<String> all = new HashSet<String>();
        for (i = 0; i < 15; ++i) {
            k = TestingUtil.k((int)i);
            redis.set((Object)k, (Object)TestingUtil.v((int)i));
            all.add(k);
        }
        for (i = 15; i < 30; ++i) {
            k = TestingUtil.k((int)i);
            if (i < 20) {
                redis.sadd((Object)k, (Object[])new String[]{TestingUtil.v((int)i)});
                continue;
            }
            if (i < 25) {
                redis.zadd((Object)k, 1.2, (Object)TestingUtil.v((int)i));
                continue;
            }
            redis.hset((Object)k, Map.of(k, TestingUtil.v((int)i)));
        }
        HashSet<String> keys = new HashSet<String>();
        KeyScanCursor cursor = redis.scan();
        while (true) {
            keys.addAll(cursor.getKeys());
            if (cursor.isFinished()) break;
            cursor = redis.scan((ScanCursor)cursor);
        }
        ((AbstractCollectionAssert)Assertions.assertThat(keys).hasSize(30)).containsAll(all);
        keys.clear();
        KeyScanArgs args = KeyScanArgs.Builder.type((String)RespTypes.string.name());
        KeyScanCursor cursor2 = redis.scan((ScanArgs)args);
        while (true) {
            keys.addAll(cursor2.getKeys());
            if (cursor2.isFinished()) break;
            cursor2 = redis.scan((ScanCursor)cursor2, (ScanArgs)args);
        }
        ((AbstractCollectionAssert)Assertions.assertThat(keys).hasSize(all.size())).containsExactlyInAnyOrderElementsOf(all);
        keys.clear();
        args = KeyScanArgs.Builder.type((String)RespTypes.string.name()).match("k1*");
        cursor2 = redis.scan((ScanArgs)args);
        while (true) {
            for (String key : cursor2.getKeys()) {
                Assertions.assertThat((String)key).startsWith((CharSequence)"k1");
                keys.add(key);
            }
            if (cursor2.isFinished()) break;
            cursor2 = redis.scan((ScanCursor)cursor2, (ScanArgs)args);
        }
        Assertions.assertThat(keys).hasSize(6);
    }

    @Test
    public void testClusterShardsSingleNode() {
        RedisCommands redis = this.redisConnection.sync();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).clusterShards()).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR This instance has cluster support disabled");
    }

    @Test(dataProvider="lcsCases")
    public void testLcs(String v1, String v2, String resp, int[][] idx) {
        String key1 = "lcs-base-1";
        String key2 = "lcs-base-2";
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)key1, (Object)v1);
        redis.set((Object)key2, (Object)v2);
        StrAlgoArgs args = StrAlgoArgs.Builder.keys((String[])new String[]{key1, key2});
        StringMatchResult res = redis.stralgoLcs(args);
        Assertions.assertThat((String)res.getMatchString()).isEqualTo(resp);
        Assertions.assertThat((long)res.getLen()).isZero();
    }

    @Test(dataProvider="lcsCases")
    public void testLcsLen(String v1, String v2, String resp, int[][] idx) {
        String key1 = "lcs-base-1";
        String key2 = "lcs-base-2";
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)key1, (Object)v1);
        redis.set((Object)key2, (Object)v2);
        StrAlgoArgs args = StrAlgoArgs.Builder.keys((String[])new String[]{key1, key2}).justLen();
        StringMatchResult res = redis.stralgoLcs(args);
        Assertions.assertThat((long)res.getLen()).isEqualTo((long)resp.length());
        Assertions.assertThat((String)res.getMatchString()).isNull();
    }

    @Test(dataProvider="lcsCases")
    public void testLcsIdx(String v1, String v2, String resp, int[][] idx) {
        String key1 = "lcs-base-1";
        String key2 = "lcs-base-2";
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)key1, (Object)v1);
        redis.set((Object)key2, (Object)v2);
        StrAlgoArgs args = StrAlgoArgs.Builder.keys((String[])new String[]{key1, key2}).withIdx();
        StringMatchResult res = redis.stralgoLcs(args);
        this.checkIdx(resp, idx, res, false);
    }

    @Test(dataProvider="lcsCases")
    public void testLcsIdxWithLen(String v1, String v2, String resp, int[][] idx) {
        String key1 = "lcs-base-1";
        String key2 = "lcs-base-2";
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)key1, (Object)v1);
        redis.set((Object)key2, (Object)v2);
        StrAlgoArgs args = StrAlgoArgs.Builder.keys((String[])new String[]{key1, key2}).withIdx().withMatchLen();
        StringMatchResult res = redis.stralgoLcs(args);
        this.checkIdx(resp, idx, res, true);
    }

    @Test(dataProvider="lcsCasesWithMinLen")
    public void testLcsIdxWithMinLen(String v1, String v2, String resp, int[][] idxs, int minLen) {
        String key1 = "lcs-base-1";
        String key2 = "lcs-base-2";
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)key1, (Object)v1);
        redis.set((Object)key2, (Object)v2);
        StrAlgoArgs args = StrAlgoArgs.Builder.keys((String[])new String[]{key1, key2}).withIdx().minMatchLen(minLen);
        int[][] idx = (int[][])Arrays.stream(idxs).filter(pos -> ((int[])pos).length == 1 || pos[1] - pos[0] >= minLen - 1).toArray(x$0 -> new int[x$0][]);
        StringMatchResult res = redis.stralgoLcs(args);
        this.checkIdx(resp, idx, res, false);
    }

    @DataProvider
    public Object[][] lcsCases() {
        return new Object[][]{{"GAC", "AGCAT", "AC", new int[][]{{2, 2, 2, 2}, {1, 1, 0, 0}, {2}}}, {"XMJYAUZ", "MZJAWXU", "MJAU", new int[][]{{5, 5, 6, 6}, {4, 4, 3, 3}, {2, 2, 2, 2}, {1, 1, 0, 0}, {4}}}, {"ohmytext", "mynewtext", "mytext", new int[][]{{4, 7, 5, 8}, {2, 3, 0, 1}, {6}}}, {"ABCBDAB", "BDCABA", "BDAB", new int[][]{{5, 6, 3, 4}, {3, 4, 0, 1}, {4}}}, {"ABCEZ12 21AAZ", "12ABZ 21AZAZ", "ABZ 21AAZ", new int[][]{{11, 12, 10, 11}, {7, 10, 5, 8}, {4, 4, 4, 4}, {0, 1, 2, 3}, {9}}}};
    }

    @DataProvider
    public Object[][] lcsCasesWithMinLen() {
        ArrayList<Object[]> testCases = new ArrayList<Object[]>();
        Object[][] minLengths = new Object[][]{{1}, {2}, {4}, {10}};
        Object[][] lcsCases = this.lcsCases();
        for (Object[] len : minLengths) {
            for (Object[] lcsCase : lcsCases) {
                testCases.add(Stream.concat(Arrays.stream(lcsCase), Arrays.stream(len)).toArray());
            }
        }
        return (Object[][])testCases.toArray((T[])new Object[0][]);
    }

    private void checkIdx(String resp, int[][] idx, StringMatchResult res, boolean withLen) {
        List matches = res.getMatches();
        Assertions.assertThat((int)matches.size()).isEqualTo(idx.length - 1);
        for (int i = 0; i < matches.size(); ++i) {
            Assertions.assertThat((long)((StringMatchResult.MatchedPosition)matches.get(i)).getA().getStart()).isEqualTo((long)idx[i][0]);
            Assertions.assertThat((long)((StringMatchResult.MatchedPosition)matches.get(i)).getA().getEnd()).isEqualTo((long)idx[i][1]);
            Assertions.assertThat((long)((StringMatchResult.MatchedPosition)matches.get(i)).getB().getStart()).isEqualTo((long)idx[i][2]);
            Assertions.assertThat((long)((StringMatchResult.MatchedPosition)matches.get(i)).getB().getEnd()).isEqualTo((long)idx[i][3]);
            if (!withLen) continue;
            Assertions.assertThat((long)((StringMatchResult.MatchedPosition)matches.get(i)).getMatchLen()).isEqualTo((long)(idx[i][1] - idx[i][0] + 1));
        }
        Assertions.assertThat((long)res.getLen()).isEqualTo((long)resp.length());
        Assertions.assertThat((String)res.getMatchString()).isNull();
    }

    @Test
    public void testTTL() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v());
        Assertions.assertThat((Long)redis.ttl((Object)TestingUtil.k())).isEqualTo(-1L);
        Assertions.assertThat((Long)redis.ttl((Object)TestingUtil.k((int)1))).isEqualTo(-2L);
        redis.set((Object)TestingUtil.k((int)2), (Object)TestingUtil.v((int)2), SetArgs.Builder.ex((long)10000L));
        Assertions.assertThat((Long)redis.ttl((Object)TestingUtil.k((int)2))).isEqualTo(10000L);
        this.timeService.advance(5000L, TimeUnit.SECONDS);
        Assertions.assertThat((Long)redis.ttl((Object)TestingUtil.k((int)2))).isEqualTo(5000L);
    }

    @Test
    public void testPTTL() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v());
        Assertions.assertThat((Long)redis.pttl((Object)TestingUtil.k())).isEqualTo(-1L);
        Assertions.assertThat((Long)redis.pttl((Object)TestingUtil.k((int)1))).isEqualTo(-2L);
        redis.set((Object)TestingUtil.k((int)2), (Object)TestingUtil.v((int)2), SetArgs.Builder.ex((long)10000L));
        Assertions.assertThat((Long)redis.pttl((Object)TestingUtil.k((int)2))).isEqualTo(10000000L);
    }

    @Test
    public void testPTTLTypes() {
        RedisCommands redis = this.redisConnection.sync();
        redis.hset((Object)TestingUtil.k(), (Object)TestingUtil.v(), (Object)TestingUtil.v());
        Assertions.assertThat((Long)redis.pttl((Object)TestingUtil.k())).isEqualTo(-1L);
        Assertions.assertThat((Long)redis.pttl((Object)TestingUtil.k((int)1))).isEqualTo(-2L);
        redis.hset((Object)TestingUtil.k((int)2), (Object)TestingUtil.v((int)2), (Object)TestingUtil.v((int)2));
        redis.expire((Object)TestingUtil.k((int)2), 10L);
        Assertions.assertThat((Long)redis.pttl((Object)TestingUtil.k((int)2))).isEqualTo(10000L);
        this.timeService.advance(5000L);
        Assertions.assertThat((Long)redis.pttl((Object)TestingUtil.k((int)2))).isEqualTo(5000L);
    }

    @Test
    public void testExpireTypes() {
        RedisCommands redis = this.redisConnection.sync();
        redis.hset((Object)TestingUtil.k((int)1), (Object)TestingUtil.v((int)1), (Object)TestingUtil.v((int)1));
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)1), 1L)).isTrue();
        redis.lpush((Object)TestingUtil.k((int)2), (Object[])new String[]{TestingUtil.v((int)2)});
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)2), 1L)).isTrue();
        redis.zadd((Object)TestingUtil.k((int)3), 10.0, (Object)TestingUtil.v((int)3));
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)3), 1L)).isTrue();
        redis.pfadd((Object)TestingUtil.k((int)4), (Object[])new String[]{TestingUtil.v((int)4)});
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)4), 1L)).isTrue();
        redis.sadd((Object)TestingUtil.k((int)5), (Object[])new String[]{TestingUtil.v((int)5)});
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)5), 1L)).isTrue();
        redis.set((Object)TestingUtil.k((int)6), (Object)TestingUtil.v((int)6));
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)6), 1L)).isTrue();
        for (int i = 1; i <= 6; ++i) {
            Assertions.assertThat((Long)redis.pttl((Object)TestingUtil.k((int)i))).isEqualTo(1000L);
        }
        this.timeService.advance(2000L);
        RespSingleNodeTest.eventually(() -> redis.dbsize() == 0L);
    }

    @Test
    public void testExpireTime() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v());
        Assertions.assertThat((Long)redis.expiretime((Object)TestingUtil.k())).isEqualTo(-1L);
        Assertions.assertThat((Long)redis.expiretime((Object)TestingUtil.k((int)1))).isEqualTo(-2L);
        redis.set((Object)TestingUtil.k((int)2), (Object)TestingUtil.v((int)2), SetArgs.Builder.exAt((long)(this.timeService.wallClockTime() + 10000L)));
        Assertions.assertThat((Long)redis.expiretime((Object)TestingUtil.k((int)2))).isEqualTo(this.timeService.wallClockTime() + 10000L);
    }

    @Test
    public void testPExpireTime() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v());
        Assertions.assertThat((Long)redis.pexpiretime((Object)TestingUtil.k())).isEqualTo(-1L);
        Assertions.assertThat((Long)redis.pexpiretime((Object)TestingUtil.k((int)1))).isEqualTo(-2L);
        redis.set((Object)TestingUtil.k((int)2), (Object)TestingUtil.v((int)2), SetArgs.Builder.exAt((long)(this.timeService.wallClockTime() + 10000L)));
        Assertions.assertThat((Long)redis.pexpiretime((Object)TestingUtil.k((int)2))).isEqualTo((this.timeService.wallClockTime() + 10000L) * 1000L);
    }

    @Test
    public void testPersist() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v(), SetArgs.Builder.ex((long)10000L));
        Assertions.assertThat((Boolean)redis.persist((Object)TestingUtil.k())).isTrue();
        redis.set((Object)TestingUtil.k((int)1), (Object)TestingUtil.v((int)1));
        Assertions.assertThat((Boolean)redis.persist((Object)TestingUtil.k((int)1))).isFalse();
        Assertions.assertThat((Boolean)redis.persist((Object)TestingUtil.k((int)2))).isFalse();
    }

    @Test
    public void testMemoryUsage() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)"1");
        Assertions.assertThat((Long)redis.memoryUsage((Object)TestingUtil.k())).isEqualTo(72L);
        redis.set((Object)TestingUtil.k((int)1), (Object)"a".repeat(1001));
        Assertions.assertThat((Long)redis.memoryUsage((Object)TestingUtil.k((int)1))).isEqualTo(1088L);
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        redis.hmset((Object)TestingUtil.k((int)2), map);
        Assertions.assertThat((Long)redis.memoryUsage((Object)TestingUtil.k((int)2))).isPositive();
        redis.pfadd((Object)TestingUtil.k((int)3), (Object[])new String[]{"el1", "el2", "el3"});
        Assertions.assertThat((Long)redis.memoryUsage((Object)TestingUtil.k((int)3))).isPositive();
        redis.rpush((Object)TestingUtil.k((int)4), (Object[])new String[]{"william", "jose", "pedro"});
        Assertions.assertThat((Long)redis.memoryUsage((Object)TestingUtil.k((int)4))).isPositive();
        redis.sadd((Object)TestingUtil.k((int)5), (Object[])new String[]{"1", "2", "3"});
        Assertions.assertThat((Long)redis.memoryUsage((Object)TestingUtil.k((int)5))).isPositive();
        redis.zadd((Object)TestingUtil.k((int)6), 10.4, (Object)"william");
        Assertions.assertThat((Long)redis.memoryUsage((Object)TestingUtil.k((int)6))).isPositive();
        JsonPath jp = new JsonPath("$");
        DefaultJsonParser defaultJsonParser = new DefaultJsonParser();
        JsonValue jv = defaultJsonParser.createJsonValue("{\"key\":\"value\"}");
        redis.jsonSet((Object)TestingUtil.k((int)7), jp, jv);
        Assertions.assertThat((Long)redis.memoryUsage((Object)TestingUtil.k((int)7))).isPositive();
    }

    @Test
    public void testClusterNodesSingleNode() {
        RedisCommands redis = this.redisConnection.sync();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).clusterNodes()).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR This instance has cluster support disabled");
    }

    @Test
    public void testType() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)"1");
        Assertions.assertThat((String)redis.type((Object)TestingUtil.k())).isEqualTo("string");
        redis.hset((Object)TestingUtil.k((int)1), (Object)"k", (Object)"v");
        Assertions.assertThat((String)redis.type((Object)TestingUtil.k((int)1))).isEqualTo("hash");
        redis.lpush((Object)TestingUtil.k((int)2), (Object[])new String[]{"a"});
        Assertions.assertThat((String)redis.type((Object)TestingUtil.k((int)2))).isEqualTo("list");
        redis.sadd((Object)TestingUtil.k((int)3), (Object[])new String[]{"a"});
        Assertions.assertThat((String)redis.type((Object)TestingUtil.k((int)3))).isEqualTo("set");
        redis.zadd((Object)TestingUtil.k((int)4), 1.0, (Object)"a");
        Assertions.assertThat((String)redis.type((Object)TestingUtil.k((int)4))).isEqualTo("zset");
        Assertions.assertThat((String)redis.type((Object)TestingUtil.k((int)100))).isEqualTo("none");
    }

    @Test
    public void testExpire() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v());
        Assertions.assertThat((Long)redis.ttl((Object)TestingUtil.k())).isEqualTo(-1L);
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k(), 1000L)).isTrue();
        Assertions.assertThat((Long)redis.ttl((Object)TestingUtil.k())).isEqualTo(1000L);
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k(), 500L, ExpireArgs.Builder.gt())).isFalse();
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k(), 1500L, ExpireArgs.Builder.gt())).isTrue();
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k(), 2000L, ExpireArgs.Builder.lt())).isFalse();
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k(), 1000L, ExpireArgs.Builder.lt())).isTrue();
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k(), 1250L, ExpireArgs.Builder.xx())).isTrue();
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k(), 1000L, ExpireArgs.Builder.nx())).isFalse();
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)1), 1000L)).isFalse();
        redis.set((Object)TestingUtil.k((int)1), (Object)TestingUtil.v((int)1));
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)1), 1000L, ExpireArgs.Builder.xx())).isFalse();
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)1), 1000L, ExpireArgs.Builder.nx())).isTrue();
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)1), -10L)).isTrue();
        Assertions.assertThat((String)((String)redis.get((Object)TestingUtil.k((int)1)))).isNull();
        redis.set((Object)TestingUtil.k((int)2), (Object)TestingUtil.v((int)2));
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)2), 1000L, ExpireArgs.Builder.gt())).isFalse();
        Assertions.assertThat((Boolean)redis.expire((Object)TestingUtil.k((int)2), 1000L, ExpireArgs.Builder.lt())).isTrue();
    }

    public void testPExpire() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v());
        Assertions.assertThat((Long)redis.ttl((Object)TestingUtil.k())).isEqualTo(-1L);
        Assertions.assertThat((Boolean)redis.pexpire((Object)TestingUtil.k(), 1000L)).isTrue();
        Assertions.assertThat((Long)redis.pttl((Object)TestingUtil.k())).isEqualTo(1000L);
        Assertions.assertThat((Boolean)redis.pexpire((Object)TestingUtil.k(), 500L, ExpireArgs.Builder.gt())).isFalse();
        Assertions.assertThat((Boolean)redis.pexpire((Object)TestingUtil.k(), 1500L, ExpireArgs.Builder.gt())).isTrue();
        Assertions.assertThat((Boolean)redis.pexpire((Object)TestingUtil.k(), 2000L, ExpireArgs.Builder.lt())).isFalse();
        Assertions.assertThat((Boolean)redis.pexpire((Object)TestingUtil.k(), 1000L, ExpireArgs.Builder.lt())).isTrue();
        Assertions.assertThat((Boolean)redis.pexpire((Object)TestingUtil.k(), 1250L, ExpireArgs.Builder.xx())).isTrue();
        Assertions.assertThat((Boolean)redis.pexpire((Object)TestingUtil.k(), 1000L, ExpireArgs.Builder.nx())).isFalse();
        Assertions.assertThat((Boolean)redis.pexpire((Object)TestingUtil.k((int)1), 1000L)).isFalse();
        redis.set((Object)TestingUtil.k((int)1), (Object)TestingUtil.v((int)1));
        Assertions.assertThat((Boolean)redis.pexpire((Object)TestingUtil.k((int)1), 1000L, ExpireArgs.Builder.xx())).isFalse();
        Assertions.assertThat((Boolean)redis.pexpire((Object)TestingUtil.k((int)1), 1000L, ExpireArgs.Builder.nx())).isTrue();
        Assertions.assertThat((Boolean)redis.pexpire((Object)TestingUtil.k((int)1), -10L)).isTrue();
        Assertions.assertThat((String)((String)redis.get((Object)TestingUtil.k((int)1)))).isNull();
    }

    @Test
    public void testExpireAt() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v());
        Assertions.assertThat((Long)redis.expiretime((Object)TestingUtil.k())).isEqualTo(-1L);
        Assertions.assertThat((Boolean)redis.expireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 1000L)).isTrue();
        Assertions.assertThat((Long)redis.expiretime((Object)TestingUtil.k())).isEqualTo(this.timeService.wallClockTime() + 1000L);
        Assertions.assertThat((Boolean)redis.expireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 500L, ExpireArgs.Builder.gt())).isFalse();
        Assertions.assertThat((Boolean)redis.expireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 1500L, ExpireArgs.Builder.gt())).isTrue();
        Assertions.assertThat((Boolean)redis.expireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 2000L, ExpireArgs.Builder.lt())).isFalse();
        Assertions.assertThat((Boolean)redis.expireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 1000L, ExpireArgs.Builder.lt())).isTrue();
        Assertions.assertThat((Boolean)redis.expireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 1250L, ExpireArgs.Builder.xx())).isTrue();
        Assertions.assertThat((Boolean)redis.expireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 1000L, ExpireArgs.Builder.nx())).isFalse();
        Assertions.assertThat((Boolean)redis.expireat((Object)TestingUtil.k((int)1), this.timeService.wallClockTime() + 1000L)).isFalse();
        redis.set((Object)TestingUtil.k((int)1), (Object)TestingUtil.v((int)1));
        Assertions.assertThat((Boolean)redis.expireat((Object)TestingUtil.k((int)1), this.timeService.wallClockTime() + 1000L, ExpireArgs.Builder.xx())).isFalse();
        Assertions.assertThat((Boolean)redis.expireat((Object)TestingUtil.k((int)1), this.timeService.wallClockTime() + 1000L, ExpireArgs.Builder.nx())).isTrue();
        Assertions.assertThat((Boolean)redis.expireat((Object)TestingUtil.k((int)1), TimeUnit.MILLISECONDS.toSeconds(this.timeService.wallClockTime() - 500L))).isTrue();
        Assertions.assertThat((String)((String)redis.get((Object)TestingUtil.k((int)1)))).isNull();
    }

    @Test
    public void testPExpireAt() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v());
        Assertions.assertThat((Long)redis.expiretime((Object)TestingUtil.k())).isEqualTo(-1L);
        Assertions.assertThat((Boolean)redis.pexpireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 1000L)).isTrue();
        Assertions.assertThat((Long)redis.expiretime((Object)TestingUtil.k())).isEqualTo((this.timeService.wallClockTime() + 1000L) / 1000L);
        Assertions.assertThat((Boolean)redis.pexpireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 500L, ExpireArgs.Builder.gt())).isFalse();
        Assertions.assertThat((Boolean)redis.pexpireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 1500L, ExpireArgs.Builder.gt())).isTrue();
        Assertions.assertThat((Boolean)redis.pexpireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 2000L, ExpireArgs.Builder.lt())).isFalse();
        Assertions.assertThat((Boolean)redis.pexpireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 1000L, ExpireArgs.Builder.lt())).isTrue();
        Assertions.assertThat((Boolean)redis.pexpireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 1250L, ExpireArgs.Builder.xx())).isTrue();
        Assertions.assertThat((Boolean)redis.pexpireat((Object)TestingUtil.k(), this.timeService.wallClockTime() + 1000L, ExpireArgs.Builder.nx())).isFalse();
        Assertions.assertThat((Boolean)redis.pexpireat((Object)TestingUtil.k((int)1), this.timeService.wallClockTime() + 1000L)).isFalse();
        redis.set((Object)TestingUtil.k((int)1), (Object)TestingUtil.v((int)1));
        Assertions.assertThat((Boolean)redis.pexpireat((Object)TestingUtil.k((int)1), this.timeService.wallClockTime() + 1000L, ExpireArgs.Builder.xx())).isFalse();
        Assertions.assertThat((Boolean)redis.pexpireat((Object)TestingUtil.k((int)1), this.timeService.wallClockTime() + 1000L, ExpireArgs.Builder.nx())).isTrue();
        Assertions.assertThat((Boolean)redis.pexpireat((Object)TestingUtil.k((int)1), this.timeService.wallClockTime() - 500L)).isTrue();
        Assertions.assertThat((String)((String)redis.get((Object)TestingUtil.k((int)1)))).isNull();
    }

    @Test
    public void testTouch() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((Long)redis.touch((Object[])new String[]{"unexisting"})).isZero();
        redis.set((Object)"hello", (Object)"world");
        redis.rpush((Object)"list", (Object[])new String[]{"one", "two", "three"});
        Assertions.assertThat((Long)redis.touch((Object[])new String[]{"hello", "list", "unexisting"})).isEqualTo(2L);
    }

    @Test
    public void testSort() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((List)redis.sort((Object)"not_existing")).isEmpty();
        Assertions.assertThat((List)redis.sortReadOnly((Object)"not_existing")).isEmpty();
        redis.rpush((Object)"numbers", (Object[])new String[]{"1", "3", "4", "8", "1", "0", "-1", "19", "-22", "3"});
        Assertions.assertThat((List)redis.lrange((Object)"numbers", 0L, -1L)).containsExactly((Object[])new String[]{"1", "3", "4", "8", "1", "0", "-1", "19", "-22", "3"});
        Assertions.assertThat((List)redis.sort((Object)"numbers")).containsExactly((Object[])new String[]{"-22", "-1", "0", "1", "1", "3", "3", "4", "8", "19"});
        Assertions.assertThat((List)redis.sort((Object)"numbers", SortArgs.Builder.alpha())).containsExactly((Object[])new String[]{"-1", "-22", "0", "1", "1", "19", "3", "3", "4", "8"});
        Assertions.assertThat((List)redis.sort((Object)"numbers", SortArgs.Builder.alpha().desc())).containsExactly((Object[])new String[]{"8", "4", "3", "3", "19", "1", "1", "0", "-22", "-1"});
        Assertions.assertThat((List)redis.sort((Object)"numbers", SortArgs.Builder.alpha().desc().limit(2L, 6L))).containsExactly((Object[])new String[]{"3", "3", "19", "1", "1", "0"});
        Assertions.assertThat((List)redis.sort((Object)"numbers", SortArgs.Builder.alpha().desc().limit(2L, 0L))).isEmpty();
        Assertions.assertThat((Long)redis.sortStore((Object)"numbers", SortArgs.Builder.alpha().desc(), (Object)"result_list")).isEqualTo(10L);
        Assertions.assertThat((List)redis.lrange((Object)"result_list", 0L, -1L)).containsExactly((Object[])new String[]{"8", "4", "3", "3", "19", "1", "1", "0", "-22", "-1"});
        Assertions.assertThat((List)redis.sort((Object)"numbers", SortArgs.Builder.by((String)"nosort"))).containsExactly((Object[])new String[]{"1", "3", "4", "8", "1", "0", "-1", "19", "-22", "3"});
        Assertions.assertThat((List)redis.sort((Object)"numbers", SortArgs.Builder.by((String)"nosort").limit(0L, 1L))).containsExactly((Object[])new String[]{"1"});
        Assertions.assertThat((List)redis.sort((Object)"numbers", SortArgs.Builder.by((String)"nosort").desc())).containsExactly((Object[])new String[]{"3", "-22", "19", "-1", "0", "1", "8", "4", "3", "1"});
        Assertions.assertThat((List)redis.sort((Object)"numbers", SortArgs.Builder.by((String)"nosort").limit(0L, 1L).desc())).containsExactly((Object[])new String[]{"3"});
        Assertions.assertThat((List)redis.sort((Object)"numbers", SortArgs.Builder.by((String)"something"))).containsExactly((Object[])new String[]{"1", "3", "4", "8", "1", "0", "-1", "19", "-22", "3"});
        Assertions.assertThat((List)redis.sort((Object)"numbers", SortArgs.Builder.by((String)"w_*"))).containsExactly((Object[])new String[]{"-1", "-22", "0", "1", "1", "19", "3", "3", "4", "8"});
        redis.rpush((Object)"people", (Object[])new String[]{"ryan", "tristan", "pedro", "michael"});
        Assertions.assertThat((List)redis.sort((Object)"people", SortArgs.Builder.by((String)"w_*"))).containsExactly((Object[])new String[]{"michael", "pedro", "ryan", "tristan"});
        redis.hset((Object)"h_ryan", Map.of("component", "persistence", "weight", "1"));
        redis.hset((Object)"h_pedro", Map.of("component", "cross-site", "weight", "2"));
        redis.hset((Object)"h_tristan", Map.of("component", "security", "weight", "3"));
        redis.hset((Object)"h_michael", Map.of("weight", "4"));
        redis.set((Object)"w_ryan", (Object)"1");
        redis.set((Object)"w_pedro", (Object)"2");
        redis.set((Object)"w_tristan", (Object)"3");
        redis.set((Object)"w_michael", (Object)"4");
        Assertions.assertThat((List)redis.sort((Object)"people", SortArgs.Builder.by((String)"w_*"))).containsExactly((Object[])new String[]{"ryan", "pedro", "tristan", "michael"});
        Assertions.assertThat((List)redis.sort((Object)"people", SortArgs.Builder.by((String)"h_*->weight"))).containsExactly((Object[])new String[]{"ryan", "pedro", "tristan", "michael"});
        redis.set((Object)"o_ryan", (Object)"persistence");
        redis.set((Object)"o_pedro", (Object)"cross-site");
        redis.set((Object)"o_tristan", (Object)"security");
        Assertions.assertThat((List)redis.sort((Object)"people", SortArgs.Builder.by((String)"w_*").get("o_*"))).containsExactly((Object[])new String[]{"persistence", "cross-site", "security", null});
        Assertions.assertThat((List)redis.sort((Object)"people", SortArgs.Builder.by((String)"w_*").get("h_*->component"))).containsExactly((Object[])new String[]{"persistence", "cross-site", "security", null});
        Assertions.assertThat((List)redis.sort((Object)"people", SortArgs.Builder.by((String)"w_*").get("o_*").get("#"))).containsExactly((Object[])new String[]{"persistence", "ryan", "cross-site", "pedro", "security", "tristan", null, "michael"});
        Assertions.assertThat((List)redis.sort((Object)"people", SortArgs.Builder.by((String)"w_*").get("h_*->component").get("#"))).containsExactly((Object[])new String[]{"persistence", "ryan", "cross-site", "pedro", "security", "tristan", null, "michael"});
        Assertions.assertThat((List)redis.sort((Object)"people", SortArgs.Builder.by((String)"w_*").get("o").get("#"))).containsExactly((Object[])new String[]{null, "ryan", null, "pedro", null, "tristan", null, "michael"});
        redis.sadd((Object)"set_numbers", (Object[])new String[]{"1", "3", "4", "8", "1", "0", "-1", "19", "-22", "3"});
        Assertions.assertThat((List)redis.sort((Object)"set_numbers")).containsExactly((Object[])new String[]{"-22", "-1", "0", "1", "3", "4", "8", "19"});
        Assertions.assertThat((List)redis.sort((Object)"set_numbers", SortArgs.Builder.alpha())).containsExactly((Object[])new String[]{"-1", "-22", "0", "1", "19", "3", "4", "8"});
        Assertions.assertThat((List)redis.sort((Object)"set_numbers", SortArgs.Builder.alpha().desc())).containsExactly((Object[])new String[]{"8", "4", "3", "19", "1", "0", "-22", "-1"});
        Assertions.assertThat((Long)redis.sortStore((Object)"set_numbers", SortArgs.Builder.alpha().desc(), (Object)"result_sset")).isEqualTo(8L);
        Assertions.assertThat((List)redis.lrange((Object)"result_sset", 0L, -1L)).containsExactly((Object[])new String[]{"8", "4", "3", "19", "1", "0", "-22", "-1"});
        redis.zadd((Object)"zset_numbers", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"9"), ScoredValue.just((double)2.0, (Object)"8"), ScoredValue.just((double)3.0, (Object)"15"), ScoredValue.just((double)4.0, (Object)"-4"), ScoredValue.just((double)5.0, (Object)"2"), ScoredValue.just((double)5.0, (Object)"6"), ScoredValue.just((double)6.0, (Object)"7"), ScoredValue.just((double)6.0, (Object)"-3"), ScoredValue.just((double)6.0, (Object)"1")});
        Assertions.assertThat((List)redis.sort((Object)"zset_numbers")).containsExactly((Object[])new String[]{"-4", "-3", "1", "2", "6", "7", "8", "9", "15"});
        Assertions.assertThat((List)redis.sort((Object)"zset_numbers", SortArgs.Builder.alpha())).containsExactly((Object[])new String[]{"-3", "-4", "1", "15", "2", "6", "7", "8", "9"});
        Assertions.assertThat((List)redis.sort((Object)"zset_numbers", SortArgs.Builder.alpha().desc())).containsExactly((Object[])new String[]{"9", "8", "7", "6", "2", "15", "1", "-4", "-3"});
        Assertions.assertThat((List)redis.sort((Object)"zset_numbers", SortArgs.Builder.by((String)"no-sort"))).containsExactly((Object[])new String[]{"9", "8", "15", "-4", "2", "6", "-3", "1", "7"});
        Assertions.assertThat((Long)redis.sortStore((Object)"zset_numbers", SortArgs.Builder.alpha().desc(), (Object)"result_zset")).isEqualTo(9L);
        Assertions.assertThat((List)redis.lrange((Object)"result_zset", 0L, -1L)).containsExactly((Object[])new String[]{"9", "8", "7", "6", "2", "15", "1", "-4", "-3"});
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"another", (Object)"tristan"), () -> redis.sort((Object)"another"));
    }

    @Test
    public void testRename() {
        RedisCommands redis = this.redisConnection.sync();
        String srcKey = TestingUtil.k((int)0);
        String dstKey = TestingUtil.k((int)1);
        String val = TestingUtil.v();
        redis.set((Object)srcKey, (Object)val);
        redis.rename((Object)srcKey, (Object)dstKey);
        Assertions.assertThat((String)((String)redis.get((Object)dstKey))).isEqualTo(val);
        Exceptions.expectException(RedisCommandExecutionException.class, (String)"ERR no such key", () -> redis.rename((Object)"not-existent", (Object)dstKey));
    }

    @Test
    public void testRenameList() {
        RedisCommands redis = this.redisConnection.sync();
        String srcKey = TestingUtil.k((int)0);
        String dstKey = TestingUtil.k((int)1);
        String val = TestingUtil.v();
        redis.rpush((Object)srcKey, (Object[])new String[]{val});
        redis.rename((Object)srcKey, (Object)dstKey);
        Assertions.assertThat((List)redis.lrange((Object)dstKey, 0L, -1L)).containsExactly((Object[])new String[]{val});
    }

    @Test
    public void testRenameWithEx() {
        RedisCommands redis = this.redisConnection.sync();
        String srcKey = TestingUtil.k((int)0);
        String dstKey = TestingUtil.k((int)1);
        String val = TestingUtil.v();
        SetArgs setArg = new SetArgs();
        setArg.ex(60L);
        redis.set((Object)srcKey, (Object)val, setArg);
        this.timeService.advance(30L, TimeUnit.SECONDS);
        redis.rename((Object)srcKey, (Object)dstKey);
        Assertions.assertThat((String)((String)redis.get((Object)dstKey))).isEqualTo(val);
        long nowTs = this.timeService.wallClockTime();
        Assertions.assertThat((long)(redis.expiretime((Object)dstKey) - nowTs / 1000L)).isLessThanOrEqualTo(30L);
        this.timeService.advance(35L, TimeUnit.SECONDS);
        Assertions.assertThat((String)((String)redis.get((Object)dstKey))).isNull();
    }

    @Test
    public void testRenamenx() {
        RedisCommands redis = this.redisConnection.sync();
        String srcKey = TestingUtil.k((int)0);
        String dstKey = TestingUtil.k((int)1);
        String val = TestingUtil.v();
        String val1 = TestingUtil.v((int)1);
        redis.set((Object)srcKey, (Object)val);
        Assertions.assertThat((Boolean)redis.renamenx((Object)srcKey, (Object)dstKey)).isEqualTo(true);
        Assertions.assertThat((String)((String)redis.get((Object)dstKey))).isEqualTo(val);
        redis.set((Object)srcKey, (Object)val1);
        Assertions.assertThat((Boolean)redis.renamenx((Object)srcKey, (Object)dstKey)).isEqualTo(false);
        Assertions.assertThat((String)((String)redis.get((Object)dstKey))).isEqualTo(val);
        Exceptions.expectException(RedisCommandExecutionException.class, (String)"ERR no such key", () -> redis.renamenx((Object)"not-existent", (Object)"not-existent-1"));
    }

    @Test
    public void testRenameTypes() {
        RedisCommands redis = this.redisConnection.sync();
        String srcKey = TestingUtil.k((int)0);
        String dstKey = TestingUtil.k((int)1);
        String val = TestingUtil.v();
        redis.rpush((Object)srcKey, (Object[])new String[]{val});
        redis.rename((Object)srcKey, (Object)dstKey);
        Assertions.assertThat((List)redis.lrange((Object)dstKey, 0L, -1L)).containsExactly((Object[])new String[]{val});
    }

    @Test
    public void testTime() {
        RedisCommands redis = this.redisConnection.sync();
        List redisNow = redis.time();
        Instant now = this.timeService.instant();
        Assertions.assertThat((int)Integer.parseInt((String)redisNow.get(0))).isEqualTo(now.getEpochSecond());
        Assertions.assertThat((int)Integer.parseInt((String)redisNow.get(1))).isEqualTo(TimeUnit.NANOSECONDS.toMicros(now.getNano()));
    }

    @Test
    public void testPFADD() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((Long)redis.pfadd((Object)"my-hll", (Object[])new String[]{"el1", "el2", "el3"})).isEqualTo(1L);
        Assertions.assertThat((Long)redis.pfadd((Object)"my-hll", (Object[])new String[]{"el1", "el2", "el3"})).isEqualTo(0L);
        for (int i = 4; i < 193; ++i) {
            Assertions.assertThat((Long)redis.pfadd((Object)"my-hll", (Object[])new String[]{"el" + i})).isEqualTo(1L);
        }
        SoftAssertions sa = new SoftAssertions();
        for (int i = 0; i < 831; ++i) {
            sa.assertThat(redis.pfadd((Object)"my-hll", (Object[])new String[]{"hello-" + i})).isEqualTo(1L);
        }
        Assertions.assertThat((Long)redis.pfadd((Object)"my-hll", (Object[])new String[]{"hello-0", "hello-1", "hello-2"})).isEqualTo(0L);
        Assertions.assertThat((List)sa.errorsCollected()).hasSize(16);
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.pfadd((Object)"plain", (Object[])new String[]{"el1"}));
    }

    @Test
    public void testKeys() {
        RedisCommands redis = this.redisConnection.sync();
        redis.flushdb();
        Assertions.assertThat((List)redis.keys((Object)"*")).isEmpty();
        HashSet<CallSite> all = new HashSet<CallSite>();
        for (int i = 0; i < 15; ++i) {
            String k = "hello_" + i;
            redis.set((Object)k, (Object)("world_" + i));
            all.add((CallSite)((Object)k));
        }
        List allKeysPatternResult = redis.keys((Object)"*");
        Assertions.assertThat((List)allKeysPatternResult).hasSize(all.size());
        Assertions.assertThat((List)allKeysPatternResult).containsExactlyInAnyOrderElementsOf(all);
        Assertions.assertThat((List)redis.keys((Object)"*1")).containsExactlyInAnyOrder((Object[])new String[]{"hello_1", "hello_11"});
        Assertions.assertThat((List)redis.keys((Object)"hello_[2-4]")).containsExactlyInAnyOrder((Object[])new String[]{"hello_2", "hello_3", "hello_4"});
        Assertions.assertThat((List)redis.keys((Object)"hello_[24]")).containsExactlyInAnyOrder((Object[])new String[]{"hello_2", "hello_4"});
        Assertions.assertThat((List)redis.keys((Object)"hello_[^1]")).containsExactlyInAnyOrder((Object[])new String[]{"hello_0", "hello_2", "hello_3", "hello_4", "hello_5", "hello_6", "hello_7", "hello_8", "hello_9"});
    }

    public void testRandomKey() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)((String)redis.randomkey())).isNull();
        Assertions.assertThat((String)redis.set((Object)"k1", (Object)"v1")).isEqualTo("OK");
        Assertions.assertThat((String)((String)redis.randomkey())).isEqualTo("k1");
        Assertions.assertThat((String)redis.set((Object)"k2", (Object)"v2")).isEqualTo("OK");
        boolean c = false;
        for (int i = 0; i < 20; ++i) {
            String k = (String)redis.randomkey();
            if (!k.equals("k2")) continue;
            c = true;
            break;
        }
        Assertions.assertThat((boolean)c).isTrue();
    }

    @Test
    public void testDB() {
        ConfigurationBuilder builder = this.defaultRespConfiguration();
        this.amendConfiguration(builder);
        if (this.isAuthorizationEnabled()) {
            Security.doAs((Subject)RespTestingUtil.ADMIN, () -> {
                this.manager(0).createCache("1", builder.build());
                this.manager(0).createCache("2", builder.build());
            });
        } else {
            this.manager(0).createCache("1", builder.build());
            this.manager(0).createCache("2", builder.build());
        }
        this.testDBInternal();
    }

    private void testDBInternal() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.select(1)).isEqualTo("OK");
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v());
        Assertions.assertThat((String)((String)redis.get((Object)TestingUtil.k()))).isEqualTo(TestingUtil.v());
        Assertions.assertThat((String)redis.select(2)).isEqualTo("OK");
        Assertions.assertThat((String)((String)redis.get((Object)TestingUtil.k()))).isNull();
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v((int)1));
        Assertions.assertThat((String)((String)redis.get((Object)TestingUtil.k()))).isEqualTo(TestingUtil.v((int)1));
        Assertions.assertThat((String)redis.select(1)).isEqualTo("OK");
        Assertions.assertThat((String)((String)redis.get((Object)TestingUtil.k()))).isEqualTo(TestingUtil.v());
        redis.select(0);
    }

    public void testNoAuthHello() {
        SkipTestNG.skipIf((!this.isAuthorizationEnabled() ? 1 : 0) != 0, (String)"Run only with authz enabled");
        RedisURI uri = RedisURI.Builder.redis((String)"127.0.0.1", (int)this.server.getPort()).build();
        try (RedisClient noAuthClient = RedisClient.create((RedisURI)uri);){
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisClient)noAuthClient).connect()).isInstanceOf(RedisConnectionException.class)).cause().isInstanceOf(RedisCommandExecutionException.class)).hasMessage("NOAUTH HELLO must be called with the client already authenticated, otherwise the HELLO <proto> AUTH <user> <pass> option can be used to authenticate the client and select the RESP protocol version at the same time");
        }
    }

    public static class SimpleCommand
    implements ProtocolKeyword {
        private final String name;

        public SimpleCommand(String name) {
            this.name = name;
        }

        public byte[] getBytes() {
            return this.name.getBytes(StandardCharsets.UTF_8);
        }

        public String toString() {
            return this.name;
        }
    }
}

