/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.dist;

import io.lettuce.core.TransactionResult;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.resp.TransactionOperationsTest;
import org.infinispan.server.resp.test.TestSetup;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="dist.server.resp.TransactionClusteredTest")
public class TransactionClusteredTest
extends TransactionOperationsTest {
    private CacheMode mode;
    private boolean fromOwner;

    private TransactionClusteredTest withCacheMode(CacheMode mode) {
        this.mode = mode;
        return this;
    }

    private TransactionClusteredTest fromOwner(boolean value) {
        this.fromOwner = value;
        return this;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new TransactionClusteredTest().withCacheMode(CacheMode.DIST_SYNC).fromOwner(false), new TransactionClusteredTest().withCacheMode(CacheMode.DIST_SYNC).fromOwner(true), new TransactionClusteredTest().withCacheMode(CacheMode.REPL_SYNC)};
    }

    @Override
    protected String getOperationKey(int i) {
        return this.fromOwner ? this.getStringKeyForCache("key-" + i, this.cache(0)) : this.getStringKeyForCache("key-" + i, this.cache(1));
    }

    public void testFunctionalTxWithRemote() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        String k1 = this.getOperationKey(0);
        redis.lpush((Object)k1, (Object[])new String[]{"v1", "v2", "v3"});
        String k2 = this.getOperationKey(1);
        redis.hset((Object)k2, Map.of("f1", "v1", "f2", "v2"));
        String k3 = this.getOperationKey(2);
        redis.set((Object)k3, (Object)"value");
        TransactionResult result = redis.exec();
        Assertions.assertThat((boolean)result.wasDiscarded()).isFalse();
        Assertions.assertThat((Object)result.get(0)).isInstanceOfSatisfying(Long.class, v -> Assertions.assertThat((Long)v).isEqualTo(3L));
        Assertions.assertThat((Object)result.get(1)).isInstanceOfSatisfying(Long.class, v -> Assertions.assertThat((Long)v).isEqualTo(2L));
        Assertions.assertThat((Object)result.get(2)).isEqualTo((Object)"OK");
    }

    @Override
    protected String parameters() {
        return "[mode=" + String.valueOf(this.mode) + ", fromOwner=" + this.fromOwner + "]";
    }

    @Override
    protected void amendConfiguration(ConfigurationBuilder configurationBuilder) {
        super.amendConfiguration(configurationBuilder);
        configurationBuilder.clustering().hash().numOwners(1);
        configurationBuilder.clustering().cacheMode(this.mode);
    }

    @Override
    protected TestSetup setup() {
        return TestSetup.clusteredTestSetup(3);
    }
}

