/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.LMPopArgs;
import io.lettuce.core.LMoveArgs;
import io.lettuce.core.Range;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.SortArgs;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.json.DefaultJsonParser;
import io.lettuce.core.json.JsonPath;
import io.lettuce.core.json.JsonValue;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.ThrowingConsumer;
import org.infinispan.Cache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.server.resp.BaseMultipleRespTest;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.test.CommonRespTests;
import org.infinispan.test.Mocks;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.mockito.ArgumentMatchers;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespTwoNodeTest")
public class RespTwoNodeTest
extends BaseMultipleRespTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentOperations() throws ExecutionException, InterruptedException, TimeoutException {
        CheckPoint checkPoint = new CheckPoint();
        checkPoint.triggerForever("after_release");
        String blockedKey = "foo";
        Cache nonOwner = DistributionTestHelper.getFirstBackupOwner((Object)blockedKey, (List)this.caches(((RespServerConfiguration)this.server1.getConfiguration()).defaultCacheName()));
        ClusteringDependentLogic original = (ClusteringDependentLogic)Mocks.blockingMock((CheckPoint)checkPoint, ClusteringDependentLogic.class, (Cache)nonOwner, (stubber, clusteringDependentLogic) -> ((ClusteringDependentLogic)stubber.when(clusteringDependentLogic)).commitEntry((CacheEntry)ArgumentMatchers.any(), (FlagAffectedCommand)ArgumentMatchers.any(), (InvocationContext)ArgumentMatchers.any(), (Flag)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean()), (Class[])new Class[0]);
        RedisAsyncCommands redis = this.redisConnection1.async();
        try {
            RedisFuture futureSet = redis.set((Object)blockedKey, (Object)"bar");
            checkPoint.awaitStrict("before_invocation", 10L, TimeUnit.SECONDS);
            RedisFuture futurePing = redis.ping();
            RedisFuture futureCommand = redis.command();
            checkPoint.triggerForever("before_release");
            String getResponse = (String)futurePing.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)futureSet.get(10L, TimeUnit.SECONDS))).isEqualTo("OK");
            Assertions.assertThat((String)getResponse).isEqualTo("PONG");
            List results = (List)futureCommand.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((List)results).hasSizeGreaterThan(10);
        }
        finally {
            TestingUtil.replaceComponent((Cache)nonOwner, ClusteringDependentLogic.class, (Object)original, (boolean)true);
        }
        RedisFuture getFuture = redis.get((Object)blockedKey);
        Assertions.assertThat((String)((String)getFuture.get(10L, TimeUnit.SECONDS))).isEqualTo("bar");
    }

    public void testPipeline() throws ExecutionException, InterruptedException, TimeoutException {
        CommonRespTests.testPipeline((StatefulRedisConnection<String, String>)this.redisConnection1);
    }

    public void testRename() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        String srcKey = this.getStringKeyForCache(this.respCache(0));
        String dstKey = this.getStringKeyForCache(this.respCache(1));
        String val = TestingUtil.v();
        r0.set((Object)srcKey, (Object)val);
        r0.rename((Object)srcKey, (Object)dstKey);
        Assertions.assertThat((String)((String)r0.get((Object)dstKey))).isEqualTo(val);
        Assertions.assertThat((String)((String)r1.get((Object)dstKey))).isEqualTo(val);
        r1.rename((Object)dstKey, (Object)srcKey);
        Assertions.assertThat((String)((String)r0.get((Object)srcKey))).isEqualTo(val);
        Assertions.assertThat((String)((String)r1.get((Object)srcKey))).isEqualTo(val);
        Exceptions.expectException(RedisCommandExecutionException.class, (String)"ERR no such key", () -> r0.rename((Object)this.getStringKeyForCache(this.respCache(1)), (Object)dstKey));
    }

    public void testSimpleScan() {
        int size = 15;
        RedisCommands r1 = this.redisConnection1.sync();
        RedisCommands r2 = this.redisConnection2.sync();
        HashSet<String> all = new HashSet<String>();
        while (all.size() < size) {
            String k = this.getStringKeyForCache(this.respCache(0));
            r1.set((Object)k, (Object)TestingUtil.v());
            all.add(k);
        }
        HashSet keys = new HashSet();
        KeyScanCursor cursor = r2.scan();
        while (true) {
            keys.addAll(cursor.getKeys());
            if (cursor.isFinished()) break;
            cursor = r2.scan((ScanCursor)cursor);
        }
        AssertJUnit.assertTrue((boolean)keys.containsAll(all));
    }

    public void testSort() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        Assertions.assertThat((List)r0.sort((Object)"not_existing")).isEmpty();
        Assertions.assertThat((List)r1.sortReadOnly((Object)"not_existing")).isEmpty();
        String numbers = this.getStringKeyForCache(this.respCache(0));
        r0.rpush((Object)numbers, (Object[])new String[]{"1", "3", "4", "8", "1", "0", "-1", "19", "-22", "3"});
        Assertions.assertThat((List)r0.sort((Object)numbers)).containsExactly((Object[])new String[]{"-22", "-1", "0", "1", "1", "3", "3", "4", "8", "19"});
        Assertions.assertThat((List)r1.sort((Object)numbers)).containsExactly((Object[])new String[]{"-22", "-1", "0", "1", "1", "3", "3", "4", "8", "19"});
        String people = this.getStringKeyForCache(this.respCache(0));
        String w1 = this.getStringKeyForCache("w_", this.respCache(1));
        String w2 = this.getStringKeyForCache("w_", this.respCache(1));
        String v1 = w1.replace("w_", "");
        String v2 = w2.replace("w_", "");
        r0.rpush((Object)people, (Object[])new String[]{v1, v2});
        r1.set((Object)w1, (Object)"1");
        r1.set((Object)w2, (Object)"2");
        Assertions.assertThat((List)r0.sort((Object)people, SortArgs.Builder.by((String)"w_*"))).containsExactly((Object[])new String[]{v1, v2});
        Assertions.assertThat((List)r1.sort((Object)people, SortArgs.Builder.by((String)"w_*"))).containsExactly((Object[])new String[]{v1, v2});
        String target = this.getStringKeyForCache(this.respCache(1));
        Assertions.assertThat((Long)r0.sortStore((Object)people, SortArgs.Builder.by((String)"w_*"), (Object)target)).isEqualTo(2L);
    }

    public void testPop() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        String k = this.getStringKeyForCache(this.respCache(0));
        r0.rpush((Object)k, (Object[])new String[]{"v1", "v2", "v3", "v4"});
        Assertions.assertThat((String)((String)r1.lpop((Object)k))).isEqualTo("v1");
        Assertions.assertThat((String)((String)r1.rpop((Object)k))).isEqualTo("v4");
        Assertions.assertThat((String)((String)r0.lpop((Object)k))).isEqualTo("v2");
        Assertions.assertThat((String)((String)r0.rpop((Object)k))).isEqualTo("v3");
        Assertions.assertThat((String)((String)r0.rpop((Object)k))).isNull();
        Assertions.assertThat((String)((String)r1.rpop((Object)k))).isNull();
    }

    public void testPushX() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        String k = this.getStringKeyForCache(this.respCache(0));
        Assertions.assertThat((Long)r1.rpushx((Object)k, (Object[])new String[]{"v0"})).isEqualTo(0L);
        r0.rpush((Object)k, (Object[])new String[]{"v2"});
        Assertions.assertThat((Long)r1.rpushx((Object)k, (Object[])new String[]{"v1"})).isEqualTo(2L);
        Assertions.assertThat((Long)r1.lpushx((Object)k, (Object[])new String[]{"v3"})).isEqualTo(3L);
        Assertions.assertThat((List)r0.lrange((Object)k, 0L, -1L)).containsExactly((Object[])new String[]{"v3", "v2", "v1"});
    }

    public void testLMove() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        String srcKey0 = this.getStringKeyForCache(this.respCache(0));
        String srcKey1 = this.getStringKeyForCache(this.respCache(1));
        String dstKey0 = this.getStringKeyForCache(this.respCache(0));
        String dstKey1 = this.getStringKeyForCache(this.respCache(1));
        String v = TestingUtil.v();
        r0.rpush((Object)srcKey0, (Object[])new String[]{v});
        Assertions.assertThat((String)((String)r1.lmove((Object)srcKey0, (Object)dstKey1, LMoveArgs.Builder.rightRight()))).isEqualTo(v);
        Assertions.assertThat((String)((String)r1.lmove((Object)dstKey1, (Object)srcKey1, LMoveArgs.Builder.rightRight()))).isEqualTo(v);
        Assertions.assertThat((String)((String)r0.lmove((Object)srcKey1, (Object)dstKey0, LMoveArgs.Builder.rightRight()))).isEqualTo(v);
        Assertions.assertThat((String)((String)r1.lmove((Object)dstKey0, (Object)srcKey0, LMoveArgs.Builder.rightRight()))).isEqualTo(v);
    }

    public void testLMPop() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        String k0 = this.getStringKeyForCache(this.respCache(0));
        String k1 = this.getStringKeyForCache(this.respCache(1));
        r0.rpush((Object)k0, (Object[])new String[]{"v1", "v2"});
        r1.rpush((Object)k1, (Object[])new String[]{"v1", "v2"});
        ((ObjectAssert)Assertions.assertThat((Object)r0.lmpop(LMPopArgs.Builder.left(), (Object[])new String[]{k0})).satisfies(new ThrowingConsumer[]{kv -> Assertions.assertThat((String)((String)kv.getKey())).isEqualTo(k0)})).satisfies(new ThrowingConsumer[]{kv -> Assertions.assertThat((List)((List)kv.getValue())).containsExactly((Object[])new String[]{"v1"})});
        ((ObjectAssert)Assertions.assertThat((Object)r0.lmpop(LMPopArgs.Builder.left(), (Object[])new String[]{k1})).satisfies(new ThrowingConsumer[]{kv -> Assertions.assertThat((String)((String)kv.getKey())).isEqualTo(k1)})).satisfies(new ThrowingConsumer[]{kv -> Assertions.assertThat((List)((List)kv.getValue())).containsExactly((Object[])new String[]{"v1"})});
    }

    public void testLPos() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        String k0 = this.getStringKeyForCache(this.respCache(0));
        String k1 = this.getStringKeyForCache(this.respCache(1));
        String nonExistent = this.getStringKeyForCache(this.respCache(1));
        r0.rpush((Object)k0, (Object[])new String[]{"v1", "v2"});
        r1.rpush((Object)k1, (Object[])new String[]{"v1", "v2"});
        Assertions.assertThat((Long)r0.lpos((Object)k0, (Object)"v1")).isEqualTo(0L);
        Assertions.assertThat((Long)r0.lpos((Object)k1, (Object)"v2")).isEqualTo(1L);
        Assertions.assertThat((Long)r0.lpos((Object)k1, (Object)"something")).isNull();
        Assertions.assertThat((Long)r0.lpos((Object)nonExistent, (Object)"v1")).isNull();
    }

    public void testLSet() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        String k0 = this.getStringKeyForCache(this.respCache(0));
        String k1 = this.getStringKeyForCache(this.respCache(1));
        r0.rpush((Object)k0, (Object[])new String[]{"v1", "v2"});
        r1.rpush((Object)k1, (Object[])new String[]{"v1", "v2"});
        Assertions.assertThat((String)r0.lset((Object)k0, 0L, (Object)"v3")).isEqualTo("OK");
        Assertions.assertThat((String)r0.lset((Object)k1, 0L, (Object)"v3")).isEqualTo("OK");
    }

    public void testSortedSetUnion() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        Assertions.assertThat((List)r0.zunion((Object[])new String[]{"not_existing"})).isEmpty();
        String src0 = this.getStringKeyForCache(this.respCache(0));
        String dest0 = this.getStringKeyForCache(this.respCache(0));
        String src1 = this.getStringKeyForCache(this.respCache(1));
        r0.zadd((Object)src1, new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b")});
        r1.zadd((Object)src0, new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b")});
        Assertions.assertThat((List)r0.zunion((Object[])new String[]{src1})).contains((Object[])new String[]{"a", "b"});
        Assertions.assertThat((Long)r1.zunionstore((Object)dest0, (Object[])new String[]{src1, src0})).isEqualTo(2L);
    }

    public void testSortedSetDiff() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        String src0 = this.getStringKeyForCache(this.respCache(0));
        String dest0 = this.getStringKeyForCache(this.respCache(0));
        String src1 = this.getStringKeyForCache(this.respCache(1));
        String anotherSrc1 = this.getStringKeyForCache(this.respCache(1));
        Assertions.assertThat((List)r0.zdiff((Object[])new String[]{src0, src1})).isEmpty();
        r0.zadd((Object)src1, new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a")});
        r1.zadd((Object)src0, new ScoredValue[]{ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        r1.zadd((Object)anotherSrc1, new ScoredValue[]{ScoredValue.just((double)4.0, (Object)"d"), ScoredValue.just((double)5.0, (Object)"e")});
        Assertions.assertThat((List)r0.zdiff((Object[])new String[]{src0, src1, anotherSrc1})).contains((Object[])new String[]{"b", "c"});
        System.out.println("OK");
        Assertions.assertThat((Long)r1.zdiffstore((Object)dest0, (Object[])new String[]{src0, src1})).isEqualTo(2L);
    }

    public void testSortedSetIntersections() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        String src0 = this.getStringKeyForCache(this.respCache(0));
        String src1 = this.getStringKeyForCache(this.respCache(1));
        r0.zadd((Object)src1, new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b")});
        r1.zadd((Object)src0, new ScoredValue[]{ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((List)r1.zinter((Object[])new String[]{src0, src1})).containsOnly((Object[])new String[]{"b"});
        Assertions.assertThat((Long)r0.zintercard((Object[])new String[]{src0, src1})).isEqualTo(1L);
    }

    public void testSortedSetRanges() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        String src0 = this.getStringKeyForCache(this.respCache(0));
        String src1 = this.getStringKeyForCache(this.respCache(1));
        String dest1 = this.getStringKeyForCache(this.respCache(1));
        r0.zadd((Object)src1, new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b")});
        r1.zadd((Object)src0, new ScoredValue[]{ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((List)r1.zrange((Object)src0, 0L, -1L)).containsOnly((Object[])new String[]{"b", "c"});
        Assertions.assertThat((Long)r0.zrangestore((Object)dest1, (Object)src1, Range.create((Object)0L, (Object)-1L))).isEqualTo(2L);
    }

    public void testPfaddMultipleServers() throws Exception {
        String k0 = this.getStringKeyForCache(this.respCache(0));
        CompletableFuture c1 = this.redisConnection1.async().pfadd((Object)k0, (Object[])new String[]{"el1", "el2"}).toCompletableFuture();
        CompletableFuture c2 = this.redisConnection2.async().pfadd((Object)k0, (Object[])new String[]{"el3", "el4"}).toCompletableFuture();
        CompletableFutures.await((CompletableFuture)c1, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        CompletableFutures.await((CompletableFuture)c2, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        Assertions.assertThat((Long)((Long)c1.get())).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)c2.get())).isEqualTo(1L);
        String k1 = this.getStringKeyForCache(this.respCache(1));
        RedisCommands syncC1 = this.redisConnection1.sync();
        RedisCommands syncC2 = this.redisConnection1.sync();
        for (int i = 0; i < 193; ++i) {
            if ((i & 1) == 1) {
                Assertions.assertThat((Long)syncC1.pfadd((Object)k1, (Object[])new String[]{"el-" + i})).isEqualTo(1L);
                continue;
            }
            Assertions.assertThat((Long)syncC2.pfadd((Object)k1, (Object[])new String[]{"el-" + i})).isEqualTo(1L);
        }
        SoftAssertions sa = new SoftAssertions();
        for (int i = 0; i < 831; ++i) {
            if ((i & 1) == 1) {
                sa.assertThat(syncC1.pfadd((Object)k1, (Object[])new String[]{"hello-" + i})).isEqualTo(1L);
                continue;
            }
            sa.assertThat(syncC2.pfadd((Object)k1, (Object[])new String[]{"hello-" + i})).isEqualTo(1L);
        }
        Assertions.assertThat((Long)syncC1.pfadd((Object)k1, (Object[])new String[]{"el-0", "hello-1", "hello-2"})).isEqualTo(0L);
        Assertions.assertThat((Long)syncC2.pfadd((Object)k1, (Object[])new String[]{"el-0", "hello-1", "hello-2"})).isEqualTo(0L);
        Assertions.assertThat((List)sa.errorsCollected()).hasSize(16);
    }

    @Test
    public void testPubSub() throws InterruptedException {
        RedisPubSubCommands<String, String> connection = this.createPubSubConnection();
        BlockingQueue<String> handOffQueue = this.addPubSubListener(connection);
        List<String> channels = Arrays.asList("channel2", "test", "channel");
        connection.subscribe((Object[])new String[]{"channel2", "test"});
        String value = handOffQueue.poll(10L, TimeUnit.SECONDS);
        Assertions.assertThat((String)value).isEqualTo("subscribed-channel2-1");
        value = handOffQueue.poll(10L, TimeUnit.SECONDS);
        Assertions.assertThat((String)value).isEqualTo("subscribed-test-2");
        RedisCommands redis = this.redisConnection2.sync();
        redis.publish((Object)"channel2", (Object)"boomshakayaka");
        value = handOffQueue.poll(10L, TimeUnit.SECONDS);
        Assertions.assertThat((String)value).isEqualTo("message-channel2-boomshakayaka");
        connection.subscribe((Object[])new String[]{"channel"});
        value = handOffQueue.poll(10L, TimeUnit.SECONDS);
        Assertions.assertThat((String)value).isEqualTo("subscribed-channel-3");
        connection.unsubscribe((Object[])new String[]{"channel2"});
        connection.unsubscribe((Object[])new String[]{"doesn't-exist"});
        connection.unsubscribe((Object[])new String[]{"channel", "test"});
        int subscriptions = 3;
        for (String channel : new String[]{"channel2", "doesn't-exist", "channel", "test"}) {
            value = handOffQueue.poll(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)value).isEqualTo("unsubscribed-" + channel + "-" + Math.max(0, --subscriptions));
        }
    }

    protected RedisPubSubCommands<String, String> createPubSubConnection() {
        return this.client2.connectPubSub().sync();
    }

    private BlockingQueue<String> addPubSubListener(RedisPubSubCommands<String, String> connection) {
        final LinkedBlockingQueue<String> handOffQueue = new LinkedBlockingQueue<String>();
        connection.getStatefulConnection().addListener((RedisPubSubListener)new RedisPubSubAdapter<String, String>(this){
            final /* synthetic */ RespTwoNodeTest this$0;
            {
                this.this$0 = this$0;
            }

            public void message(String channel, String message) {
                log.tracef("Received message on channel %s of %s", (Object)channel, (Object)message);
                handOffQueue.add("message-" + channel + "-" + message);
            }

            public void subscribed(String channel, long count) {
                log.tracef("Subscribed to %s with %s", (Object)channel, (Object)count);
                handOffQueue.add("subscribed-" + channel + "-" + count);
            }

            public void unsubscribed(String channel, long count) {
                log.tracef("Unsubscribed to %s with %s", (Object)channel, (Object)count);
                handOffQueue.add("unsubscribed-" + channel + "-" + count);
            }
        });
        return handOffQueue;
    }

    @Test
    public void testBlpopTwoPushTwoListeners() throws InterruptedException, ExecutionException {
        RedisAsyncCommands redisCommmand1 = this.client1.connect().async();
        RedisAsyncCommands redisCommmand2 = this.client2.connect().async();
        this.redisConnection1.sync().rpush((Object)"keyA", (Object[])new String[]{"val1"});
        this.redisConnection2.sync().rpush((Object)"keyA", (Object[])new String[]{"val2"});
        RedisFuture cf1 = redisCommmand1.blpop(0L, (Object[])new String[]{"keyA"});
        RedisFuture cf2 = redisCommmand2.blpop(0L, (Object[])new String[]{"keyA"});
        Assertions.assertThat(Arrays.asList((String)((KeyValue)cf1.get()).getValue(), (String)((KeyValue)cf2.get()).getValue())).containsExactlyInAnyOrder((Object[])new String[]{"val1", "val2"});
    }

    @Test
    public void testBlpopTwoListenersTwoPush() throws InterruptedException, ExecutionException {
        RedisAsyncCommands redisCommmand1 = this.client1.connect().async();
        RedisAsyncCommands redisCommmand2 = this.client2.connect().async();
        RedisFuture cf1 = redisCommmand1.blpop(0L, (Object[])new String[]{"keyA"});
        RedisFuture cf2 = redisCommmand2.blpop(0L, (Object[])new String[]{"keyA"});
        this.redisConnection1.sync().rpush((Object)"keyA", (Object[])new String[]{"val1"});
        this.redisConnection2.sync().rpush((Object)"keyA", (Object[])new String[]{"val2"});
        Assertions.assertThat(Arrays.asList((String)((KeyValue)cf1.get()).getValue(), (String)((KeyValue)cf2.get()).getValue())).containsExactlyInAnyOrder((Object[])new String[]{"val1", "val2"});
    }

    @Test
    public void testBlpopListenerOn1PushOn2() throws InterruptedException, ExecutionException {
        RedisAsyncCommands redisCommmand1 = this.client1.connect().async();
        RedisFuture cf1 = redisCommmand1.blpop(0L, (Object[])new String[]{"keyA"});
        this.redisConnection2.sync().rpush((Object)"keyA", (Object[])new String[]{"val1", "val2"});
        Assertions.assertThat((String)((String)((KeyValue)cf1.get()).getValue())).isEqualTo("val1");
    }

    @Test
    public void testBlpopPushOn2ListenerOn1() throws InterruptedException, ExecutionException {
        RedisAsyncCommands redisCommmand1 = this.client1.connect().async();
        this.redisConnection2.sync().rpush((Object)"keyA", (Object[])new String[]{"val1", "val2"});
        RedisFuture cf1 = redisCommmand1.blpop(0L, (Object[])new String[]{"keyA"});
        Assertions.assertThat((String)((String)((KeyValue)cf1.get()).getValue())).isEqualTo("val1");
    }

    @Test
    public void testBlpopMixedCase() throws InterruptedException, ExecutionException {
        RedisAsyncCommands redisCommmand1 = this.client1.connect().async();
        RedisAsyncCommands redisCommmand2 = this.client2.connect().async();
        RedisFuture cf1 = redisCommmand1.blpop(0L, (Object[])new String[]{"keyA"});
        this.redisConnection1.sync().rpush((Object)"keyA", (Object[])new String[]{"val1"});
        this.redisConnection2.sync().rpush((Object)"keyA", (Object[])new String[]{"val2"});
        RedisFuture cf2 = redisCommmand2.blpop(0L, (Object[])new String[]{"keyA"});
        Assertions.assertThat(Arrays.asList((String)((KeyValue)cf1.get()).getValue(), (String)((KeyValue)cf2.get()).getValue())).containsExactlyInAnyOrder((Object[])new String[]{"val1", "val2"});
    }

    @Test
    public void testRpushLrange() throws InterruptedException, ExecutionException {
        RedisCommands redisCmd1 = this.redisConnection1.sync();
        RedisCommands redisCmd2 = this.redisConnection2.sync();
        String keyA = this.getStringKeyForCache(this.respCache(0));
        redisCmd1.rpush((Object)keyA, (Object[])new String[]{"val1"});
        redisCmd2.rpush((Object)keyA, (Object[])new String[]{"val2"});
        Assertions.assertThat((List)redisCmd1.lrange((Object)keyA, 0L, -1L)).containsExactlyInAnyOrder((Object[])new String[]{"val1", "val2"});
        Assertions.assertThat((List)redisCmd2.lrange((Object)keyA, 0L, -1L)).containsExactlyInAnyOrder((Object[])new String[]{"val1", "val2"});
    }

    @Test
    public void testJsonSetGet() {
        RedisCommands r0 = this.redisConnection1.sync();
        RedisCommands r1 = this.redisConnection2.sync();
        String numbers = this.getStringKeyForCache(this.respCache(0));
        JsonValue jv = new DefaultJsonParser().createJsonValue("{\"key\":\"value\"}");
        JsonPath jp = new JsonPath("$");
        Assertions.assertThat((String)r0.jsonSet((Object)numbers, jp, jv)).isEqualTo("OK");
        List resultR0 = r0.jsonGet((Object)numbers, new JsonPath[]{jp});
        List resultR1 = r1.jsonGet((Object)numbers, new JsonPath[]{jp});
        Assertions.assertThat((boolean)resultR0.toString().equals(resultR1.toString()));
    }
}

