/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.json.DefaultJsonParser;
import io.lettuce.core.json.JsonType;
import io.lettuce.core.json.JsonValue;
import io.lettuce.core.json.arguments.JsonGetArgs;
import io.lettuce.core.json.arguments.JsonMsetArgs;
import io.lettuce.core.json.arguments.JsonRangeArgs;
import io.lettuce.core.json.arguments.JsonSetArgs;
import io.lettuce.core.output.ArrayOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.NumberListOutput;
import io.lettuce.core.output.StringListOutput;
import io.lettuce.core.output.ValueOutput;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.server.resp.CustomStringCommands;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.JsonCommandsTest")
public class JsonCommandsTest
extends SingleNodeRespBaseTest {
    private RedisCommands<String, String> redis;
    private DefaultJsonParser defaultJsonParser = new DefaultJsonParser();

    @BeforeMethod
    public void initConnection() {
        this.redis = this.redisConnection.sync();
    }

    @Test
    public void testJSONSET() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("{\"key\":\"value\"}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, new io.lettuce.core.json.JsonPath[0])).isEqualTo(true);
        jv = this.defaultJsonParser.createJsonValue("{\n\"key1a\": { \"key2a\": \"val2a\" }\n}\n");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, new io.lettuce.core.json.JsonPath[0])).isEqualTo(true);
        jp = new io.lettuce.core.json.JsonPath("$.key1a.key2b");
        jv = (JsonValue)result.get(0);
        Assertions.assertThat((int)jv.asJsonArray().size()).isEqualTo(1);
        jv = jv.asJsonArray().getFirst();
        JsonValue jv1 = this.defaultJsonParser.createJsonValue("{\"key2a\":\"newVal2\"}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv1)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]);
        Assertions.assertThat((boolean)this.compareJSONSet(result, jv, "$.key1a.key2b", jv1)).isEqualTo(true);
    }

    @Test
    public void testJSONSETAddNode() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jpRoot = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("{\"key1a\":\"val1a\"}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpRoot, jv)).isEqualTo("OK");
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$.key1a.key2b");
        jv = this.defaultJsonParser.createJsonValue("\"val2b\"");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isNull();
        jp = new io.lettuce.core.json.JsonPath("$.key1b");
        jv = this.defaultJsonParser.createJsonValue("\"val1b\"");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        JsonValue jv0 = (JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot}).get(0);
        jv = this.defaultJsonParser.createJsonValue("{\"key2a\":\"val2a\"}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot});
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((boolean)this.compareJSONSet(((JsonValue)result.get(0)).asJsonArray().getFirst(), jv0.asJsonArray().getFirst(), "$.key1b", jv)).isEqualTo(true);
        jv0 = (JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot}).get(0);
        jv = this.defaultJsonParser.createJsonValue("\"val2b\"");
        jp = new io.lettuce.core.json.JsonPath("$.key1b.key2b");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot});
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((boolean)this.compareJSONSet(((JsonValue)result.get(0)).asJsonArray().getFirst(), jv0.asJsonArray().getFirst(), "$.key1b.key2b", jv)).isEqualTo(true);
    }

    @Test
    public void testJSONSETLegacy() {
        CustomStringCommands command = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        String key = TestingUtil.k();
        String doc = "{\"key\":\"value\"}";
        JsonValue json = this.defaultJsonParser.createJsonValue(doc);
        String p = ".";
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath(p);
        Assertions.assertThat((String)command.jsonSet(key, ".", doc)).isEqualTo("OK");
        JsonValue result = this.defaultJsonParser.createJsonValue(command.jsonGet(key, "."));
        Assertions.assertThat((boolean)this.compareJSONGet(result, json, jp)).isEqualTo(true);
        doc = "{\n\"key\": { \"key1\": \"val1\" }\n}\n";
        Assertions.assertThat((String)command.jsonSet(key, ".", doc)).isEqualTo("OK");
        result = this.defaultJsonParser.createJsonValue(command.jsonGet(key, "."));
        json = this.defaultJsonParser.createJsonValue(doc);
        Assertions.assertThat((boolean)this.compareJSONGet(result, json, new io.lettuce.core.json.JsonPath("."))).isEqualTo(true);
        String v1 = "{\"key2\":\"value2\"}";
        Assertions.assertThat((String)command.jsonSet(key, ".key.key", v1)).isEqualTo("OK");
        result = this.defaultJsonParser.createJsonValue(command.jsonGet(key, "."));
        JsonValue jv1 = this.defaultJsonParser.createJsonValue(v1);
        Assertions.assertThat((boolean)this.compareJSONSet(result, json, "$.key.key", jv1)).isEqualTo(true);
    }

    @Test
    public void testJSONSETWithPath() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jpRoot = new io.lettuce.core.json.JsonPath("$");
        JsonValue jvDoc = this.defaultJsonParser.createJsonValue("{\"root\": { \"k1\" : \"v1\", \"k2\":\"v2\"}}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpRoot, jvDoc)).isEqualTo("OK");
        io.lettuce.core.json.JsonPath jpLeaf = new io.lettuce.core.json.JsonPath("$.root.k1");
        JsonValue jvNew = this.defaultJsonParser.createJsonValue("\"newv1\"");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpLeaf, jvNew)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot});
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((boolean)this.compareJSONSet(((JsonValue)result.get(0)).asJsonArray().getFirst(), jvDoc, "$.root.k1", jvNew));
    }

    @Test
    public void testJSONSETInvalidPath() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jpRoot = new io.lettuce.core.json.JsonPath("$");
        JsonValue jvDoc = this.defaultJsonParser.createJsonValue("{\"root\": { \"k1\" : \"v1\", \"k2\":\"v2\"}}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpRoot, jvDoc)).isEqualTo("OK");
        CustomStringCommands command = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        Assertions.assertThatThrownBy(() -> command.jsonSet(key, "", "\"newValue\"")).isInstanceOf(RedisCommandExecutionException.class);
        Assertions.assertThatThrownBy(() -> command.jsonSet(key, "$", "{not-a-json")).isInstanceOf(RedisCommandExecutionException.class);
    }

    @Test
    public void testJSONSETWithPathMulti() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jpRoot = new io.lettuce.core.json.JsonPath("$");
        JsonValue jvDoc = this.defaultJsonParser.createJsonValue("{\"r1\": { \"k1\" : \"v1\", \"k2\":\"v2\"}, \"r2\": { \"k1\" : \"v1\", \"k2\": \"v2\"}, \"r3\": { \"k2\": \"v2\"}}\n");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpRoot, jvDoc)).isEqualTo("OK");
        io.lettuce.core.json.JsonPath jpLeaf = new io.lettuce.core.json.JsonPath("$..k1");
        JsonValue jvNew = this.defaultJsonParser.createJsonValue("\"newv1\"");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpLeaf, jvNew)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]);
        Assertions.assertThat((boolean)this.compareJSONSet(result, jvDoc, "$..k1", jvNew)).isEqualTo(true);
    }

    @Test
    public void testJSONSETWithXX() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("{\"k\":\"v\"}");
        JsonValue jvNew = this.defaultJsonParser.createJsonValue("{\"kNew\":\"vNew\"}");
        JsonSetArgs args = JsonSetArgs.Builder.xx();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv, args)).isNull();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jvNew, args)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{new io.lettuce.core.json.JsonPath("$")});
        Assertions.assertThat((boolean)this.compareJSONGet(result, jvNew, new io.lettuce.core.json.JsonPath[0])).isEqualTo(true);
        io.lettuce.core.json.JsonPath jp1 = new io.lettuce.core.json.JsonPath("$.key1");
        JsonValue jv1New = this.defaultJsonParser.createJsonValue("{\"k1\":\"v1\"}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp1, jv1New, args)).isNull();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp1, jv)).isEqualTo("OK");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp1, jv1New, args)).isEqualTo("OK");
    }

    @Test
    public void testJSONSETWithNX() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("{\"k\":\"v\"}");
        JsonSetArgs args = JsonSetArgs.Builder.nx();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{new io.lettuce.core.json.JsonPath("$")});
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, new io.lettuce.core.json.JsonPath[0])).isEqualTo(true);
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv, args)).isNull();
        io.lettuce.core.json.JsonPath jp1 = new io.lettuce.core.json.JsonPath("$.key1");
        JsonValue jv1New = this.defaultJsonParser.createJsonValue("{\"k1\":\"v1\"}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp1, jv1New, args)).isEqualTo("OK");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp1, jv1New, args)).isNull();
    }

    @Test
    public void testJSONSETNotRoot() {
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$.notroot");
        JsonValue jv = this.defaultJsonParser.createJsonValue("{\"k1\":\"v1\"}");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonSet((Object)TestingUtil.k(), jp, jv)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR new objects must be created at root");
    }

    @Test
    public void testJSONSETWrongPath() {
        CustomStringCommands commands = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        commands.jsonSet(TestingUtil.k(), "$", "{ \"k1\": \"v1\"}");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> commands.jsonSet(TestingUtil.k(), "b a d", "{ \"k1\": \"v1\"}")).isInstanceOf(RedisCommandExecutionException.class)).hasMessageStartingWith("ERR ");
    }

    @Test
    public void testJSONSETPaths() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue doc = this.defaultJsonParser.createJsonValue("{\"key\":\"value\"}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, doc)).isEqualTo("OK");
        jp = new io.lettuce.core.json.JsonPath("$.key1");
        JsonValue newNode = this.defaultJsonParser.createJsonValue("\"value1\"");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, newNode)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]);
        Assertions.assertThat((boolean)this.compareJSONSet(result, doc, "$.key1", newNode)).isEqualTo(true);
        doc = (JsonValue)result.get(0);
        jp = new io.lettuce.core.json.JsonPath("$.key");
        newNode = this.defaultJsonParser.createJsonValue("{\"key_l1\":\"value_l1\"}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, newNode)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]);
        Assertions.assertThat((boolean)this.compareJSONSet(result, doc, "$.key", newNode)).isEqualTo(true);
        jp = new io.lettuce.core.json.JsonPath("$.lev1");
        doc = this.defaultJsonParser.createJsonValue("{\"keyl1\":\"valuel1\"}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, doc)).isEqualTo("OK");
        jp = new io.lettuce.core.json.JsonPath("$.lev1.lev2.lev3");
        doc = this.defaultJsonParser.createJsonValue("{\"keyl2\":\"valuel2\"}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, doc)).isNull();
    }

    @Test
    public void testJSONSETGetMultiPath() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        io.lettuce.core.json.JsonPath jpMulti = new io.lettuce.core.json.JsonPath("$..b");
        String value = "{\"a1\":{\"b\":{\"c\":true,\"d\":[], \"e\": [1,2,3,4]}},\"a2\":{\"b\":{\"c\":2}}, \"a3\":{\"b\":null}}, \"a4\":{\"c\":null}}";
        JsonValue jv = this.defaultJsonParser.createJsonValue(value);
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpMulti});
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jpMulti)).isEqualTo(true);
    }

    @Test
    public void testJSONSETArray() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("{}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        jp = new io.lettuce.core.json.JsonPath("$.foo");
        jv = this.defaultJsonParser.createJsonValue("[]");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        jp = new io.lettuce.core.json.JsonPath("$.foo");
        jv = this.defaultJsonParser.createJsonValue("[0]");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        jp = new io.lettuce.core.json.JsonPath("$.foo[1]");
        jv = this.defaultJsonParser.createJsonValue("[1]");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        io.lettuce.core.json.JsonPath jp1 = new io.lettuce.core.json.JsonPath("$.foo[3]");
        JsonValue jv1 = this.defaultJsonParser.createJsonValue("3");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonSet((Object)key, jp1, jv1)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageStartingWith("ERR ");
    }

    @Test
    public void testJSONSETEmptyArray() {
        String key = TestingUtil.k();
        String value = "{\"emptyArray\":[]}";
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue(value);
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]);
        Assertions.assertThat((List)result).hasSize(1);
        String resultStr = ((JsonValue)result.get(0)).toString();
        Assertions.assertThat((String)resultStr).isEqualTo(value);
    }

    @Test
    public void testJSONSETEmptyObject() {
        String key = TestingUtil.k();
        String value = "{\"emptyObject\":{}}";
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue(value);
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]);
        Assertions.assertThat((List)result).hasSize(1);
        String resultStr = ((JsonValue)result.get(0)).toString();
        Assertions.assertThat((String)resultStr).isEqualTo(value);
    }

    @Test
    public void testJSONSETUndefinitePathError() {
        String key = TestingUtil.k();
        String value = "{}";
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue(value);
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        io.lettuce.core.json.JsonPath jp1 = new io.lettuce.core.json.JsonPath("$..f");
        JsonValue jv1 = this.defaultJsonParser.createJsonValue("1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonSet((Object)key, jp1, jv1)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageStartingWith("ERR ");
        io.lettuce.core.json.JsonPath jp2 = new io.lettuce.core.json.JsonPath("$..[0]");
        JsonValue jv2 = this.defaultJsonParser.createJsonValue("2");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonSet((Object)key, jp2, jv2)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageStartingWith("ERR ");
    }

    @Test
    public void testJSONSETNegativeFloat() {
        String key = TestingUtil.k();
        JsonValue jv = this.defaultJsonParser.createJsonValue("-1.2");
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{new io.lettuce.core.json.JsonPath("$")});
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, new io.lettuce.core.json.JsonPath[0])).isEqualTo(true);
        io.lettuce.core.json.JsonPath jpDot = new io.lettuce.core.json.JsonPath(".");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpDot});
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jpDot)).isEqualTo(true);
    }

    @Test
    public void testJSONGET() {
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("   { \"key1\":\"value1\",\n     \"key2\":\"value2\"\n   }\n");
        Assertions.assertThat((String)this.redis.jsonSet((Object)TestingUtil.k(), jp, jv)).isEqualTo("OK");
        io.lettuce.core.json.JsonPath jp1 = new io.lettuce.core.json.JsonPath("$.key1");
        List result = this.redis.jsonGet((Object)TestingUtil.k(), new io.lettuce.core.json.JsonPath[]{jp1});
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp1)).isEqualTo(true);
        io.lettuce.core.json.JsonPath jp2 = new io.lettuce.core.json.JsonPath("$.key2");
        result = this.redis.jsonGet((Object)TestingUtil.k(), new io.lettuce.core.json.JsonPath[]{jp1, jp2});
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp1, jp2)).isEqualTo(true);
        io.lettuce.core.json.JsonPath jp4 = new io.lettuce.core.json.JsonPath("$.*");
        result = this.redis.jsonGet((Object)TestingUtil.k(), new io.lettuce.core.json.JsonPath[]{jp4});
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp4)).isEqualTo(true);
        io.lettuce.core.json.JsonPath jp5 = new io.lettuce.core.json.JsonPath("$.key1");
        result = this.redis.jsonGet((Object)TestingUtil.k(), new io.lettuce.core.json.JsonPath[]{jp4, jp5});
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp4, jp5)).isEqualTo(true);
        jp5 = new io.lettuce.core.json.JsonPath("$.key5");
        result = this.redis.jsonGet((Object)TestingUtil.k(), new io.lettuce.core.json.JsonPath[]{jp5});
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((boolean)((JsonValue)result.get(0)).isJsonArray()).isTrue();
        Assertions.assertThat((List)((JsonValue)result.get(0)).asJsonArray().asList()).hasSize(0);
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp5)).isEqualTo(true);
        jp5 = new io.lettuce.core.json.JsonPath("$.key5");
        result = this.redis.jsonGet((Object)TestingUtil.k(), new io.lettuce.core.json.JsonPath[]{jp5, jp2});
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp5, jp2)).isEqualTo(true);
    }

    @Test
    public void testJSONGETLegacy() {
        CustomStringCommands command = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("   { \"key1\":\"value1\",\n     \"key2\":[\"value2\",\"value3\"],\n     \"key3\":{\"key4\": \"value4\"},\n     \"key4\": null\n   }\n");
        Assertions.assertThat((String)this.redis.jsonSet((Object)TestingUtil.k(), jp, jv)).isEqualTo("OK");
        String p1 = ".key1";
        io.lettuce.core.json.JsonPath jp1 = new io.lettuce.core.json.JsonPath(p1);
        JsonValue result = this.defaultJsonParser.createJsonValue(command.jsonGet(TestingUtil.k(), p1));
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp1)).isEqualTo(true);
        String p2 = ".key2";
        io.lettuce.core.json.JsonPath jp2 = new io.lettuce.core.json.JsonPath(p2);
        result = this.defaultJsonParser.createJsonValue(command.jsonGet(TestingUtil.k(), p1, p2));
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp1, jp2)).isEqualTo(true);
        String p3 = ".key3";
        io.lettuce.core.json.JsonPath jp3 = new io.lettuce.core.json.JsonPath(p3);
        result = this.defaultJsonParser.createJsonValue(command.jsonGet(TestingUtil.k(), p1, p2, p3));
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp1, jp2, jp3)).isEqualTo(true);
        result = this.defaultJsonParser.createJsonValue(command.jsonGet(TestingUtil.k(), p3));
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp3)).isEqualTo(true);
        String p4 = ".*";
        io.lettuce.core.json.JsonPath jp4 = new io.lettuce.core.json.JsonPath(p4);
        result = this.defaultJsonParser.createJsonValue(command.jsonGet(TestingUtil.k(), p4));
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp4)).isEqualTo(true);
        String p5 = ".key1";
        io.lettuce.core.json.JsonPath jp5 = new io.lettuce.core.json.JsonPath(p5);
        result = this.defaultJsonParser.createJsonValue(command.jsonGet(TestingUtil.k(), p4, p5));
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp4, jp5)).isEqualTo(true);
        String p6 = ".key3";
        String p7 = ".key4";
        String p8 = ".key5";
        io.lettuce.core.json.JsonPath jp6 = new io.lettuce.core.json.JsonPath(p6);
        io.lettuce.core.json.JsonPath jp7 = new io.lettuce.core.json.JsonPath(p7);
        result = this.defaultJsonParser.createJsonValue(command.jsonGet(TestingUtil.k(), p1, p2, p6));
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp1, jp2, jp6)).isEqualTo(true);
        result = this.defaultJsonParser.createJsonValue(command.jsonGet(TestingUtil.k(), p1, p2, p7));
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp1, jp2, jp7)).isEqualTo(true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> command.jsonGet(TestingUtil.k(), p1, p2, p8)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageStartingWith("ERR ");
        result = this.defaultJsonParser.createJsonValue(command.jsonGet(TestingUtil.k(), p4, p6));
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, jp4, jp6)).isEqualTo(true);
    }

    @Test
    public void testJSONGETLegacyError() {
        CustomStringCommands command = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> command.jsonSet(TestingUtil.k(), "..", "{ \"k1\": \"v1\"}")).isInstanceOf(RedisCommandExecutionException.class)).hasMessageStartingWith("ERR ");
    }

    @Test
    public void testJSONSETWrongType() {
        String key = TestingUtil.k();
        JsonValue jv = this.defaultJsonParser.createJsonValue("{\"key\":\"value\"}");
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)key, (Object)TestingUtil.v()), () -> this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{new io.lettuce.core.json.JsonPath("$")}));
        RespTestingUtil.assertWrongType(() -> {}, () -> this.redis.jsonSet((Object)key, jp, jv));
        String k1 = TestingUtil.k((int)1);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)k1, (Object)TestingUtil.v()), () -> this.redis.jsonGet((Object)k1, new io.lettuce.core.json.JsonPath[]{new io.lettuce.core.json.JsonPath("$.k1")}));
        String k2 = TestingUtil.k((int)2);
        RespTestingUtil.assertWrongType(() -> this.redis.jsonSet((Object)k2, jp, jv), () -> this.redis.get((Object)k2));
    }

    @Test
    public void testJSONGETPrettyPrinter() {
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("   { \"key1\":\"value1\",\n     \"key2\":\"value2\"\n   }\n");
        String key = TestingUtil.k();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        io.lettuce.core.json.JsonPath jp1 = new io.lettuce.core.json.JsonPath("$");
        JsonGetArgs args = new JsonGetArgs().indent("1").newline("2").space("3");
        List result = this.redis.jsonGet((Object)key, args, new io.lettuce.core.json.JsonPath[]{jp1});
        Assertions.assertThat((List)result).hasSize(1);
        String strResult = ((JsonValue)result.get(0)).toString();
        String expected = "[21{211\"key1\":3\"value1\",211\"key2\":3\"value2\"21}2]";
        Assertions.assertThat((String)strResult).isEqualTo(expected);
    }

    @Test
    public void testJSONSETWhiteSpaces() {
        String value = "            { \t\"k1\"\n:\n\"v1\"}\n";
        JsonValue jv = this.defaultJsonParser.createJsonValue(value);
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        Assertions.assertThat((String)this.redis.jsonSet((Object)TestingUtil.k(), jp, jv)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)TestingUtil.k(), new io.lettuce.core.json.JsonPath[]{new io.lettuce.core.json.JsonPath("$")});
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((boolean)this.compareJSONGet(result, jv, new io.lettuce.core.json.JsonPath[0])).isTrue();
    }

    @Test
    public void testJSONOBJLEN() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, this.defaultJsonParser.createJsonValue("{}"))).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.jsonObjlen((Object)key)).containsExactly((Object[])new Long[]{0L});
        String jsonValue = "{\n \"root\":  {\n       \"name\": \"Example Name\",\n       \"nested\": {\n           \"field1\": \"value1\",\n           \"field2\": 42\n       },\n       \"items\": [\n           { \"id\": 1, \"value\": \"Item One\" },\n           { \"id\": 2, \"value\": \"Item Two\" },\n           { \"id\": 3, \"value\": \"Item Three\" }\n       ]\n   }\n}\n";
        JsonValue jv = this.defaultJsonParser.createJsonValue(jsonValue);
        this.redis.jsonSet((Object)key, jp, jv);
        List result = this.redis.jsonObjlen((Object)key, jp);
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{1L});
        jp = new io.lettuce.core.json.JsonPath("$.root");
        result = this.redis.jsonObjlen((Object)key, jp);
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{3L});
        jp = new io.lettuce.core.json.JsonPath("$.root.*");
        result = this.redis.jsonObjlen((Object)key, jp);
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{null, 2L, null});
        jp = new io.lettuce.core.json.JsonPath("$.nowhere");
        result = this.redis.jsonObjlen((Object)key, jp);
        Assertions.assertThat((List)result).isEmpty();
        Assertions.assertThat((Long)((Long)this.redis.jsonObjlen((Object)"notExistingKey").get(0))).isNull();
        jp = new io.lettuce.core.json.JsonPath(".");
        Assertions.assertThat((Long)((Long)this.redis.jsonObjlen((Object)"notExistingKey", jp).get(0))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonObjlen((Object)"notExistingKey", new io.lettuce.core.json.JsonPath("$.root"))).isInstanceOf(RedisCommandExecutionException.class)).hasMessageStartingWith("ERR Path '$.root' does not exist or not an object");
    }

    @Test
    public void testJSONSTRLEN() {
        io.lettuce.core.json.JsonPath jpDollar = new io.lettuce.core.json.JsonPath("$");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            StringCodec codec = StringCodec.UTF8;
            this.redis.dispatch((ProtocolKeyword)CommandType.JSON_STRLEN, (CommandOutput)new IntegerOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).addKey((Object)"notExistingKey").add("$"));
        }).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR could not perform this operation on a key that doesn't exist");
        Assertions.assertThat((Long)((Long)this.redis.jsonStrlen((Object)"notExistingKey").get(0))).isNull();
        Assertions.assertThat((Long)((Long)this.redis.jsonStrlen((Object)"notExistingKey", new io.lettuce.core.json.JsonPath(".")).get(0))).isNull();
        this.redis.set((Object)"errorRaise", (Object)"world");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonStrlen((Object)"errorRaise", jpDollar)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("WRONGTYPE Operation against a key holding the wrong kind of value");
        String key = "doc";
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpDollar, this.defaultJsonParser.createJsonValue("\"infinispan\""))).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.jsonStrlen((Object)key)).containsExactly((Object[])new Long[]{10L});
        JsonValue jv = this.defaultJsonParser.createJsonValue("   {\"a\":\"foo\", \"nested\": {\"a\": \"hello\"}, \"nested2\": {\"a\": 31}}\n");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpDollar, jv)).isEqualTo("OK");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonStrlen((Object)key, new io.lettuce.core.json.JsonPath("."))).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '.' does not exist or not a string");
        Assertions.assertThat((List)this.redis.jsonStrlen((Object)key, new io.lettuce.core.json.JsonPath("$..a"))).containsExactly((Object[])new Long[]{3L, 5L, null});
    }

    @Test
    public void testJSONARRLEN() {
        io.lettuce.core.json.JsonPath jpDollar = new io.lettuce.core.json.JsonPath("$");
        StringCodec codec = StringCodec.UTF8;
        JsonValue jv = this.defaultJsonParser.createJsonValue("   {\n       \"name\":\"Wireless earbuds\",\n       \"description\":\"Wireless Bluetooth in-ear headphones\",\n       \"connection\":{\"wireless\":true,\"type\":\"Bluetooth\"},\n       \"price\":64.99,\"stock\":17,\n       \"colors\":[\"black\",\"white\"],\n       \"max_level\":[80, 100, 120]\n    }\n");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testJSONARRLEN$0((RedisCodec)codec)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR could not perform this operation on a key that doesn't exist");
        Assertions.assertThat((Long)((Long)this.redis.jsonArrlen((Object)"notExistingKey").get(0))).isNull();
        Assertions.assertThat((Long)((Long)this.redis.jsonArrlen((Object)"notExistingKey", new io.lettuce.core.json.JsonPath(".")).get(0))).isNull();
        this.redis.set((Object)"errorRaise", (Object)"world");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonArrlen((Object)"errorRaise", jpDollar)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("WRONGTYPE Operation against a key holding the wrong kind of value");
        String key = "doc";
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpDollar, this.defaultJsonParser.createJsonValue("[]"))).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.jsonArrlen((Object)key)).containsExactly((Object[])new Long[]{0L});
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpDollar, this.defaultJsonParser.createJsonValue("\"hello\""))).isEqualTo("OK");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonArrlen((Object)key)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '.' does not exist or not an array");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpDollar, this.defaultJsonParser.createJsonValue("{\"v1\": 2}"))).isEqualTo("OK");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonArrlen((Object)key)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '.' does not exist or not an array");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpDollar, jv)).isEqualTo("OK");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonArrlen((Object)key, new io.lettuce.core.json.JsonPath("."))).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '.' does not exist or not an array");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonArrlen((Object)key, new io.lettuce.core.json.JsonPath("..notExists"))).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '..notExists' does not exist");
        Assertions.assertThat((List)this.redis.jsonArrlen((Object)key, new io.lettuce.core.json.JsonPath("$..max_level"))).containsExactly((Object[])new Long[]{3L});
        Assertions.assertThat((List)this.redis.jsonArrlen((Object)key, new io.lettuce.core.json.JsonPath("$.[*]"))).containsExactly((Object[])new Long[]{null, null, null, null, null, 2L, 3L});
    }

    @Test
    public void testJSONTYPE() {
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        StringCodec codec = StringCodec.UTF8;
        String key = TestingUtil.k();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, this.defaultJsonParser.createJsonValue("[]"))).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.jsonType((Object)key)).containsExactly((Object[])new JsonType[]{JsonType.ARRAY});
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, this.defaultJsonParser.createJsonValue("\"hello json string\""))).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.jsonType((Object)key)).containsExactly((Object[])new JsonType[]{JsonType.STRING});
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, this.defaultJsonParser.createJsonValue("1"))).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.jsonType((Object)key)).containsExactly((Object[])new JsonType[]{JsonType.INTEGER});
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, this.defaultJsonParser.createJsonValue("true"))).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.jsonType((Object)key)).containsExactly((Object[])new JsonType[]{JsonType.BOOLEAN});
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, this.defaultJsonParser.createJsonValue("{}"))).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.jsonType((Object)key)).containsExactly((Object[])new JsonType[]{JsonType.OBJECT});
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, this.defaultJsonParser.createJsonValue("2.0"))).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.jsonType((Object)key)).containsExactly((Object[])new JsonType[]{JsonType.NUMBER});
        JsonValue jv = this.defaultJsonParser.createJsonValue("   {\"a\":2,\n   \"null_value\": null,\n   \"float_value\": 12.3,\n   \"arr_value\": [\"one\", \"two\", \"three\"],\n   \"nested\":\n      {\"a\": true},\n   \"foo\": \"bar\"}\n");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        Assertions.assertThat((String)((String)this.redis.dispatch((ProtocolKeyword)CommandType.JSON_TYPE, (CommandOutput)new ValueOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).addKey((Object)key).add("..a")))).isEqualTo("integer");
        Assertions.assertThat((List)this.redis.jsonType((Object)key)).containsExactly((Object[])new JsonType[]{JsonType.OBJECT});
        Assertions.assertThat((List)this.redis.jsonType((Object)key, new io.lettuce.core.json.JsonPath("$..foo"))).containsExactly((Object[])new JsonType[]{JsonType.STRING});
        Assertions.assertThat((List)this.redis.jsonType((Object)key, new io.lettuce.core.json.JsonPath("$..null_value"))).containsExactly((Object[])new JsonType[]{JsonType.UNKNOWN});
        Assertions.assertThat((List)((List)this.redis.dispatch((ProtocolKeyword)CommandType.JSON_TYPE, (CommandOutput)new StringListOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).addKey((Object)key).add("$..null_value")))).containsExactly((Object[])new String[]{"null"});
        Assertions.assertThat((List)this.redis.jsonType((Object)key, new io.lettuce.core.json.JsonPath("$..a"))).containsExactly((Object[])new JsonType[]{JsonType.INTEGER, JsonType.BOOLEAN});
        Assertions.assertThat((List)this.redis.jsonType((Object)key, new io.lettuce.core.json.JsonPath("$..float_value"))).containsExactly((Object[])new JsonType[]{JsonType.NUMBER});
        Assertions.assertThat((List)this.redis.jsonType((Object)key, new io.lettuce.core.json.JsonPath("$..arr_value"))).containsExactly((Object[])new JsonType[]{JsonType.ARRAY});
        Assertions.assertThat((List)this.redis.jsonType((Object)key, new io.lettuce.core.json.JsonPath("$..dummy"))).isEmpty();
        Assertions.assertThat((Long)((Long)this.redis.dispatch((ProtocolKeyword)CommandType.JSON_TYPE, (CommandOutput)new IntegerOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).addKey((Object)"notExistingKey")))).isNull();
    }

    public void testJSONDEL() {
        String key = TestingUtil.k();
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        String jsonStr = "   {\n      \"name\": \"Alice\",\n      \"age\": 30,\n      \"isStudent\": false,\n      \"grades\": [85, 90, 78],\n      \"address\": {\n        \"verified\": true,\n        \"city\": \"New York\",\n        \"zip\": \"10001\"\n      },\n      \"phone\": null\n    }\n";
        JsonValue jv = this.defaultJsonParser.createJsonValue(jsonStr);
        this.redis.jsonSet((Object)key, jp, jv);
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(1L);
        Assertions.assertThat((String)((String)this.redis.get((Object)key))).isNull();
        this.redis.jsonSet((Object)key, jp, jv);
        jp = new io.lettuce.core.json.JsonPath("$.address.city");
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(1L);
        jp = new io.lettuce.core.json.JsonPath("$.address.*");
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(2L);
        jp = new io.lettuce.core.json.JsonPath("$.phone");
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(1L);
        jp = new io.lettuce.core.json.JsonPath("$.grades[2]");
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(1L);
        List jsonGetResult = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]);
        Assertions.assertThat((List)jsonGetResult).hasSize(1);
        jp = new io.lettuce.core.json.JsonPath("$.grades[3]");
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(0L);
        jp = new io.lettuce.core.json.JsonPath("$.*");
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(5L);
        jsonGetResult = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]);
        Assertions.assertThat((List)jsonGetResult).hasSize(1);
        Assertions.assertThat((String)((JsonValue)jsonGetResult.get(0)).toString()).isEqualTo("{}");
        jp = new io.lettuce.core.json.JsonPath(".");
        jv = this.defaultJsonParser.createJsonValue(jsonStr);
        this.redis.jsonSet((Object)key, jp, jv);
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(1L);
        Assertions.assertThat((String)((String)this.redis.get((Object)key))).isNull();
        this.redis.jsonSet((Object)key, jp, jv);
        jp = new io.lettuce.core.json.JsonPath(".address.city");
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(1L);
        jp = new io.lettuce.core.json.JsonPath(".address.*");
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(2L);
        jp = new io.lettuce.core.json.JsonPath(".phone");
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(1L);
        jp = new io.lettuce.core.json.JsonPath(".grades[2]");
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(1L);
        jsonGetResult = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]);
        Assertions.assertThat((List)jsonGetResult).hasSize(1);
        jp = new io.lettuce.core.json.JsonPath(".grades[3]");
        Assertions.assertThat((Long)this.redis.jsonDel((Object)key, jp)).isEqualTo(0L);
    }

    @Test
    public void testJSONFORGET() {
        String key = TestingUtil.k();
        String jsonStr = "   {\n      \"name\": \"Alice\",\n      \"age\": 30,\n      \"isStudent\": false,\n      \"grades\": [85, 90, 78],\n      \"address\": {\n        \"verified\": true,\n        \"city\": \"New York\",\n        \"zip\": \"10001\"\n      },\n      \"phone\": null\n    }\n";
        JsonValue jv = this.defaultJsonParser.createJsonValue(jsonStr);
        this.redis.jsonSet((Object)key, new io.lettuce.core.json.JsonPath("$"), jv);
        CustomStringCommands command = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        Assertions.assertThat((Long)command.jsonForget(key, "$")).isEqualTo(1L);
        Assertions.assertThat((String)((String)this.redis.get((Object)key))).isNull();
    }

    @Test
    public void testJSONSTRAPPEND() {
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("\"string\"");
        String key = TestingUtil.k();
        this.redis.jsonSet((Object)key, jp, jv);
        JsonValue append = this.defaultJsonParser.fromObject((Object)"Append");
        Assertions.assertThat((List)this.redis.jsonStrappend((Object)key, jp, append)).containsExactly((Object[])new Long[]{12L});
        List jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[\"stringAppend\"]");
        jv = this.defaultJsonParser.createJsonValue("   {\"a\":2,\n   \"null_value\": null,\n   \"float_value\": 12.3,\n   \"arr_value\": [\"one\", \"two\", \"three\"],\n   \"nested\":\n      {\"a\": true,\n      \"foo\": false,\n      \"nested2\": {\n       \"foo\": \"fore\"}},\n   \"foo\": \"bar\"}\n");
        key = TestingUtil.k((int)1);
        this.redis.jsonSet((Object)key, jp, jv);
        jp = new io.lettuce.core.json.JsonPath("$.foo");
        Assertions.assertThat((List)this.redis.jsonStrappend((Object)key, jp, append)).containsExactly((Object[])new Long[]{9L});
        jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[\"barAppend\"]");
        jp = new io.lettuce.core.json.JsonPath("$..foo");
        Assertions.assertThat((List)this.redis.jsonStrappend((Object)key, jp, append)).containsExactly((Object[])new Long[]{15L, null, 10L});
        jp = new io.lettuce.core.json.JsonPath("$.float_value");
        List jsonStrappend = this.redis.jsonStrappend((Object)key, jp, append);
        Assertions.assertThat((List)jsonStrappend).containsExactly((Object[])new Long[]{null});
        jp = new io.lettuce.core.json.JsonPath(".");
        JsonValue jv1 = this.defaultJsonParser.createJsonValue("\"string\"");
        this.redis.jsonSet((Object)key, jp, jv1);
        append = this.defaultJsonParser.fromObject((Object)"Append");
        Assertions.assertThat((List)this.redis.jsonStrappend((Object)key, jp, append)).containsExactly((Object[])new Long[]{12L});
        jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("\"stringAppend\"");
        key = TestingUtil.k((int)1);
        this.redis.jsonSet((Object)key, jp, jv);
        jp = new io.lettuce.core.json.JsonPath(".foo");
        Assertions.assertThat((List)this.redis.jsonStrappend((Object)key, jp, append)).containsExactly((Object[])new Long[]{9L});
        jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("\"barAppend\"");
        jp = new io.lettuce.core.json.JsonPath(".float_value");
        String keyFinal = key;
        io.lettuce.core.json.JsonPath jpFinal = jp;
        JsonValue appendFinal = append;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonStrappend((Object)keyFinal, jpFinal, appendFinal)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '$.float_value' does not exist or not a string");
        Assertions.assertThat((List)jsonStrappend).containsExactly((Object[])new Long[]{null});
    }

    @Test
    public void testJSONARRAPPEND() {
        CustomStringCommands command = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("[1, \"a\", {\"o\":\"v\"}]");
        String key = TestingUtil.k();
        this.redis.jsonSet((Object)key, jp, jv);
        List arr = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((List)arr).isNotNull();
        Long res = command.jsonArrappend(key, "$", "\"aString\"", "1", "{\"aObj\": null}");
        Assertions.assertThat((Long)res).isEqualTo(6L);
        List jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[[1,\"a\",{\"o\":\"v\"},\"aString\",1,{\"aObj\":null}]]");
        jv = this.defaultJsonParser.createJsonValue("   {\"a\": 2,\n   \"arr_value\": [\"one\", \"two\", \"three\"],\n   \"nested\":\n      {\"a\": true,\n      \"nested2\": {\n       \"foo\": \"fore\"},\n       \"arr_value\": [1,2,3,4]\n      },\n   \"nested1\":\n      {\n       \"arr_value\": null\n      },\n   \"nested2\":\n      {\n       \"arr_value\": 1\n      }\n   }\n");
        key = TestingUtil.k((int)1);
        this.redis.jsonSet((Object)key, jp, jv);
        jp = new io.lettuce.core.json.JsonPath("$.nested.arr_value");
        JsonValue app1 = this.defaultJsonParser.fromObject((Object)"aString");
        JsonValue app2 = this.defaultJsonParser.fromObject((Object)1);
        JsonValue app3 = this.defaultJsonParser.createJsonValue("{\"aObj\": null}");
        List jsonArrappend = this.redis.jsonArrappend((Object)key, jp, new JsonValue[]{app1, app2, app3});
        Assertions.assertThat((List)jsonArrappend).containsExactly((Object[])new Long[]{7L});
        jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[[1,2,3,4,\"aString\",1,{\"aObj\":null}]]");
        jp = new io.lettuce.core.json.JsonPath("$..arr_value");
        Assertions.assertThat((List)this.redis.jsonArrappend((Object)key, jp, new JsonValue[]{app1, app2, app3})).containsExactly((Object[])new Long[]{6L, 10L, null, null});
        command = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        jp = new io.lettuce.core.json.JsonPath("$");
        jv = this.defaultJsonParser.createJsonValue("[1, \"a\", {\"o\":\"v\"}]");
        key = TestingUtil.k();
        this.redis.jsonSet((Object)key, jp, jv);
        arr = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((List)arr).isNotNull();
        res = command.jsonArrappend(key, ".", "\"aString\"", "1", "{\"aObj\": null}");
        Assertions.assertThat((Long)res).isEqualTo(6L);
        jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[[1,\"a\",{\"o\":\"v\"},\"aString\",1,{\"aObj\":null}]]");
        jv = this.defaultJsonParser.createJsonValue("   {\"a\": 2,\n   \"arr_value\": [\"one\", \"two\", \"three\"],\n   \"nested\":\n      {\"a\": true,\n      \"nested2\": {\n       \"foo\": \"fore\"},\n       \"arr_value\": [1,2,3,4]\n      },\n   \"nested1\":\n      {\n       \"arr_value\": null\n      },\n   \"nested2\":\n      {\n       \"arr_value\": 1\n      }\n   }\n");
        key = TestingUtil.k((int)1);
        this.redis.jsonSet((Object)key, jp, jv);
        jp = new io.lettuce.core.json.JsonPath(".nested.arr_value");
        app1 = this.defaultJsonParser.fromObject((Object)"aString");
        app2 = this.defaultJsonParser.fromObject((Object)1);
        app3 = this.defaultJsonParser.createJsonValue("{\"aObj\": null}");
        Assertions.assertThat((List)this.redis.jsonArrappend((Object)key, jp, new JsonValue[]{app1, app2, app3})).containsExactly((Object[])new Long[]{7L});
        jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[1,2,3,4,\"aString\",1,{\"aObj\":null}]");
    }

    @Test
    public void testJSONTOGGLE() {
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        StringCodec codec = StringCodec.UTF8;
        String key = TestingUtil.k();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, this.defaultJsonParser.createJsonValue("true"))).isEqualTo("OK");
        Assertions.assertThat((Boolean)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).asBoolean()).isTrue();
        Assertions.assertThat((String)((String)this.redis.dispatch((ProtocolKeyword)CommandType.JSON_TOGGLE, (CommandOutput)new ValueOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).addKey((Object)key).add(".")))).isEqualTo("false");
        Assertions.assertThat((Boolean)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).asBoolean()).isFalse();
        JsonValue jv = this.defaultJsonParser.createJsonValue("   {\"bool\":true,\n   \"null_value\": null,\n   \"arr_value\": [\"one\", \"two\", \"three\"],\n   \"nested\":\n      {\"bool\": false},\n   \"foo\": \"bar\",\n   \"legacy\": true}\n");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        Assertions.assertThat((String)((String)this.redis.dispatch((ProtocolKeyword)CommandType.JSON_TOGGLE, (CommandOutput)new ValueOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).addKey((Object)key).add("..legacy")))).isEqualTo("false");
        Assertions.assertThat((String)((String)this.redis.dispatch((ProtocolKeyword)CommandType.JSON_TOGGLE, (CommandOutput)new ValueOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).addKey((Object)key).add("..legacy")))).isEqualTo("true");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testJSONTOGGLE$0((RedisCodec)codec, key)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '$..notExistingPathLegacy' does not exist or not a bool");
        Assertions.assertThat((List)this.redis.jsonToggle((Object)key, new io.lettuce.core.json.JsonPath("$..bool"))).containsExactly((Object[])new Long[]{0L, 1L});
        Assertions.assertThat((List)this.redis.jsonToggle((Object)key, new io.lettuce.core.json.JsonPath("$..bool"))).containsExactly((Object[])new Long[]{1L, 0L});
        Assertions.assertThat((List)this.redis.jsonToggle((Object)key, new io.lettuce.core.json.JsonPath("$.bool"))).containsExactly((Object[])new Long[]{0L});
        Assertions.assertThat((List)this.redis.jsonToggle((Object)key, new io.lettuce.core.json.JsonPath("$..notExistingPath"))).isEmpty();
        Assertions.assertThat((Long)((Long)this.redis.jsonToggle((Object)key, new io.lettuce.core.json.JsonPath("$..null_value")).get(0))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonToggle((Object)"notExistingKey", new io.lettuce.core.json.JsonPath("$..value"))).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR could not perform this operation on a key that doesn't exist");
    }

    @Test
    public void testJSONOBJKEYS() {
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("   {\"bool\":true,\n   \"null_value\": null,\n   \"arr_value\": [\"one\", \"two\", \"three\"],\n   \"nested\":\n      {\"bool\": false,\n       \"stringKey\": \"aString\"},\n   \"foo\": \"bar\",\n   \"legacy\": true}\n");
        String key = TestingUtil.k();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        jp = new io.lettuce.core.json.JsonPath("$");
        List result = this.redis.jsonObjkeys((Object)key, jp);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"bool", "null_value", "arr_value", "nested", "foo", "legacy"});
        jp = new io.lettuce.core.json.JsonPath("$.bool");
        result = this.redis.jsonObjkeys((Object)key, jp);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{null});
        jp = new io.lettuce.core.json.JsonPath("$.nested");
        result = this.redis.jsonObjkeys((Object)key, jp);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"bool", "stringKey"});
        jp = new io.lettuce.core.json.JsonPath("$.*");
        result = this.redis.jsonObjkeys((Object)key, jp);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{null, null, null, "bool", "stringKey", null, null});
        jp = new io.lettuce.core.json.JsonPath("$.non_existing");
        result = this.redis.jsonObjkeys((Object)key, jp);
        Assertions.assertThat((List)result).isEmpty();
        jp = new io.lettuce.core.json.JsonPath("$");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        jp = new io.lettuce.core.json.JsonPath(".");
        result = this.redis.jsonObjkeys((Object)key, jp);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"bool", "null_value", "arr_value", "nested", "foo", "legacy"});
        io.lettuce.core.json.JsonPath jp1 = new io.lettuce.core.json.JsonPath(".bool");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonObjkeys((Object)key, jp1)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '$.bool' does not exist or not an object");
        jp = new io.lettuce.core.json.JsonPath("$.non_existing");
        result = this.redis.jsonObjkeys((Object)key, jp);
        Assertions.assertThat((List)result).isEmpty();
    }

    @Test
    public void testJSONNUMINCRBY() {
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("  {\"a\":\"b\", \"b\": [{\"a\":2}, {\"a\":\"c\"}, {\"a\":5.4}, {\"a\":true}, {\"a\":[\"hello\"]}]}\n");
        String key = TestingUtil.k();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, this.defaultJsonParser.createJsonValue("1"))).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.jsonNumincrby((Object)key, jp, (Number)2)).containsExactly((Object[])new Number[]{3L});
        Assertions.assertThat((boolean)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).isNumber()).isTrue();
        Assertions.assertThat((int)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).asNumber().intValue()).isEqualTo(3);
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.jsonNumincrby((Object)key, new io.lettuce.core.json.JsonPath("$..a"), (Number)2)).containsExactly((Object[])new Number[]{null, 4L, null, 7.4, null, null});
        Assertions.assertThat((List)this.redis.jsonNumincrby((Object)key, new io.lettuce.core.json.JsonPath("$..a"), (Number)2.4)).containsExactly((Object[])new Number[]{null, 6.4, null, 9.8, null, null});
        List bPathNumbers = this.redis.jsonNumincrby((Object)key, new io.lettuce.core.json.JsonPath("$..b"), (Number)22);
        Assertions.assertThat((List)bPathNumbers).hasSize(1);
        Assertions.assertThat((Object)((Number)bPathNumbers.get(0))).isNull();
        Assertions.assertThat((List)this.redis.jsonNumincrby((Object)key, new io.lettuce.core.json.JsonPath("$..notExisting"), (Number)12.0)).isEmpty();
        Assertions.assertThat((List)this.redis.jsonNumincrby((Object)key, new io.lettuce.core.json.JsonPath("..notExisting"), (Number)12.0)).isEmpty();
        Assertions.assertThat((List)this.redis.jsonNumincrby((Object)key, new io.lettuce.core.json.JsonPath(".notExisting"), (Number)12.0)).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonNumincrby((Object)"notExistingKey", new io.lettuce.core.json.JsonPath("$..a"), (Number)2)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR could not perform this operation on a key that doesn't exist");
    }

    @Test
    public void testJSONNUMMULTRBY() {
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("  {\"a\":\"b\", \"b\": [{\"a\":2}, {\"a\":\"c\"}, {\"a\":5.4}, {\"a\":true}, {\"a\":[\"hello\"]}]}\n");
        String key = TestingUtil.k();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        Assertions.assertThat(this.jsonMultBy(key, "$..a", 2)).containsExactly((Object[])new Number[]{null, 4L, null, 10.8, null, null});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.jsonMultBy("notExistingKey", "$", 2)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR could not perform this operation on a key that doesn't exist");
    }

    private List<Number> jsonMultBy(String key, String path, int multiplier) {
        StringCodec codec = StringCodec.UTF8;
        return (List)this.redis.dispatch((ProtocolKeyword)TestCommandType.JSON_NUMMULTBY, (CommandOutput)new NumberListOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).addKey((Object)key).add(path).add((long)multiplier));
    }

    public void testJSONARRINDEX() {
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("   {\"bool\":true,\n   \"null_value\": null,\n   \"arr_value\": [\"one\", \"two\", \"three\"],\n   \"nested\":\n      {\"bool\": false,\n       \"arr_value\": [\"one\", \"three\",\"four\"],\n       \"stringKey\": \"aString\"},\n   \"nested1\":\n      {\"bool\": false,\n       \"arr_value\": \"not an array\",\n       \"stringKey\": \"aString\"},\n   \"foo\": \"bar\",\n   \"legacy\": true}\n");
        String key = TestingUtil.k();
        this.redis.jsonSet((Object)key, jp, jv);
        jp = new io.lettuce.core.json.JsonPath("$.arr_value");
        JsonValue jv1 = this.defaultJsonParser.createJsonValue("\"three\"");
        List result = this.redis.jsonArrindex((Object)key, jp, jv1);
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{2L});
        result = this.redis.jsonArrindex((Object)key, jp, jv1, JsonRangeArgs.Builder.start((long)0L).stop(-1L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{-1L});
        result = this.redis.jsonArrindex((Object)key, jp, jv1, JsonRangeArgs.Builder.start((long)1L).stop(0L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{2L});
        result = this.redis.jsonArrindex((Object)key, jp, jv1, JsonRangeArgs.Builder.start((long)0L).stop(10L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{2L});
        result = this.redis.jsonArrindex((Object)key, jp, jv1, JsonRangeArgs.Builder.start((long)0L).stop(10L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{2L});
        result = this.redis.jsonArrindex((Object)key, jp, jv1, JsonRangeArgs.Builder.start((long)5L).stop(1L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{-1L});
        jp = new io.lettuce.core.json.JsonPath("$..arr_value");
        result = this.redis.jsonArrindex((Object)key, jp, jv1);
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{2L, 1L, null});
        result = this.redis.jsonArrindex((Object)key, jp, jv1, JsonRangeArgs.Builder.start((long)0L).stop(-1L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{-1L, 1L, null});
        io.lettuce.core.json.JsonPath jp1 = new io.lettuce.core.json.JsonPath("$.bool");
        JsonValue jv2 = jv1;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonArrindex((Object)"non-existent", jp1, jv2)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '$.bool' does not exist");
        io.lettuce.core.json.JsonPath jp2 = new io.lettuce.core.json.JsonPath("$.non-existent");
        Assertions.assertThat((List)this.redis.jsonArrindex((Object)key, jp2, jv1)).isEmpty();
        jp = new io.lettuce.core.json.JsonPath("$.arr_value");
        jv1 = this.defaultJsonParser.createJsonValue("\"three\"");
        result = this.redis.jsonArrindex((Object)key, jp, jv1);
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{2L});
        io.lettuce.core.json.JsonPath jp3 = new io.lettuce.core.json.JsonPath(".non-existent");
        jp = new io.lettuce.core.json.JsonPath("..arr_value");
        result = this.redis.jsonArrindex((Object)key, jp, jv1);
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{2L});
        result = this.redis.jsonArrindex((Object)key, jp, jv1, JsonRangeArgs.Builder.start((long)0L).stop(-1L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{-1L});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonArrindex((Object)key, jp3, jv2)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '$.non-existent' does not exist");
    }

    @Test
    public void testJSONARRPOP() {
        io.lettuce.core.json.JsonPath jpRoot = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("   [\"one\", \"two\", \"three\",\"four\"]\n");
        String key = TestingUtil.k();
        this.redis.jsonSet((Object)key, jpRoot, jv);
        List result = this.redis.jsonArrpop((Object)key);
        Assertions.assertThat((String)result.toString()).isEqualTo("[\"four\"]");
        result = this.redis.jsonArrpop((Object)key, jpRoot, 0);
        Assertions.assertThat((String)result.toString()).isEqualTo("[\"one\"]");
        result = this.redis.jsonArrpop((Object)key, jpRoot, -1);
        Assertions.assertThat((String)result.toString()).isEqualTo("[\"three\"]");
        result = this.redis.jsonArrpop((Object)key, jpRoot, 1);
        Assertions.assertThat((String)result.toString()).isEqualTo("[\"two\"]");
        jv = this.defaultJsonParser.createJsonValue("   {\"bool\":true,\n   \"null_value\": null,\n   \"arr_value\": [\"one\", \"two\", \"three\"],\n   \"nested\":\n      {\"bool\": false,\n       \"arr_value\": [1, 2, 3, 4],\n       \"stringKey\": \"aString\"},\n   \"foo\": \"bar\",\n   \"legacy\": true}\n");
        this.redis.jsonSet((Object)key, jpRoot, jv);
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$..arr_value");
        result = this.redis.jsonArrpop((Object)key, jp, 1);
        Assertions.assertThat((String)result.toString()).isEqualTo("[\"two\", 2]");
        result = this.redis.jsonArrpop((Object)key, jp, -1);
        Assertions.assertThat((String)result.toString()).isEqualTo("[\"three\", 4]");
        result = this.redis.jsonArrpop((Object)key, jp, 0);
        Assertions.assertThat((String)result.toString()).isEqualTo("[\"one\", 1]");
        this.redis.jsonSet((Object)key, jpRoot, jv);
        jp = new io.lettuce.core.json.JsonPath("..arr_value");
        result = this.redis.jsonArrpop((Object)key, jp, 1);
        Assertions.assertThat((String)result.toString()).isEqualTo("[2]");
        result = this.redis.jsonArrpop((Object)key, jp, -1);
        Assertions.assertThat((String)result.toString()).isEqualTo("[4]");
        result = this.redis.jsonArrpop((Object)key, jp, 0);
        Assertions.assertThat((String)result.toString()).isEqualTo("[1]");
    }

    @Test
    public void testJSONARRTRIM() {
        CustomStringCommands command = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        io.lettuce.core.json.JsonPath jpRoot = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("   {\"bool\":true,\n   \"null_value\": null,\n   \"arr_value\": [\"one\", \"two\", \"three\", \"four\"],\n   \"nested\":\n      {\"bool\": false,\n       \"arr_value\": [1,2,3],\n       \"stringKey\": \"aString\"},\n   \"nested1\":\n      {\"bool\": false,\n       \"arr_value\": \"not an array\",\n       \"stringKey\": \"aString\"},\n   \"foo\": \"bar\",\n   \"legacy\": true}\n");
        String key = TestingUtil.k();
        this.redis.jsonSet((Object)key, jpRoot, jv);
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$.arr_value");
        List result = this.redis.jsonArrtrim((Object)key, jp, JsonRangeArgs.Builder.start((long)0L).stop(1L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{2L});
        Assertions.assertThat((String)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp}).get(0)).toString()).isEqualTo("[[\"one\",\"two\"]]");
        this.redis.jsonSet((Object)key, jpRoot, jv);
        Long result1 = command.jsonArrtrim(key, "$.arr_value", 4, 5);
        Assertions.assertThat((Long)result1).isEqualTo(0L);
        List jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[[]]");
        this.redis.jsonSet((Object)key, jpRoot, jv);
        result1 = command.jsonArrtrim(key, "$.arr_value", 1, 0);
        Assertions.assertThat((Long)result1).isEqualTo(0L);
        Assertions.assertThat((String)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp}).get(0)).toString()).isEqualTo("[[]]");
        this.redis.jsonSet((Object)key, jpRoot, jv);
        result = this.redis.jsonArrtrim((Object)key, jp, JsonRangeArgs.Builder.start((long)-2L).stop(-1L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{2L});
        Assertions.assertThat((String)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp}).get(0)).toString()).isEqualTo("[[\"three\",\"four\"]]");
        this.redis.jsonSet((Object)key, jpRoot, jv);
        result = this.redis.jsonArrtrim((Object)key, jp, JsonRangeArgs.Builder.start((long)2L).stop(5L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{2L});
        Assertions.assertThat((String)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp}).get(0)).toString()).isEqualTo("[[\"three\",\"four\"]]");
        this.redis.jsonSet((Object)key, jpRoot, jv);
        jp = new io.lettuce.core.json.JsonPath("$..arr_value");
        result = this.redis.jsonArrtrim((Object)key, jp, JsonRangeArgs.Builder.start((long)2L).stop(4L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{2L, 1L, null});
        List jsonGet2 = ((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp}).get(0)).asJsonArray().asList();
        Assertions.assertThat(JsonCommandsTest.jsonValueListToStringList(jsonGet2)).containsExactly((Object[])new String[]{"[\"three\",\"four\"]", "[3]", "\"not an array\""});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonArrtrim((Object)"non-existent", new io.lettuce.core.json.JsonPath("$.arr_value"), JsonRangeArgs.Builder.start((long)0L).stop(1L))).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR could not perform this operation on a key that doesn't exist");
        Assertions.assertThat((List)this.redis.jsonArrtrim((Object)key, new io.lettuce.core.json.JsonPath("$.non-existent"), JsonRangeArgs.Builder.start((long)0L).stop(1L))).isEmpty();
        this.redis.jsonSet((Object)key, jpRoot, jv);
        jp = new io.lettuce.core.json.JsonPath("..arr_value");
        result = this.redis.jsonArrtrim((Object)key, jp, JsonRangeArgs.Builder.start((long)2L).stop(4L));
        Assertions.assertThat((List)result).containsExactly((Object[])new Long[]{1L});
        JsonValue jsonGet3 = (JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp}).get(0);
        Assertions.assertThat((String)jsonGet3.toString()).isEqualTo("[\"three\",\"four\"]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonArrtrim((Object)key, new io.lettuce.core.json.JsonPath(".non-existing"), JsonRangeArgs.Builder.start((long)0L).stop(1L))).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '$.non-existing' does not exist or not an array");
    }

    private static List<String> jsonValueListToStringList(List<JsonValue> jsonValues) {
        return jsonValues.stream().map(JsonValue::toString).collect(Collectors.toList());
    }

    @Test
    public void testJSONCLEAR() {
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        String key = TestingUtil.k();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, this.defaultJsonParser.createJsonValue("3"))).isEqualTo("OK");
        Assertions.assertThat((Object)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).asNumber()).isEqualTo((Object)3);
        Assertions.assertThat((Long)this.redis.jsonClear((Object)key)).isEqualTo(1L);
        Assertions.assertThat((Object)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).asNumber()).isEqualTo((Object)0);
        JsonValue arrayJson = this.defaultJsonParser.createJsonValue("[\"hello\", \"world\"]");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, arrayJson)).isEqualTo("OK");
        Assertions.assertThat((int)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).asJsonArray().size()).isEqualTo(2);
        Assertions.assertThat((Long)this.redis.jsonClear((Object)key)).isEqualTo(1L);
        Assertions.assertThat((int)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).asJsonArray().size()).isZero();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, this.defaultJsonParser.createJsonValue("\"infinispan\""))).isEqualTo("OK");
        Assertions.assertThat((String)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).asString()).isEqualTo("infinispan");
        Assertions.assertThat((Long)this.redis.jsonClear((Object)key)).isZero();
        Assertions.assertThat((String)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).asString()).isEqualTo("infinispan");
        JsonValue jv = this.defaultJsonParser.createJsonValue("  {\"a\":\"b\", \"b\": [{\"a\":2}, {\"a\":\"c\"}, {\"a\":5}, {\"a\":true}, {\"a\":{\"h\": 10}}, {\"a\":[\"hello\"]}]}\n");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        Assertions.assertThat((Long)this.redis.jsonClear((Object)key)).isEqualTo(1L);
        List jsonValues = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]);
        Assertions.assertThat((List)jsonValues).hasSize(1);
        Assertions.assertThat((String)((JsonValue)jsonValues.get(0)).asJsonObject().toString()).isEqualTo("{}");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jp, jv)).isEqualTo("OK");
        Assertions.assertThat((Long)this.redis.jsonClear((Object)key, new io.lettuce.core.json.JsonPath("$..noexistpath"))).isZero();
        Assertions.assertThat((Long)this.redis.jsonClear((Object)key, new io.lettuce.core.json.JsonPath("$..a"))).isEqualTo(4L);
        String afterClearJson = "{\"a\":\"b\",\"b\":[{\"a\":0},{\"a\":\"c\"},{\"a\":0},{\"a\":true},{\"a\":{}},{\"a\":[]}]}";
        Assertions.assertThat((String)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).asJsonObject().toString()).isEqualTo(afterClearJson);
        Assertions.assertThat((Long)this.redis.jsonClear((Object)key, new io.lettuce.core.json.JsonPath("$..a"))).isZero();
        Assertions.assertThat((String)((JsonValue)this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[0]).get(0)).asJsonObject().toString()).isEqualTo(afterClearJson);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonClear((Object)"notExistingKey")).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR could not perform this operation on a key that doesn't exist");
    }

    public void testJSONMERGE() {
        CustomStringCommands command = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        io.lettuce.core.json.JsonPath jpRoot = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("         {\n  \"name\": \"Example Object\",\n  \"id\": 123,\n  \"obj1\": {\n    \"type\": \"Nested Object\",\n    \"status\": \"active\",\n    \"nestedObj\": {\n      \"level\": 2,\n      \"description\": \"This is a deeply nested object\"\n    }\n  }\n}\n");
        String update = "{\"obj1\":{\"nestedObj\":{\"added\":\"field\"}}}\n";
        String key = TestingUtil.k();
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpRoot, jv)).isEqualTo("OK");
        Assertions.assertThat((String)command.jsonMerge(key, "$", update)).isEqualTo("OK");
        List result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot});
        Assertions.assertThat((String)result.toString()).isEqualTo("[[{\"name\":\"Example Object\",\"id\":123,\"obj1\":{\"type\":\"Nested Object\",\"status\":\"active\",\"nestedObj\":{\"level\":2,\"description\":\"This is a deeply nested object\",\"added\":\"field\"}}}]]");
        update = "{ \"name\": \"Example Object\", \"id\": 123, \"obj1\": {\"nestedObj\": null}} }\n";
        Assertions.assertThat((String)command.jsonMerge(key, "$", update)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot});
        Assertions.assertThat((String)result.toString()).isEqualTo("[[{\"name\":\"Example Object\",\"id\":123,\"obj1\":{\"type\":\"Nested Object\",\"status\":\"active\"}}]]");
        update = "{ \"name\": \"Example Object\", \"id\": 123, \"obj1\": {\"status\": true}} }\n";
        Assertions.assertThat((String)command.jsonMerge(key, "$", update)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot});
        Assertions.assertThat((String)result.toString()).isEqualTo("[[{\"name\":\"Example Object\",\"id\":123,\"obj1\":{\"type\":\"Nested Object\",\"status\":true}}]]");
        update = "null";
        JsonValue jvUpdate = this.defaultJsonParser.createJsonValue(update);
        Assertions.assertThat((String)this.redis.jsonMerge((Object)key, new io.lettuce.core.json.JsonPath("$.obj1"), jvUpdate)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{new io.lettuce.core.json.JsonPath("$.obj1")});
        Assertions.assertThat((String)result.toString()).isEqualTo("[[null]]");
        update = "{\"added\":\"field\"}\n";
        jvUpdate = this.defaultJsonParser.createJsonValue(update);
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpRoot, jv)).isEqualTo("OK");
        Assertions.assertThat((String)this.redis.jsonMerge((Object)key, new io.lettuce.core.json.JsonPath("$.obj1.nestedObj"), jvUpdate)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot});
        Assertions.assertThat((String)result.toString()).isEqualTo("[[{\"name\":\"Example Object\",\"id\":123,\"obj1\":{\"type\":\"Nested Object\",\"status\":\"active\",\"nestedObj\":{\"level\":2,\"description\":\"This is a deeply nested object\",\"added\":\"field\"}}}]]");
        update = "{\"added\":null}\n";
        jvUpdate = this.defaultJsonParser.createJsonValue(update);
        Assertions.assertThat((String)this.redis.jsonMerge((Object)key, new io.lettuce.core.json.JsonPath("$.obj1.nestedObj"), jvUpdate)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot});
        Assertions.assertThat((String)result.toString()).isEqualTo("[[{\"name\":\"Example Object\",\"id\":123,\"obj1\":{\"type\":\"Nested Object\",\"status\":\"active\",\"nestedObj\":{\"level\":2,\"description\":\"This is a deeply nested object\"}}}]]");
        update = "{\"status\": true }\n";
        jvUpdate = this.defaultJsonParser.createJsonValue(update);
        Assertions.assertThat((String)this.redis.jsonMerge((Object)key, new io.lettuce.core.json.JsonPath("$.obj1"), jvUpdate)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot});
        Assertions.assertThat((String)result.toString()).isEqualTo("[[{\"name\":\"Example Object\",\"id\":123,\"obj1\":{\"type\":\"Nested Object\",\"status\":true,\"nestedObj\":{\"level\":2,\"description\":\"This is a deeply nested object\"}}}]]");
        update = "{\"added\":\"field\"}\n";
        jvUpdate = this.defaultJsonParser.createJsonValue(update);
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpRoot, jv)).isEqualTo("OK");
        Assertions.assertThat((String)this.redis.jsonMerge((Object)key, new io.lettuce.core.json.JsonPath("$.obj1.nonexist"), jvUpdate)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot});
        Assertions.assertThat((String)result.toString()).isEqualTo("[[{\"name\":\"Example Object\",\"id\":123,\"obj1\":{\"type\":\"Nested Object\",\"status\":\"active\",\"nestedObj\":{\"level\":2,\"description\":\"This is a deeply nested object\"},\"nonexist\":{\"added\":\"field\"}}}]]");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpRoot, jv)).isEqualTo("OK");
        Assertions.assertThat((String)this.redis.jsonMerge((Object)key, new io.lettuce.core.json.JsonPath("$.nonexist1.nonexist2"), jvUpdate)).isNull();
        jv = this.defaultJsonParser.createJsonValue("{\"o11\":{\"o21\":{\"o31\":\"field31\", \"sameKey\": null}, \"sameKey\": \"value\", \"o22\": {\"o32\": 42}}, \"sameKey\": {\"o22\":true }}\n");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpRoot, jv)).isEqualTo("OK");
        Assertions.assertThat((String)this.redis.jsonMerge((Object)key, new io.lettuce.core.json.JsonPath("$..sameKey"), jvUpdate)).isEqualTo("OK");
        result = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jpRoot});
        Assertions.assertThat((String)result.toString()).isEqualTo("[[{\"o11\":{\"o21\":{\"o31\":\"field31\",\"sameKey\":{\"added\":\"field\"}},\"sameKey\":{\"added\":\"field\"},\"o22\":{\"o32\":42}},\"sameKey\":{\"o22\":true,\"added\":\"field\"}}]]");
        Assertions.assertThat((String)this.redis.jsonSet((Object)key, jpRoot, jv)).isEqualTo("OK");
        String updateFinal = update;
        JsonValue jvUpdateFinal = jvUpdate;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonMerge((Object)key, new io.lettuce.core.json.JsonPath("$..nonexist1"), jvUpdateFinal)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Err wrong static path");
    }

    @Test
    public void testJSONARRINSERT() {
        CustomStringCommands command = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv = this.defaultJsonParser.createJsonValue("[1, \"a\", {\"o\":\"v\"}]");
        String key = TestingUtil.k();
        this.redis.jsonSet((Object)key, jp, jv);
        Long res = command.jsonArrinsert(key, "$", 2, "\"aString\"", "1", "{\"aObj\": null }");
        Assertions.assertThat((Long)res).isEqualTo(6L);
        List jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[[1,\"a\",\"aString\",1,{\"aObj\":null},{\"o\":\"v\"}]]");
        this.redis.jsonSet((Object)key, jp, jv);
        res = command.jsonArrinsert(key, "$", -1, "1", "2", "3");
        Assertions.assertThat((Long)res).isEqualTo(6L);
        jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[[1,\"a\",1,2,3,{\"o\":\"v\"}]]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> command.jsonArrinsert(key, "$", 99, "1", "2", "3")).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR index out of bounds");
        jv = this.defaultJsonParser.createJsonValue("   {\"a\": 2,\n   \"arr_value\": [\"one\", \"two\", \"three\"],\n   \"nested\":\n      {\"a\": true,\n      \"nested2\": {\n       \"foo\": \"fore\"},\n       \"arr_value\": [1,2,3,4]\n      },\n   \"nested1\":\n      {\n       \"arr_value\": null\n      },\n   \"nested2\":\n      {\n       \"arr_value\": 1,\n       \"string\": \"aString\"\n      }\n   }\n");
        this.redis.jsonSet((Object)key, jp, jv);
        jp = new io.lettuce.core.json.JsonPath("$.nested.arr_value");
        JsonValue v1 = this.defaultJsonParser.fromObject((Object)"aString");
        JsonValue v2 = this.defaultJsonParser.fromObject((Object)1);
        JsonValue v3 = this.defaultJsonParser.createJsonValue("{\"aObj\": null}");
        List jsonArrappend = this.redis.jsonArrinsert((Object)key, jp, 4, new JsonValue[]{v1, v2, v3});
        Assertions.assertThat((List)jsonArrappend).containsExactly((Object[])new Long[]{7L});
        jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[[1,2,3,4,\"aString\",1,{\"aObj\":null}]]");
        jp = new io.lettuce.core.json.JsonPath("$..arr_value");
        Assertions.assertThat((List)this.redis.jsonArrinsert((Object)key, jp, 1, new JsonValue[]{v1, v2, v3})).containsExactly((Object[])new Long[]{6L, 10L, null, null});
        jp = new io.lettuce.core.json.JsonPath("$.nested.*");
        Assertions.assertThat((List)this.redis.jsonArrinsert((Object)key, jp, 1, new JsonValue[]{v1, v2, v3})).containsExactly((Object[])new Long[]{null, null, 13L});
        jp = new io.lettuce.core.json.JsonPath("$.nested2.*");
        Assertions.assertThat((List)this.redis.jsonArrinsert((Object)key, jp, 1, new JsonValue[]{v1, v2, v3})).containsExactly((Object[])new Long[]{null, null});
        jp = new io.lettuce.core.json.JsonPath("$.non-existent");
        Assertions.assertThat((List)this.redis.jsonArrinsert((Object)key, jp, 1, new JsonValue[]{v1, v2, v3})).isEmpty();
        jp = new io.lettuce.core.json.JsonPath("$");
        jv = this.defaultJsonParser.createJsonValue("[1, \"a\", {\"o\":\"v\"}]");
        this.redis.jsonSet((Object)key, jp, jv);
        res = command.jsonArrinsert(key, ".", 2, "\"aString\"", "1", "{\"aObj\": null }");
        Assertions.assertThat((Long)res).isEqualTo(6L);
        jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[[1,\"a\",\"aString\",1,{\"aObj\":null},{\"o\":\"v\"}]]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> command.jsonArrinsert("non-existent", "$", 1, "v1", "v2", "v3")).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR could not perform this operation on a key that doesn't exist");
        jv = this.defaultJsonParser.createJsonValue("   {\"a\": 2,\n   \"arr_value\": [\"one\", \"two\", \"three\"],\n   \"nested\":\n      {\"a\": true,\n      \"nested2\": {\n       \"foo\": \"fore\"},\n       \"arr_value\": [1,2,3,4]\n      },\n   \"nested1\":\n      {\n       \"arr_value\": null\n      },\n   \"nested2\":\n      {\n       \"arr_value\": 1\n      }\n   }\n");
        this.redis.jsonSet((Object)key, jp, jv);
        jp = new io.lettuce.core.json.JsonPath(".nested.arr_value");
        JsonValue v4 = this.defaultJsonParser.fromObject((Object)"aString");
        JsonValue v5 = this.defaultJsonParser.fromObject((Object)1);
        JsonValue v6 = this.defaultJsonParser.createJsonValue("{\"aObj\": null}");
        jsonArrappend = this.redis.jsonArrinsert((Object)key, jp, 4, new JsonValue[]{v4, v5, v6});
        Assertions.assertThat((List)jsonArrappend).containsExactly((Object[])new Long[]{7L});
        jsonGet = this.redis.jsonGet((Object)key, new io.lettuce.core.json.JsonPath[]{jp});
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("[1,2,3,4,\"aString\",1,{\"aObj\":null}]");
        jp = new io.lettuce.core.json.JsonPath("..arr_value");
        Assertions.assertThat((List)this.redis.jsonArrinsert((Object)key, jp, 1, new JsonValue[]{v4, v5, v6})).containsExactly((Object[])new Long[]{10L});
        jp = new io.lettuce.core.json.JsonPath(".nested.*");
        Assertions.assertThat((List)this.redis.jsonArrinsert((Object)key, jp, 1, new JsonValue[]{v4, v5, v6})).containsExactly((Object[])new Long[]{13L});
        io.lettuce.core.json.JsonPath jp1 = new io.lettuce.core.json.JsonPath(".nested2.*");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonArrinsert((Object)key, jp1, 1, new JsonValue[]{v4, v5, v6})).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '$.nested2.*' does not exist or not an array");
        io.lettuce.core.json.JsonPath jp2 = new io.lettuce.core.json.JsonPath(".non-existent");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonArrinsert((Object)key, jp2, 1, new JsonValue[]{v4, v5, v6})).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '$.non-existent' does not exist or not an array");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> command.jsonArrinsert("non-existent", "$", 1, "v1", "v2", "v3")).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR could not perform this operation on a key that doesn't exist");
    }

    @Test
    void testJSONMSET() {
        String key1 = TestingUtil.k((int)1);
        String key2 = TestingUtil.k((int)2);
        String key3 = TestingUtil.k((int)3);
        io.lettuce.core.json.JsonPath jpRoot = new io.lettuce.core.json.JsonPath("$");
        io.lettuce.core.json.JsonPath jpRootLegacy = new io.lettuce.core.json.JsonPath(".");
        JsonValue jv1 = this.defaultJsonParser.createJsonValue("   {\"a\": 2,\n   \"arr_value\": [\"one\", \"two\", \"three\"],\n   \"nested\":\n      {\"a\": true,\n      \"nested2\": {\n       \"foo\": \"fore\"},\n       \"arr_value\": [1,2,3,4]\n      }\n   }\n");
        JsonValue jv2 = this.defaultJsonParser.createJsonValue("\"string\"");
        JsonValue jv3 = this.defaultJsonParser.createJsonValue("3");
        ArrayList<JsonMsetArgs> msetArgs = new ArrayList<JsonMsetArgs>();
        msetArgs.add(new JsonMsetArgs((Object)key1, jpRoot, jv1));
        msetArgs.add(new JsonMsetArgs((Object)key2, jpRoot, jv2));
        msetArgs.add(new JsonMsetArgs((Object)key3, jpRoot, jv3));
        Assertions.assertThat((String)this.redis.jsonMSet(msetArgs)).isEqualTo("OK");
        List jsonGet = this.redis.jsonGet((Object)key1, new io.lettuce.core.json.JsonPath[]{jpRootLegacy});
        Assertions.assertThat((List)jsonGet).hasSize(1);
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo(jv1.toString());
        jsonGet = this.redis.jsonGet((Object)key2, new io.lettuce.core.json.JsonPath[]{jpRootLegacy});
        Assertions.assertThat((List)jsonGet).hasSize(1);
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo(jv2.toString());
        jsonGet = this.redis.jsonGet((Object)key3, new io.lettuce.core.json.JsonPath[]{jpRootLegacy});
        Assertions.assertThat((List)jsonGet).hasSize(1);
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo(jv3.toString());
        JsonValue jv4 = this.defaultJsonParser.createJsonValue("{\"k1\":\"v1\"}");
        io.lettuce.core.json.JsonPath jp = new io.lettuce.core.json.JsonPath("$.added");
        msetArgs = new ArrayList();
        msetArgs.add(new JsonMsetArgs((Object)key1, jp, jv4));
        msetArgs.add(new JsonMsetArgs((Object)key2, jpRoot, jv4));
        msetArgs.add(new JsonMsetArgs((Object)key3, jp, jv4));
        Assertions.assertThat((String)this.redis.jsonMSet(msetArgs)).isEqualTo("OK");
        jsonGet = this.redis.jsonGet((Object)key1, new io.lettuce.core.json.JsonPath[]{jpRootLegacy});
        Assertions.assertThat((List)jsonGet).hasSize(1);
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo("{\"a\":2,\"arr_value\":[\"one\",\"two\",\"three\"],\"nested\":{\"a\":true,\"nested2\":{\"foo\":\"fore\"},\"arr_value\":[1,2,3,4]},\"added\":{\"k1\":\"v1\"}}");
        jsonGet = this.redis.jsonGet((Object)key2, new io.lettuce.core.json.JsonPath[]{jpRootLegacy});
        Assertions.assertThat((List)jsonGet).hasSize(1);
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo(jv4.toString());
        jsonGet = this.redis.jsonGet((Object)key3, new io.lettuce.core.json.JsonPath[]{jpRootLegacy});
        Assertions.assertThat((List)jsonGet).hasSize(1);
        Assertions.assertThat((String)((JsonValue)jsonGet.get(0)).toString()).isEqualTo(jv3.toString());
        ArrayList<JsonMsetArgs> msetArgs1 = new ArrayList<JsonMsetArgs>();
        msetArgs1.add(new JsonMsetArgs((Object)"non-existent", jp, jv4));
        msetArgs1.add(new JsonMsetArgs((Object)key2, jpRoot, jv4));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.jsonMSet(msetArgs1)).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR new objects must be created at root");
    }

    public void testJSONMGET() {
        io.lettuce.core.json.JsonPath jpRoot = new io.lettuce.core.json.JsonPath("$");
        JsonValue jv1 = this.defaultJsonParser.createJsonValue("[1, \"a\", {\"o\":\"v\"}]");
        String key1 = TestingUtil.k();
        String key2 = TestingUtil.k((int)1);
        String key3 = TestingUtil.k((int)2);
        JsonValue jv2 = this.defaultJsonParser.createJsonValue("{\"a\": 2,\n\"arr_value\": [\"one\", \"two\", \"three\"],\n\"nested\":\n   {\"a\": true,\n   \"nested2\": {\n    \"foo\": \"fore\"},\n    \"arr_value\": [1,2,3,4]\n   },\n   \"nested1\":\n      {\n       \"arr_value\": null\n      },\n   \"nested2\":\n      {\n       \"arr_value\": 1,\n       \"string\": \"aString\"\n      }\n   }\n");
        JsonValue jv3 = this.defaultJsonParser.createJsonValue("\"string\"");
        this.redis.jsonSet((Object)key1, jpRoot, jv1);
        this.redis.jsonSet((Object)key2, jpRoot, jv2);
        this.redis.jsonSet((Object)key3, jpRoot, jv3);
        this.redis.set((Object)"not-a-json", (Object)"a-string");
        List jsonValues = this.redis.jsonMGet(jpRoot, (Object[])new String[]{key1, key2, key3});
        Assertions.assertThat((List)jsonValues).map(jv -> jv.asJsonArray().size()).containsExactly((Object[])new Integer[]{1, 1, 1});
        Assertions.assertThat((List)jsonValues).map(jv -> jv.asJsonArray().getFirst().asString()).containsExactly((Object[])new String[]{jv1.asString(), jv2.asString(), jv3.asString()});
    }

    private boolean compareJSONGet(JsonValue result, JsonValue expected, io.lettuce.core.json.JsonPath ... paths) {
        ObjectMapper mapper = new ObjectMapper();
        if (paths.length == 0) {
            paths = new io.lettuce.core.json.JsonPath[]{new io.lettuce.core.json.JsonPath("$")};
        }
        try {
            JsonNode expectedObjectNode = mapper.readTree(expected.toString());
            JsonNode resultNode = mapper.readTree(result.toString());
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)expectedObjectNode);
            boolean isLegacy = true;
            for (io.lettuce.core.json.JsonPath path : paths) {
                isLegacy &= !JSONUtil.isJsonPath((String)path.toString());
            }
            if (paths.length == 1) {
                String pathStr = ".".equals(paths[0].toString()) ? "$" : paths[0].toString();
                JsonNode node = isLegacy ? ((ArrayNode)jpCtx.read(pathStr, new Predicate[0])).get(0) : (JsonNode)jpCtx.read(pathStr, new Predicate[0]);
                return resultNode.equals((Object)node);
            }
            ObjectNode root = mapper.createObjectNode();
            for (io.lettuce.core.json.JsonPath path : paths) {
                String pathStr = path.toString();
                JsonNode node = isLegacy ? ((ArrayNode)jpCtx.read(pathStr, new Predicate[0])).get(0) : (JsonNode)jpCtx.read(pathStr, new Predicate[0]);
                root.set(pathStr, node);
            }
            return resultNode.equals((Object)root);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Test
    void testJSONRESP() {
        JsonValue jv1 = this.defaultJsonParser.createJsonValue("   {\"name\":\"Wireless earbuds\",\"description\":\"Wireless Bluetooth in-ear headphones\",\"connection\":{\"wireless\":true,\"null\":null,\"type\":\"Bluetooth\"},\"price\":64.99,\"stock\":17,\"colors\":[\"black\",\"white\"], \"max_level\":[80, 100, 120]}\n");
        io.lettuce.core.json.JsonPath jpRoot = new io.lettuce.core.json.JsonPath("$");
        String key = TestingUtil.k();
        this.redis.jsonSet((Object)key, jpRoot, jv1, null);
        List<Object> list = this.resp(key, "$");
        String s = list.toString();
        Assertions.assertThat((String)s).isEqualTo("[[{, name, Wireless earbuds, description, Wireless Bluetooth in-ear headphones, connection, [{, wireless, true, null, null, type, Bluetooth], price, 64.99, stock, 17, colors, [[, black, white], max_level, [[, 80, 100, 120]]]");
        list = this.resp(key, "$.price");
        Assertions.assertThat(list).containsExactly(new Object[]{64.99});
        list = this.resp(key, "$.colors");
        Assertions.assertThat((List)((List)list.get(0))).containsExactly(new Object[]{"[", "black", "white"});
        list = this.resp(key, "$.connection.*");
        Assertions.assertThat(list).containsExactly(new Object[]{true, null, "Bluetooth"});
        Assertions.assertThat(this.resp(key, "$.non-existent")).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.resp(key, ".non-existent")).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR Path '$.non-existent' does not exist");
        Assertions.assertThat(this.resp("non-existent", "$")).containsExactly(new Object[]{null});
    }

    private boolean compareJSONGet(List<JsonValue> results, JsonValue expected, io.lettuce.core.json.JsonPath ... paths) {
        Assertions.assertThat(results).hasSize(1);
        return this.compareJSONGet(results.get(0), expected, paths);
    }

    private boolean compareJSONSet(JsonValue newRoot, JsonValue oldRoot, String path, JsonValue node) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode newRootNode = mapper.readTree(newRoot.toString());
            JsonNode oldRootNode = mapper.readTree(oldRoot.toString());
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)oldRootNode);
            JsonNode newNode = mapper.readTree(node.toString());
            JsonPath jPath = JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
            if (jPath.isDefinite()) {
                jPath.set(jpCtx.json(), (Object)newNode, JSONUtil.configForDefiniteSet);
            } else {
                jPath.set(jpCtx.json(), (Object)newNode, JSONUtil.configForSet);
            }
            if (!oldRootNode.equals((Object)newRootNode)) {
                return false;
            }
            DocumentContext newJpCtx = JSONUtil.parserForGet.parse((Object)newRootNode);
            Object newNodeFromNewDoc = newJpCtx.read(path, new Predicate[0]);
            Object expectedNode = jpCtx.read(path, new Predicate[0]);
            return newNodeFromNewDoc.equals(expectedNode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean compareJSONSet(List<JsonValue> newRootList, JsonValue oldRoot, String path, JsonValue node) {
        Assertions.assertThat(newRootList).hasSize(1);
        return this.compareJSONSet(newRootList.get(0), oldRoot, path, node);
    }

    private List<Object> resp(String key, String path) {
        return (List)this.redis.dispatch(new ProtocolKeyword(){

            public byte[] getBytes() {
                return "JSON.RESP".getBytes(StandardCharsets.UTF_8);
            }
        }, new CustomArrayOutput(StringCodec.UTF8), new CommandArgs((RedisCodec)StringCodec.UTF8).addKey((Object)key).addValue((Object)path));
    }

    private /* synthetic */ void lambda$testJSONTOGGLE$0(RedisCodec codec, String key) throws Throwable {
        this.redis.dispatch((ProtocolKeyword)CommandType.JSON_TOGGLE, (CommandOutput)new ValueOutput(codec), new CommandArgs(codec).addKey((Object)key).add("..notExistingPathLegacy"));
    }

    private /* synthetic */ void lambda$testJSONARRLEN$0(RedisCodec codec) throws Throwable {
        this.redis.dispatch((ProtocolKeyword)CommandType.JSON_ARRLEN, (CommandOutput)new IntegerOutput(codec), new CommandArgs(codec).addKey((Object)"notExistingKey").add("$"));
    }

    static enum TestCommandType implements ProtocolKeyword
    {
        JSON_NUMMULTBY("JSON.NUMMULTBY");

        public final byte[] bytes;
        private final String command;

        private TestCommandType(String name) {
            this.command = name;
            this.bytes = name.getBytes(StandardCharsets.US_ASCII);
        }

        public String toString() {
            return this.command;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }

    private static class CustomArrayOutput<K, V>
    extends ArrayOutput<K, V> {
        public CustomArrayOutput(RedisCodec<K, V> codec) {
            super(codec);
        }

        public void set(boolean value) {
            if (this.output == null) {
                this.output = new ArrayList();
            }
            ((List)this.output).add(value);
        }
    }
}

