/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.sync.RedisCommands;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.ScriptingCommandsTest")
public class ScriptingCommandsTest
extends SingleNodeRespBaseTest {
    @Test
    public void testEval() {
        RedisCommands redis = this.redisConnection.sync();
        String out = (String)redis.eval("return redis.call('set', KEYS[1], ARGV[1])\n", ScriptOutputType.STATUS, (Object[])new String[]{TestingUtil.k()}, (Object[])new String[]{TestingUtil.v()});
        AssertJUnit.assertEquals((String)"OK", (String)out);
        Assertions.assertThat((String)((String)redis.get((Object)TestingUtil.k()))).isEqualTo(TestingUtil.v());
    }

    @Test
    public void testEvalRo() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThatThrownBy(() -> redis.evalReadOnly("return redis.call('set', KEYS[1], ARGV[1])\n".getBytes(StandardCharsets.US_ASCII), ScriptOutputType.STATUS, (Object[])new String[]{TestingUtil.k((int)0)}, (Object[])new String[]{TestingUtil.v((int)0)})).hasMessageContaining("ERR Write commands are not allowed from read-only scripts.");
    }

    @Test
    public void testEvalSha() {
        RedisCommands redis = this.redisConnection.sync();
        String sha = redis.scriptLoad("return redis.call('set', KEYS[1], ARGV[1])\n");
        String out = (String)redis.evalsha(sha, ScriptOutputType.STATUS, (Object[])new String[]{TestingUtil.k()}, (Object[])new String[]{TestingUtil.v()});
        AssertJUnit.assertEquals((String)"OK", (String)out);
        Assertions.assertThat((String)((String)redis.get((Object)TestingUtil.k()))).isEqualTo(TestingUtil.v());
    }

    @Test
    public void testEvalShaRo() {
        RedisCommands redis = this.redisConnection.sync();
        String sha = redis.scriptLoad("return redis.call('set', KEYS[1], ARGV[1])\n");
        Assertions.assertThatThrownBy(() -> redis.evalshaReadOnly(sha, ScriptOutputType.STATUS, (Object[])new String[]{TestingUtil.k((int)0)}, (Object[])new String[]{TestingUtil.v((int)0)})).hasMessageContaining("ERR Write commands are not allowed from read-only scripts.");
    }

    @Test
    public void testNotAllowed() {
        RedisCommands redis = this.redisConnection.sync();
        String sha = redis.scriptLoad("return redis.call('auth', KEYS[1], ARGV[1])\n");
        Assertions.assertThatThrownBy(() -> redis.evalshaReadOnly(sha, ScriptOutputType.STATUS, (Object[])new String[]{TestingUtil.k((int)0)}, (Object[])new String[]{TestingUtil.v((int)0)})).hasMessageContaining("ERR This Redis command is not allowed from script");
    }

    @Test
    public void testCallError() {
        RedisCommands redis = this.redisConnection.sync();
        String sha = redis.scriptLoad("return redis.call('sintercard', '0', 'a')\n");
        Assertions.assertThatThrownBy(() -> redis.evalshaReadOnly(sha, ScriptOutputType.STATUS, (Object[])new String[]{TestingUtil.k((int)0)}, (Object[])new String[]{TestingUtil.v((int)0)})).hasMessageContaining("ERR numkeys should be greater than 0");
    }

    @Test
    public void testPCallError() {
        RedisCommands redis = this.redisConnection.sync();
        String sha = redis.scriptLoad("return redis.pcall('sintercard', '0', 'a')\n");
        Assertions.assertThatThrownBy(() -> redis.evalshaReadOnly(sha, ScriptOutputType.STATUS, (Object[])new String[]{TestingUtil.k((int)0)}, (Object[])new String[]{TestingUtil.v((int)0)})).hasMessageContaining("ERR numkeys should be greater than 0");
    }

    @Test
    public void testReturnNumber() {
        RedisCommands redis = this.redisConnection.sync();
        long out = (Long)redis.eval("redis.call('lpush', KEYS[1], ARGV[1])\nredis.call('lpush', KEYS[1], ARGV[2])\nreturn redis.call('llen', KEYS[1])\n", ScriptOutputType.INTEGER, (Object[])new String[]{TestingUtil.k()}, (Object[])new String[]{TestingUtil.v((int)0), TestingUtil.v((int)1)});
        AssertJUnit.assertEquals((long)2L, (long)out);
    }

    @Test
    public void testReturnBoolean() {
        RedisCommands redis = this.redisConnection.sync();
        boolean out = (Boolean)redis.eval("redis.call('sadd', KEYS[1], ARGV[1])\nreturn redis.call('SISMEMBER', KEYS[1], ARGV[1])\n", ScriptOutputType.BOOLEAN, (Object[])new String[]{TestingUtil.k()}, (Object[])new String[]{TestingUtil.v((int)0)});
        AssertJUnit.assertTrue((boolean)out);
    }

    @Test
    public void testReturnList() {
        RedisCommands redis = this.redisConnection.sync();
        List out = (List)redis.eval("redis.call('lpush', KEYS[1], ARGV[1])\nredis.call('lpush', KEYS[1], ARGV[2])\nreturn redis.call('lrange', KEYS[1], 0, 1)\n", ScriptOutputType.MULTI, (Object[])new String[]{TestingUtil.k()}, (Object[])new String[]{TestingUtil.v((int)0), TestingUtil.v((int)1)});
        Assertions.assertThat((List)out).containsExactly((Object[])new String[]{TestingUtil.v((int)1), TestingUtil.v((int)0)});
    }

    @Test
    public void testReturnMap() {
        RedisCommands redis = this.redisConnection.sync();
        Map map = (Map)redis.eval("return redis.call('config', 'get', 'appendonly')\n", ScriptOutputType.OBJECT, (Object[])new String[0], (Object[])new String[0]);
        Assertions.assertThat((Map)map).containsExactlyEntriesOf(Map.of("appendonly", "no"));
    }

    @Test
    public void testReturnSet() {
        RedisCommands redis = this.redisConnection.sync();
        List out = (List)redis.eval("redis.call('sadd', KEYS[1], ARGV[1])\nredis.call('sadd', KEYS[1], ARGV[2])\nreturn redis.call('smembers', KEYS[1])\n", ScriptOutputType.MULTI, (Object[])new String[]{TestingUtil.k()}, (Object[])new String[]{TestingUtil.v((int)0), TestingUtil.v((int)1)});
        Assertions.assertThat((List)out).containsExactly((Object[])new String[]{TestingUtil.v((int)1), TestingUtil.v((int)0)});
    }

    @Test
    public void testReturnZSet() {
        RedisCommands redis = this.redisConnection.sync();
        List out = (List)redis.eval("redis.call('zadd', KEYS[1], 1, ARGV[1])\nredis.call('zadd', KEYS[1], 1, ARGV[2])\nredis.call('zadd', KEYS[1], 2, ARGV[3], 3, ARGV[4])\nreturn redis.call('zrange', KEYS[1], 0, -1, 'withscores')\n", ScriptOutputType.MULTI, (Object[])new String[]{TestingUtil.k()}, (Object[])new String[]{TestingUtil.v((int)0), TestingUtil.v((int)1), TestingUtil.v((int)2), TestingUtil.v((int)3)});
        Assertions.assertThat((List)out).containsExactly((Object[])new List[]{List.of(TestingUtil.v((int)0), Long.valueOf(1L)), List.of(TestingUtil.v((int)1), Long.valueOf(1L)), List.of(TestingUtil.v((int)2), Long.valueOf(2L)), List.of(TestingUtil.v((int)3), Long.valueOf(3L))});
    }

    @Test
    public void testMultiBulkTypeConversion() {
        RedisCommands redis = this.redisConnection.sync();
        redis.del((Object[])new String[]{TestingUtil.k()});
        redis.rpush((Object)TestingUtil.k(), (Object[])new String[]{TestingUtil.v((int)0)});
        redis.rpush((Object)TestingUtil.k(), (Object[])new String[]{TestingUtil.v((int)1)});
        redis.rpush((Object)TestingUtil.k(), (Object[])new String[]{TestingUtil.v((int)2)});
        List out = (List)redis.eval("local foo = redis.pcall('lrange', KEYS[1], 0, -1)\nreturn {type(foo),foo[1],foo[2],foo[3],# foo}\n", ScriptOutputType.MULTI, (Object[])new String[]{TestingUtil.k()});
        Assertions.assertThat((List)out).containsExactly(new Object[]{"table", TestingUtil.v((int)0), TestingUtil.v((int)1), TestingUtil.v((int)2), 3L});
    }

    @Test
    public void testErrorReplyTypeConversion() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v());
        List out = (List)redis.eval("local foo = redis.pcall('incr',KEYS[1])\n            return {type(foo),foo['err']}\n", ScriptOutputType.MULTI, (Object[])new String[]{TestingUtil.k()});
        Assertions.assertThat((List)out).containsExactly(new Object[]{"table", "ERR value is not an integer or out of range"});
    }

    @Test
    public void testScriptDoesNotBlockOnBlpop() {
        RedisCommands redis = this.redisConnection.sync();
        redis.rpush((Object)TestingUtil.k(), (Object[])new String[]{"1"});
        redis.rpop((Object)TestingUtil.k());
        Object out = redis.eval("return redis.pcall('blpop',KEYS[1],0)\n", ScriptOutputType.VALUE, (Object[])new String[]{TestingUtil.k()});
        Assertions.assertThat((Object)out).isNull();
    }

    @Test
    public void testNonDeterministicCommands() {
        RedisCommands redis = this.redisConnection.sync();
        String out = (String)redis.eval("redis.pcall('randomkey'); return redis.pcall('set','x','ciao')\n", ScriptOutputType.STATUS, (Object[])new String[0]);
        AssertJUnit.assertEquals((String)"OK", (String)out);
    }

    @Test
    public void testEnginePRNGCanBeSeededCorrectly() {
        RedisCommands redis = this.redisConnection.sync();
        String rand1 = (String)redis.eval("math.randomseed(ARGV[1]); return tostring(math.random())\n", ScriptOutputType.VALUE, (Object[])new String[0], (Object[])new String[]{Integer.toString(10)});
        String rand2 = (String)redis.eval("math.randomseed(ARGV[1]); return tostring(math.random())\n", ScriptOutputType.VALUE, (Object[])new String[0], (Object[])new String[]{Integer.toString(10)});
        String rand3 = (String)redis.eval("math.randomseed(ARGV[1]); return tostring(math.random())\n", ScriptOutputType.VALUE, (Object[])new String[0], (Object[])new String[]{Integer.toString(20)});
        Assertions.assertThat((String)rand1).isEqualTo(rand2);
        Assertions.assertThat((String)rand2).isNotEqualTo((Object)rand3);
    }

    @Test
    public void testScriptExists() {
        RedisCommands redis = this.redisConnection.sync();
        String sha = redis.scriptLoad("return \"Descartes\"\n");
        List exists = redis.scriptExists(new String[]{sha, "0"});
        Assertions.assertThat((List)exists).containsExactly((Object[])new Boolean[]{true, false});
    }

    @Test
    public void testScriptFlush() {
        RedisCommands redis = this.redisConnection.sync();
        String sha = redis.scriptLoad("return \"testScriptFlush\"\n");
        String out = (String)redis.evalsha(sha, ScriptOutputType.VALUE, (Object[])new String[0]);
        AssertJUnit.assertEquals((String)"testScriptFlush", (String)out);
        redis.scriptFlush();
        Assertions.assertThatThrownBy(() -> redis.evalsha(sha, ScriptOutputType.VALUE, (Object[])new String[0])).hasMessage("ERR NOSCRIPT No matching script. Please use EVAL.");
    }

    @Test
    public void testReturn_G() {
        RedisCommands redis = this.redisConnection.sync();
        List list = (List)redis.eval("return _G\n", ScriptOutputType.OBJECT, (Object[])new String[0]);
        Assertions.assertThat((List)list).isEmpty();
    }

    @Test
    public void testReturnTableWithMetatableThatRaisesError() {
        RedisCommands redis = this.redisConnection.sync();
        List list = (List)redis.eval("local a = {};\nsetmetatable(a,{__index=function() foo() end})\nreturn a\n", ScriptOutputType.OBJECT, (Object[])new String[0]);
        Assertions.assertThat((List)list).isEmpty();
    }

    @Test
    public void testReturnTableWithMetatableThatCallsResp() {
        RedisCommands redis = this.redisConnection.sync();
        List list = (List)redis.eval("local a = {};\nsetmetatable(a,{__index=function() redis.call('set', 'x', '1') end})\nreturn a\n", ScriptOutputType.OBJECT, (Object[])new String[]{"x"});
        Assertions.assertThat((List)list).isEmpty();
        String x = (String)redis.get((Object)"x");
        org.junit.jupiter.api.Assertions.assertNull((Object)x);
    }

    @Test
    public void testReturnLuaInteger() {
        RedisCommands redis = this.redisConnection.sync();
        Long l = (Long)redis.eval("return 100.5\n", ScriptOutputType.INTEGER, (Object[])new String[0]);
        AssertJUnit.assertEquals((int)100, (int)l.intValue());
    }

    @Test
    public void testReturnLuaString() {
        RedisCommands redis = this.redisConnection.sync();
        String s = (String)redis.eval("return 'hello world'\n", ScriptOutputType.VALUE, (Object[])new String[0]);
        AssertJUnit.assertEquals((String)"hello world", (String)s);
    }

    @Test
    public void testReturnLuaBoolean() {
        RedisCommands redis = this.redisConnection.sync();
        Boolean b = (Boolean)redis.eval("return true\n", ScriptOutputType.BOOLEAN, (Object[])new String[0]);
        AssertJUnit.assertTrue((boolean)b);
        b = (Boolean)redis.eval("return false\n", ScriptOutputType.BOOLEAN, (Object[])new String[0]);
        AssertJUnit.assertFalse((boolean)b);
    }

    @Test
    public void testReturnLuaStatusCodeReply() {
        RedisCommands redis = this.redisConnection.sync();
        String s = (String)redis.eval("return {ok='fine'}\n", ScriptOutputType.STATUS, (Object[])new String[0]);
        AssertJUnit.assertEquals((String)"fine", (String)s);
    }

    @Test
    public void testReturnLuaErrorReply() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThatThrownBy(() -> redis.eval("return {err='ERR this is an error'}\n", ScriptOutputType.STATUS, (Object[])new String[0])).hasMessage("ERR this is an error");
    }

    @Test
    public void testReturnLuaTable() {
        RedisCommands redis = this.redisConnection.sync();
        List list = (List)redis.eval("return {1,2,3,'ciao',{1,2}}\n", ScriptOutputType.OBJECT, (Object[])new String[0]);
        Assertions.assertThat((List)list).containsExactly(new Object[]{1L, 2L, 3L, "ciao", List.of(Long.valueOf(1L), Long.valueOf(2L))});
    }

    @Test
    public void testInvalidSHA1() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThatThrownBy(() -> redis.evalsha("NotValidShaSUM", ScriptOutputType.OBJECT, (Object[])new String[0])).hasMessageContaining("NOSCRIPT");
    }

    @Test
    public void testNonDefinedSHA1() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThatThrownBy(() -> redis.evalsha("ffd632c7d33e571e9f24556ebed26c3479a87130", ScriptOutputType.OBJECT, (Object[])new String[0])).hasMessageContaining("NOSCRIPT");
    }
}

