/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.metadata;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.meta.ClientMetadata;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.metadata.InfoClientsTests")
public class InfoClientsTests
extends SingleNodeRespBaseTest {
    public void testConnectedClients() throws Throwable {
        ClientMetadata metadata = this.server.metadataRepository().client();
        RedisCommands c0 = this.redisConnection.sync();
        String info = c0.info("Clients");
        Assertions.assertThat((long)metadata.getConnectedClients()).isEqualTo(1L);
        InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("connected_clients", 1L), new Map.Entry[0]);
        c0.watch((Object[])new String[]{"key1", "key2", "key3"});
        Assertions.assertThat((long)metadata.getWatchingClients()).isEqualTo(1L);
        Assertions.assertThat((long)metadata.getWatchedKeys()).isEqualTo(3L);
        InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("watching_clients", 1L), Map.entry("total_watched_keys", 3L));
        c0.multi();
        c0.set((Object)"key1", (Object)"value");
        c0.exec();
        Assertions.assertThat((long)metadata.getWatchingClients()).isZero();
        Assertions.assertThat((long)metadata.getWatchedKeys()).isZero();
        InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("watching_clients", 0L), Map.entry("total_watched_keys", 0L));
        StatefulRedisConnection<String, String> conn = this.newConnection();
        RedisAsyncCommands c1 = conn.async();
        Assertions.assertThat((long)metadata.getConnectedClients()).isEqualTo(2L);
        InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("connected_clients", 2L), new Map.Entry[0]);
        RedisFuture fut = c1.blpop(0L, (Object[])new String[]{"my-list1", "my-list2", "my-list3"});
        InfoClientsTests.eventually(() -> metadata.getBlockedClients() == 1L);
        Assertions.assertThat((long)metadata.getBlockedKeys()).isEqualTo(3L);
        InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("blocked_clients", 1L), Map.entry("total_blocking_keys", 3L));
        c0.lpush((Object)"my-list1", (Object[])new String[]{"a"});
        fut.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((long)metadata.getBlockedClients()).isZero();
        Assertions.assertThat((long)metadata.getBlockedKeys()).isZero();
        InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("blocked_clients", 0L), Map.entry("total_blocking_keys", 0L));
        try (StatefulRedisPubSubConnection psconn = this.client.connectPubSub();){
            Assertions.assertThat((long)metadata.getConnectedClients()).isEqualTo(3L);
            InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("connected_clients", 3L), new Map.Entry[0]);
            RedisPubSubCommands pubSub = psconn.sync();
            Assertions.assertThat((long)metadata.getPubSubClients()).isZero();
            InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("pubsub_clients", 0L), new Map.Entry[0]);
            pubSub.subscribe((Object[])new String[]{"channel-1", "channel-2", "channel-3"});
            Assertions.assertThat((long)metadata.getPubSubClients()).isEqualTo(3L);
            InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("pubsub_clients", 3L), new Map.Entry[0]);
            pubSub.unsubscribe((Object[])new String[]{"channel-1"});
            Assertions.assertThat((long)metadata.getPubSubClients()).isEqualTo(2L);
            InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("pubsub_clients", 2L), new Map.Entry[0]);
            pubSub.unsubscribe((Object[])new String[0]);
            Assertions.assertThat((long)metadata.getPubSubClients()).isZero();
            InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("pubsub_clients", 0L), new Map.Entry[0]);
        }
        InfoClientsTests.eventually(() -> metadata.getConnectedClients() == 2L);
        InfoClientsTests.assertInfoValue((RedisCommands<String, String>)c0, Map.entry("connected_clients", 2L), new Map.Entry[0]);
    }

    @SafeVarargs
    private static void assertInfoValue(RedisCommands<String, String> r, Map.Entry<String, Long> field, Map.Entry<String, Long> ... fields) {
        String info = r.info("Clients");
        Assertions.assertThat((String)info).contains(new CharSequence[]{field.getKey() + ":" + String.valueOf(field.getValue())});
        for (Map.Entry<String, Long> entry : fields) {
            Assertions.assertThat((String)info).contains(new CharSequence[]{entry.getKey() + ":" + String.valueOf(entry.getValue())});
        }
    }
}

