/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider.sample;

import java.util.Random;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.spring.provider.SpringEmbeddedCacheManager;
import org.infinispan.spring.provider.sample.Book;
import org.infinispan.spring.provider.sample.BookDao;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="spring.provider.CachingBookDaoContextTest", groups={"integration"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
@ContextConfiguration(value={"classpath:/org/infinispan/spring/provider/sample/CachingBookDaoContextTest.xml"})
public class CachingBookDaoContextTest
extends AbstractTestNGSpringContextTests {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    @Autowired(required=true)
    private BookDao bookDao;
    @Autowired(required=true)
    private SpringEmbeddedCacheManager booksCacheManager;

    @BeforeClass
    public void installCacheListener() {
        this.booksCache().addListener((Object)new LoggingListener());
    }

    @AfterMethod
    public void clearBookCache() {
        this.booksCache().clear();
    }

    @Test
    public void demonstrateCachingLoadedBooks() {
        Integer bookToCacheId = 5;
        assert (this.booksCache().isEmpty()) : "Cache should initially not contain any books";
        Book cachedBook = this.bookDao.findBook(bookToCacheId);
        this.log.infof("Book [%s] cached", (Object)cachedBook);
        assert (this.booksCache().values().contains(cachedBook)) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void demonstrateRemovingBookFromCache() {
        Integer bookToDeleteId = new Random().nextInt(10) + 1;
        assert (this.booksCache().isEmpty()) : "Cache should initially not contain any books";
        Book bookToDelete = this.bookDao.findBook(bookToDeleteId);
        this.log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (this.booksCache().values().contains(bookToDelete)) : "findBook(" + bookToDeleteId + ") should have cached book";
        this.log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        this.bookDao.deleteBook(bookToDeleteId);
        this.log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (!this.booksCache().values().contains(bookToDelete)) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void demonstrateCacheEvictionUponUpdate() {
        Integer bookToUpdateId = 2;
        assert (this.booksCache().isEmpty()) : "Cache should initially not contain any books";
        this.log.infof("Caching book [ID = %d]", (Object)bookToUpdateId);
        Book bookToUpdate = this.bookDao.findBook(bookToUpdateId);
        assert (this.booksCache().values().contains(bookToUpdate)) : "findBook(" + bookToUpdateId + ") should have cached book";
        this.log.infof("Updating book [%s] ...", (Object)bookToUpdate);
        bookToUpdate.setTitle("Work in Progress");
        this.bookDao.storeBook(bookToUpdate);
        this.log.infof("Book [%s] updated", (Object)bookToUpdate);
        assert (!this.booksCache().values().contains(bookToUpdate)) : "storeBook(" + bookToUpdate + ") should have removed updated book from cache";
    }

    private Cache<?, ?> booksCache() {
        return (Cache)this.booksCacheManager.getCache("books").getNativeCache();
    }

    @Listener
    public class LoggingListener {
        @CacheEntryCreated
        public void onCacheEntryCreated(CacheEntryCreatedEvent<Object, Object> cacheEntryCreated) {
            if (!cacheEntryCreated.isPre()) {
                CachingBookDaoContextTest.this.log.infof("Object cached: [Key = %s | Event = %s]", cacheEntryCreated.getKey(), cacheEntryCreated);
            }
        }

        @CacheEntryRemoved
        public void onCacheEntryRemoved(CacheEntryRemovedEvent<Object, Object> cacheEntryRemoved) {
            if (cacheEntryRemoved.isPre()) {
                CachingBookDaoContextTest.this.log.infof("Object removed from cache: [Key = %s | Event = %s]", cacheEntryRemoved.getKey(), cacheEntryRemoved);
            }
        }
    }
}

