/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring;

import java.util.List;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class ConfigurationOverrides {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Long eagerDeadlockSpinDuration;
    private Boolean useEagerDeadlockDetection;
    private Boolean useLockStriping;
    private Boolean unsafeUnreliableReturnValues;
    private Long rehashRpcTimeout;
    private Boolean writeSkewCheck;
    private Integer concurrencyLevel;
    private Integer replQueueMaxElements;
    private Long replQueueInterval;
    private String replQueueClass;
    private Boolean exposeJmxStatistics;
    private Boolean invocationBatchingEnabled;
    private Boolean fetchInMemoryState;
    private Boolean alwaysProvideInMemoryState;
    private Long lockAcquisitionTimeout;
    private Long syncReplTimeout;
    private String cacheModeString;
    private Long expirationWakeUpInterval;
    private EvictionStrategy evictionStrategy;
    private String evictionStrategyClass;
    private EvictionThreadPolicy evictionThreadPolicy;
    private String evictionThreadPolicyClass;
    private Integer evictionMaxEntries;
    private Long expirationLifespan;
    private Long expirationMaxIdle;
    private String transactionManagerLookupClass;
    private TransactionManagerLookup transactionManagerLookup;
    private CacheLoaderManagerConfig cacheLoaderManagerConfig;
    private Boolean syncCommitPhase;
    private Boolean syncRollbackPhase;
    private Boolean useEagerLocking;
    private Boolean useReplQueue;
    private IsolationLevel isolationLevel;
    private Long stateRetrievalTimeout;
    private Integer stateRetrievalMaxNonProgressingLogWrites;
    private Integer stateRetrievalChunkSize;
    private Long stateRetrievalInitialRetryWaitTime;
    private String isolationLevelClass;
    private Boolean useLazyDeserialization;
    private Boolean l1CacheEnabled;
    private Long l1Lifespan;
    private Boolean l1OnRehash;
    private String consistentHashClass;
    private Integer numOwners;
    private Boolean rehashEnabled;
    private Long rehashWaitTime;
    private Boolean useAsyncMarshalling;
    private Boolean indexingEnabled;
    private Boolean indexLocalOnly;
    private List<CustomInterceptorConfig> customInterceptors;

    public void setDeadlockDetectionSpinDuration(Long eagerDeadlockSpinDuration) {
        this.eagerDeadlockSpinDuration = eagerDeadlockSpinDuration;
    }

    public void setEnableDeadlockDetection(Boolean useEagerDeadlockDetection) {
        this.useEagerDeadlockDetection = useEagerDeadlockDetection;
    }

    public void setUseLockStriping(Boolean useLockStriping) {
        this.useLockStriping = useLockStriping;
    }

    public void setUnsafeUnreliableReturnValues(Boolean unsafeUnreliableReturnValues) {
        this.unsafeUnreliableReturnValues = unsafeUnreliableReturnValues;
    }

    public void setRehashRpcTimeout(Long rehashRpcTimeout) {
        this.rehashRpcTimeout = rehashRpcTimeout;
    }

    public void setWriteSkewCheck(Boolean writeSkewCheck) {
        this.writeSkewCheck = writeSkewCheck;
    }

    public void setConcurrencyLevel(Integer concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
    }

    public void setReplQueueMaxElements(Integer replQueueMaxElements) {
        this.replQueueMaxElements = replQueueMaxElements;
    }

    public void setReplQueueInterval(Long replQueueInterval) {
        this.replQueueInterval = replQueueInterval;
    }

    public void setReplQueueClass(String replQueueClass) {
        this.replQueueClass = replQueueClass;
    }

    public void setExposeJmxStatistics(Boolean exposeJmxStatistics) {
        this.exposeJmxStatistics = exposeJmxStatistics;
    }

    public void setInvocationBatchingEnabled(Boolean invocationBatchingEnabled) {
        this.invocationBatchingEnabled = invocationBatchingEnabled;
    }

    public void setFetchInMemoryState(Boolean fetchInMemoryState) {
        this.fetchInMemoryState = fetchInMemoryState;
    }

    public void setAlwaysProvideInMemoryState(Boolean alwaysProvideInMemoryState) {
        this.alwaysProvideInMemoryState = alwaysProvideInMemoryState;
    }

    public void setLockAcquisitionTimeout(Long lockAcquisitionTimeout) {
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
    }

    public void setSyncReplTimeout(Long syncReplTimeout) {
        this.syncReplTimeout = syncReplTimeout;
    }

    public void setCacheModeString(String cacheModeString) {
        this.cacheModeString = cacheModeString;
    }

    public void setExpirationWakeUpInterval(Long expirationWakeUpInterval) {
        this.expirationWakeUpInterval = expirationWakeUpInterval;
    }

    public void setEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.evictionStrategy = evictionStrategy;
    }

    public void setEvictionStrategyClass(String evictionStrategyClass) {
        this.evictionStrategyClass = evictionStrategyClass;
    }

    public void setEvictionThreadPolicy(EvictionThreadPolicy evictionThreadPolicy) {
        this.evictionThreadPolicy = evictionThreadPolicy;
    }

    public void setEvictionThreadPolicyClass(String evictionThreadPolicyClass) {
        this.evictionThreadPolicyClass = evictionThreadPolicyClass;
    }

    public void setEvictionMaxEntries(Integer evictionMaxEntries) {
        this.evictionMaxEntries = evictionMaxEntries;
    }

    public void setExpirationLifespan(Long expirationLifespan) {
        this.expirationLifespan = expirationLifespan;
    }

    public void setExpirationMaxIdle(Long expirationMaxIdle) {
        this.expirationMaxIdle = expirationMaxIdle;
    }

    public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
        this.transactionManagerLookupClass = transactionManagerLookupClass;
    }

    public void setTransactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.transactionManagerLookup = transactionManagerLookup;
    }

    public void setCacheLoaderManagerConfig(CacheLoaderManagerConfig cacheLoaderManagerConfig) {
        this.cacheLoaderManagerConfig = cacheLoaderManagerConfig;
    }

    public void setSyncCommitPhase(Boolean syncCommitPhase) {
        this.syncCommitPhase = syncCommitPhase;
    }

    public void setSyncRollbackPhase(Boolean syncRollbackPhase) {
        this.syncRollbackPhase = syncRollbackPhase;
    }

    public void setUseEagerLocking(Boolean useEagerLocking) {
        this.useEagerLocking = useEagerLocking;
    }

    @Deprecated
    public void setEagerLockSingleNode(Boolean eagerLockSingleNode) {
    }

    public void setUseReplQueue(Boolean useReplQueue) {
        this.useReplQueue = useReplQueue;
    }

    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public void setStateRetrievalTimeout(Long stateRetrievalTimeout) {
        this.stateRetrievalTimeout = stateRetrievalTimeout;
    }

    public void setStateRetrievalMaxNonProgressingLogWrites(Integer stateRetrievalMaxNonProgressingLogWrites) {
        this.stateRetrievalMaxNonProgressingLogWrites = stateRetrievalMaxNonProgressingLogWrites;
    }

    public void setStateRetrievalChunkSize(Integer stateRetrievalChunkSize) {
        this.stateRetrievalChunkSize = stateRetrievalChunkSize;
    }

    public void setStateRetrievalInitialRetryWaitTime(Long stateRetrievalInitialRetryWaitTime) {
        this.stateRetrievalInitialRetryWaitTime = stateRetrievalInitialRetryWaitTime;
    }

    public void setIsolationLevelClass(String isolationLevelClass) {
        this.isolationLevelClass = isolationLevelClass;
    }

    public void setUseLazyDeserialization(Boolean useLazyDeserialization) {
        this.useLazyDeserialization = useLazyDeserialization;
    }

    public void setL1CacheEnabled(Boolean l1CacheEnabled) {
        this.l1CacheEnabled = l1CacheEnabled;
    }

    public void setL1Lifespan(Long l1Lifespan) {
        this.l1Lifespan = l1Lifespan;
    }

    public void setL1OnRehash(Boolean l1OnRehash) {
        this.l1OnRehash = l1OnRehash;
    }

    public void setConsistentHashClass(String consistentHashClass) {
        this.consistentHashClass = consistentHashClass;
    }

    public void setNumOwners(Integer numOwners) {
        this.numOwners = numOwners;
    }

    public void setRehashEnabled(Boolean rehashEnabled) {
        this.rehashEnabled = rehashEnabled;
    }

    public void setRehashWaitTime(Long rehashWaitTime) {
        this.rehashWaitTime = rehashWaitTime;
    }

    public void setUseAsyncMarshalling(Boolean useAsyncMarshalling) {
        this.useAsyncMarshalling = useAsyncMarshalling;
    }

    public void setIndexingEnabled(Boolean indexingEnabled) {
        this.indexingEnabled = indexingEnabled;
    }

    public void setIndexLocalOnly(Boolean indexLocalOnly) {
        this.indexLocalOnly = indexLocalOnly;
    }

    public void setCustomInterceptors(List<CustomInterceptorConfig> customInterceptors) {
        this.customInterceptors = customInterceptors;
    }

    public void applyOverridesTo(ConfigurationBuilder configurationToOverride) {
        this.logger.debug((Object)("Applying configuration overrides to Configuration [" + configurationToOverride + "] ..."));
        if (this.eagerDeadlockSpinDuration != null) {
            this.logger.debug((Object)("Overriding property [eagerDeadlockSpinDuration] with value [" + this.eagerDeadlockSpinDuration + "]"));
            configurationToOverride.deadlockDetection().spinDuration(this.eagerDeadlockSpinDuration.longValue());
        }
        if (this.useEagerDeadlockDetection != null) {
            this.logger.debug((Object)("Overriding property [useEagerDeadlockDetection] with value [" + this.useEagerDeadlockDetection + "]"));
            configurationToOverride.deadlockDetection().enabled(this.useEagerDeadlockDetection.booleanValue());
        }
        if (this.useLockStriping != null) {
            this.logger.debug((Object)("Overriding property [useLockStriping] with value [" + this.useLockStriping + "]"));
            configurationToOverride.locking().useLockStriping(this.useLockStriping.booleanValue());
        }
        if (this.unsafeUnreliableReturnValues != null) {
            this.logger.debug((Object)("Overriding property [unsafeUnreliableReturnValues] with value [" + this.unsafeUnreliableReturnValues + "]"));
            configurationToOverride.unsafe().unreliableReturnValues(this.unsafeUnreliableReturnValues.booleanValue());
        }
        if (this.rehashRpcTimeout != null) {
            this.logger.debug((Object)("Overriding property [rehashRpcTimeout] with value [" + this.rehashRpcTimeout + "]"));
            configurationToOverride.clustering().stateTransfer().timeout(this.rehashRpcTimeout.longValue());
        }
        if (this.writeSkewCheck != null) {
            this.logger.debug((Object)("Overriding property [writeSkewCheck] with value [" + this.writeSkewCheck + "]"));
            configurationToOverride.locking().writeSkewCheck(this.writeSkewCheck.booleanValue());
        }
        if (this.concurrencyLevel != null) {
            this.logger.debug((Object)("Overriding property [concurrencyLevel] with value [" + this.concurrencyLevel + "]"));
            configurationToOverride.locking().concurrencyLevel(this.concurrencyLevel.intValue());
        }
        if (this.replQueueMaxElements != null) {
            this.logger.debug((Object)("Overriding property [replQueueMaxElements] with value [" + this.replQueueMaxElements + "]"));
            configurationToOverride.clustering().async().replQueueMaxElements(this.replQueueMaxElements.intValue());
        }
        if (this.replQueueInterval != null) {
            this.logger.debug((Object)("Overriding property [replQueueInterval] with value [" + this.replQueueInterval + "]"));
            configurationToOverride.clustering().async().replQueueInterval(this.replQueueInterval.longValue());
        }
        if (this.replQueueClass != null) {
            this.logger.debug((Object)("Overriding property [replQueueClass] with value [" + this.replQueueClass + "]"));
            configurationToOverride.clustering().async().replQueue((ReplicationQueue)Util.getInstance((String)this.replQueueClass, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        if (this.exposeJmxStatistics != null) {
            this.logger.debug((Object)("Overriding property [exposeJmxStatistics] with value [" + this.exposeJmxStatistics + "]"));
            configurationToOverride.jmxStatistics().enabled(this.exposeJmxStatistics.booleanValue());
        }
        if (this.invocationBatchingEnabled != null) {
            this.logger.debug((Object)("Overriding property [invocationBatchingEnabled] with value [" + this.invocationBatchingEnabled + "]"));
            configurationToOverride.invocationBatching().enable(this.invocationBatchingEnabled.booleanValue());
        }
        if (this.fetchInMemoryState != null) {
            this.logger.debug((Object)("Overriding property [fetchInMemoryState] with value [" + this.fetchInMemoryState + "]"));
            configurationToOverride.clustering().stateTransfer().fetchInMemoryState(this.fetchInMemoryState.booleanValue());
        }
        if (this.alwaysProvideInMemoryState != null) {
            this.logger.debug((Object)("Overriding property [alwaysProvideInMemoryState] with value [" + this.alwaysProvideInMemoryState + "]"));
            configurationToOverride.clustering().stateTransfer().fetchInMemoryState(this.alwaysProvideInMemoryState.booleanValue());
        }
        if (this.lockAcquisitionTimeout != null) {
            this.logger.debug((Object)("Overriding property [lockAcquisitionTimeout] with value [" + this.lockAcquisitionTimeout + "]"));
            configurationToOverride.locking().lockAcquisitionTimeout(this.lockAcquisitionTimeout.longValue());
        }
        if (this.syncReplTimeout != null) {
            this.logger.debug((Object)("Overriding property [syncReplTimeout] with value [" + this.syncReplTimeout + "]"));
            configurationToOverride.clustering().sync().replTimeout(this.syncReplTimeout.longValue());
        }
        if (this.cacheModeString != null) {
            this.logger.debug((Object)("Overriding property [cacheModeString] with value [" + this.cacheModeString + "]"));
            configurationToOverride.clustering().cacheMode(CacheMode.valueOf((String)this.cacheModeString));
        }
        if (this.expirationWakeUpInterval != null) {
            this.logger.debug((Object)("Overriding property [expirationWakeUpInterval] with value [" + this.expirationWakeUpInterval + "]"));
            configurationToOverride.expiration().wakeUpInterval(this.expirationWakeUpInterval.longValue());
        }
        if (this.evictionStrategy != null) {
            this.logger.debug((Object)("Overriding property [evictionStrategy] with value [" + this.evictionStrategy + "]"));
            configurationToOverride.eviction().strategy(this.evictionStrategy);
        }
        if (this.evictionStrategyClass != null) {
            this.logger.debug((Object)("Overriding property [evictionStrategyClass] with value [" + this.evictionStrategyClass + "]"));
        }
        if (this.evictionThreadPolicy != null) {
            this.logger.debug((Object)("Overriding property [evictionThreadPolicy] with value [" + this.evictionThreadPolicy + "]"));
            configurationToOverride.eviction().threadPolicy(this.evictionThreadPolicy);
        }
        if (this.evictionThreadPolicyClass != null) {
            this.logger.debug((Object)("Overriding property [evictionThreadPolicyClass] with value [" + this.evictionThreadPolicyClass + "]"));
        }
        if (this.evictionMaxEntries != null) {
            this.logger.debug((Object)("Overriding property [evictionMaxEntries] with value [" + this.evictionMaxEntries + "]"));
            configurationToOverride.eviction().maxEntries(this.evictionMaxEntries.intValue());
        }
        if (this.expirationLifespan != null) {
            this.logger.debug((Object)("Overriding property [expirationLifespan] with value [" + this.expirationLifespan + "]"));
            configurationToOverride.expiration().lifespan(this.expirationLifespan.longValue());
        }
        if (this.expirationMaxIdle != null) {
            this.logger.debug((Object)("Overriding property [expirationMaxIdle] with value [" + this.expirationMaxIdle + "]"));
            configurationToOverride.expiration().maxIdle(this.expirationMaxIdle.longValue());
        }
        if (this.transactionManagerLookupClass != null) {
            this.logger.debug((Object)("Overriding property [transactionManagerLookupClass] with value [" + this.transactionManagerLookupClass + "]"));
            configurationToOverride.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance((String)this.transactionManagerLookupClass, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        if (this.transactionManagerLookup != null) {
            this.logger.debug((Object)("Overriding property [transactionManagerLookup] with value [" + this.transactionManagerLookup + "]"));
            configurationToOverride.transaction().transactionManagerLookup(this.transactionManagerLookup);
        }
        if (this.cacheLoaderManagerConfig != null) {
            this.logger.debug((Object)("Overriding property [cacheLoaderManagerConfig] with value [" + this.cacheLoaderManagerConfig + "]"));
        }
        if (this.syncCommitPhase != null) {
            this.logger.debug((Object)("Overriding property [syncCommitPhase] with value [" + this.syncCommitPhase + "]"));
            configurationToOverride.transaction().syncCommitPhase(this.syncCommitPhase.booleanValue());
        }
        if (this.syncRollbackPhase != null) {
            this.logger.debug((Object)("Overriding property [syncRollbackPhase] with value [" + this.syncRollbackPhase + "]"));
            configurationToOverride.transaction().syncRollbackPhase(this.syncRollbackPhase.booleanValue());
        }
        if (this.useEagerLocking != null) {
            this.logger.debug((Object)("Overriding property [useEagerLocking] with value [" + this.useEagerLocking + "]"));
            configurationToOverride.transaction().lockingMode(this.useEagerLocking != false ? LockingMode.PESSIMISTIC : LockingMode.OPTIMISTIC);
        }
        if (this.useReplQueue != null) {
            this.logger.debug((Object)("Overriding property [useReplQueue] with value [" + this.useReplQueue + "]"));
            configurationToOverride.clustering().async().useReplQueue(this.useReplQueue.booleanValue());
        }
        if (this.isolationLevel != null) {
            this.logger.debug((Object)("Overriding property [isolationLevel] with value [" + this.isolationLevel + "]"));
            configurationToOverride.locking().isolationLevel(this.isolationLevel);
        }
        if (this.stateRetrievalTimeout != null) {
            this.logger.debug((Object)("Overriding property [stateRetrievalTimeout] with value [" + this.stateRetrievalTimeout + "]"));
            configurationToOverride.clustering().stateTransfer().timeout(this.stateRetrievalTimeout.longValue());
        }
        if (this.stateRetrievalMaxNonProgressingLogWrites != null) {
            this.logger.debug((Object)("Overriding property [stateRetrievalMaxNonProgressingLogWrites] with value [" + this.stateRetrievalMaxNonProgressingLogWrites + "]"));
        }
        if (this.stateRetrievalChunkSize != null) {
            this.logger.debug((Object)("Overriding property [stateRetrievalChunkSize] with value [" + this.stateRetrievalChunkSize + "]"));
            configurationToOverride.clustering().stateTransfer().chunkSize(this.stateRetrievalChunkSize.intValue());
        }
        if (this.stateRetrievalInitialRetryWaitTime != null) {
            this.logger.debug((Object)("Overriding property [stateRetrievalInitialRetryWaitTime] with value [" + this.stateRetrievalInitialRetryWaitTime + "]"));
        }
        if (this.isolationLevelClass != null) {
            this.logger.debug((Object)("Overriding property [isolationLevelClass] with value [" + this.isolationLevelClass + "]"));
        }
        if (this.useLazyDeserialization != null) {
            this.logger.debug((Object)("Overriding property [useLazyDeserialization] with value [" + this.useLazyDeserialization + "]"));
        }
        if (this.l1CacheEnabled != null) {
            this.logger.debug((Object)("Overriding property [l1CacheEnabled] with value [" + this.l1CacheEnabled + "]"));
            configurationToOverride.clustering().l1().enabled(this.l1CacheEnabled.booleanValue());
        }
        if (this.l1Lifespan != null) {
            this.logger.debug((Object)("Overriding property [l1Lifespan] with value [" + this.l1Lifespan + "]"));
            configurationToOverride.clustering().l1().lifespan(this.l1Lifespan.longValue());
        }
        if (this.l1OnRehash != null) {
            this.logger.debug((Object)("Overriding property [l1OnRehash] with value [" + this.l1OnRehash + "]"));
            configurationToOverride.clustering().l1().l1OnRehash(this.l1OnRehash.booleanValue());
        }
        if (this.consistentHashClass != null) {
            this.logger.debug((Object)("Overriding property [consistentHashClass] with value [" + this.consistentHashClass + "]"));
            configurationToOverride.clustering().hash().consistentHash((ConsistentHash)Util.getInstance((String)this.consistentHashClass, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        if (this.numOwners != null) {
            this.logger.debug((Object)("Overriding property [numOwners] with value [" + this.numOwners + "]"));
            configurationToOverride.clustering().hash().numOwners(this.numOwners.intValue());
        }
        if (this.rehashEnabled != null) {
            this.logger.debug((Object)("Overriding property [rehashEnabled] with value [" + this.rehashEnabled + "]"));
            configurationToOverride.clustering().stateTransfer().fetchInMemoryState(this.rehashEnabled.booleanValue());
        }
        if (this.rehashWaitTime != null) {
            this.logger.debug((Object)("Overriding property [rehashWaitTime] with value [" + this.rehashWaitTime + "]"));
        }
        if (this.useAsyncMarshalling != null) {
            this.logger.debug((Object)("Overriding property [useAsyncMarshalling] with value [" + this.useAsyncMarshalling + "]"));
            configurationToOverride.clustering().async().asyncMarshalling(this.useAsyncMarshalling.booleanValue());
        }
        if (this.indexingEnabled != null) {
            this.logger.debug((Object)("Overriding property [indexingEnabled] with value [" + this.indexingEnabled + "]"));
            configurationToOverride.indexing().enabled(this.indexingEnabled.booleanValue());
        }
        if (this.indexLocalOnly != null) {
            this.logger.debug((Object)("Overriding property [indexLocalOnly] with value [" + this.indexLocalOnly + "]"));
            configurationToOverride.indexing().indexLocalOnly(this.indexLocalOnly.booleanValue());
        }
        if (this.customInterceptors != null) {
            this.logger.debug((Object)("Overriding property [customInterceptors] with value [" + this.customInterceptors + "]"));
        }
        this.logger.debug((Object)("Finished applying configuration overrides to Configuration [" + configurationToOverride + "]"));
    }
}

