/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import org.infinispan.spring.provider.SpringEmbeddedCacheManager;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringEmbeddedCacheManagerFactoryBeanContextTest", groups={"unit"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
@ContextConfiguration(value={"classpath:/org/infinispan/spring/provider/SpringEmbeddedCacheManagerFactoryBeanContextTest.xml"})
public class SpringEmbeddedCacheManagerFactoryBeanContextTest
extends AbstractTestNGSpringContextTests {
    private static final String SPRING_EMBEDDED_CACHE_MANAGER_WITH_DEFAULT_CONFIGURATION_BEAN_NAME = "springEmbeddedCacheManagerWithDefaultConfiguration";
    private static final String SPRING_EMBEDDED_CACHE_MANAGER_CONFIGURED_FROM_CONFIGURATION_FILE_BEAN_NAME = "springEmbeddedCacheManagerConfiguredFromConfigurationFile";
    private static final String SPRING_EMBEDDED_CACHE_MANAGER_CONFIGURED_USING_SETTERS_BEAN_NAME = "springEmbeddedCacheManagerConfiguredUsingSetters";

    @Test
    public final void shouldCreateAnEmbeddedCacheManagerWithDefaultSettingsIfNoFurtherConfigurationGiven() {
        SpringEmbeddedCacheManager springEmbeddedCacheManagerWithDefaultConfiguration = (SpringEmbeddedCacheManager)this.applicationContext.getBean(SPRING_EMBEDDED_CACHE_MANAGER_WITH_DEFAULT_CONFIGURATION_BEAN_NAME, SpringEmbeddedCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a SpringEmbeddedCacheManager with default settings having bean name = \"springEmbeddedCacheManagerWithDefaultConfiguration\". However, it doesn't.", (Object)springEmbeddedCacheManagerWithDefaultConfiguration);
        springEmbeddedCacheManagerWithDefaultConfiguration.stop();
    }

    @Test
    public final void shouldCreateAnEmbeddedCacheManagerConfiguredFromConfigurationFileIfConfigurationFileLocationGiven() {
        SpringEmbeddedCacheManager springEmbeddedCacheManagerConfiguredFromConfigurationFile = (SpringEmbeddedCacheManager)this.applicationContext.getBean(SPRING_EMBEDDED_CACHE_MANAGER_CONFIGURED_FROM_CONFIGURATION_FILE_BEAN_NAME, SpringEmbeddedCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a SpringEmbeddedCacheManager configured from configuration file having bean name = \"springEmbeddedCacheManagerConfiguredFromConfigurationFile\". However, it doesn't.", (Object)springEmbeddedCacheManagerConfiguredFromConfigurationFile);
        springEmbeddedCacheManagerConfiguredFromConfigurationFile.stop();
    }

    @Test
    public final void shouldCreateAnEmbeddedCacheManagerConfiguredUsingPropertiesIfPropertiesAreDefined() {
        SpringEmbeddedCacheManager springEmbeddedCacheManagerConfiguredUsingProperties = (SpringEmbeddedCacheManager)this.applicationContext.getBean(SPRING_EMBEDDED_CACHE_MANAGER_CONFIGURED_USING_SETTERS_BEAN_NAME, SpringEmbeddedCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a SpringEmbeddedCacheManager configured using properties having bean name = \"springEmbeddedCacheManagerConfiguredUsingSetters\". However, it doesn't.", (Object)springEmbeddedCacheManagerConfiguredUsingProperties);
        springEmbeddedCacheManagerConfiguredUsingProperties.stop();
    }
}

