/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider.sample;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.infinispan.spring.provider.sample.Book;
import org.infinispan.spring.provider.sample.BookDao;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JdbcBookDao
implements BookDao {
    private final Log log = LogFactory.getLog(this.getClass());
    private SimpleJdbcTemplate jdbcTemplate;
    private SimpleJdbcInsert bookInsert;

    @Autowired(required=true)
    public void initialize(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        this.bookInsert = new SimpleJdbcInsert(dataSource).withTableName("books").usingGeneratedKeyColumns(new String[]{"id"});
    }

    @Override
    @Transactional
    @Cacheable(value={"books"}, key="#bookId")
    public Book findBook(Integer bookId) {
        try {
            this.log.infof("Loading book [ID = %d]", (Object)bookId);
            return (Book)this.jdbcTemplate.queryForObject("SELECT * FROM books WHERE id = ?", (RowMapper)new BookRowMapper(), new Object[]{bookId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"books"}, key="#bookId")
    public void deleteBook(Integer bookId) {
        this.log.infof("Deleting book [ID = %d]", (Object)bookId);
        this.jdbcTemplate.update("DELETE FROM books WHERE id = ?", new Object[]{bookId});
    }

    @Override
    @Transactional
    @CacheEvict(value={"books"}, key="#bookToStore.id", condition="#bookToStore.id != null")
    public Book storeBook(Book bookToStore) {
        this.log.infof("Storing book [%s]", (Object)bookToStore);
        if (bookToStore.getId() == null) {
            Number newBookId = this.bookInsert.executeAndReturnKey(this.createParameterSourceFor(bookToStore));
            bookToStore.setId(newBookId.intValue());
            this.log.infof("Book [%s] persisted for the first time", (Object)bookToStore);
        } else {
            this.jdbcTemplate.update("UPDATE books SET isbn = :isbn, author = :author, title = :title WHERE id = :id", this.createParameterSourceFor(bookToStore));
            this.log.infof("Book [%s] updated", (Object)bookToStore);
        }
        return bookToStore;
    }

    private SqlParameterSource createParameterSourceFor(Book book) {
        return new MapSqlParameterSource().addValue("id", (Object)book.getId()).addValue("isbn", (Object)book.getIsbn()).addValue("author", (Object)book.getAuthor()).addValue("title", (Object)book.getTitle());
    }

    private static final class BookRowMapper
    implements RowMapper<Book> {
        private BookRowMapper() {
        }

        public Book mapRow(ResultSet rs, int rowNum) throws SQLException {
            Book mappedBook = new Book();
            mappedBook.setId(rs.getInt("id"));
            mappedBook.setIsbn(rs.getString("isbn"));
            mappedBook.setAuthor(rs.getString("author"));
            mappedBook.setTitle(rs.getString("title"));
            return mappedBook;
        }
    }
}

