/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.embedded;

import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PlatformMBeanServerLookup;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.VersionAwareMarshaller;
import org.infinispan.spring.mock.MockExecutorFatory;
import org.infinispan.spring.mock.MockScheduleExecutorFactory;
import org.infinispan.spring.mock.MockTransport;
import org.infinispan.spring.support.embedded.InfinispanEmbeddedCacheManagerFactoryBean;
import org.infinispan.spring.support.embedded.TestInfinispanEmbeddedCacheManagerFactoryBean;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.support.embedded.InfinispanEmbeddedCacheManagerFactoryBeanTest", groups={"unit"})
public class InfinispanEmbeddedCacheManagerFactoryBeanTest {
    private static final String CACHE_NAME_FROM_CONFIGURATION_FILE = "asyncCache";
    private static final String NAMED_ASYNC_CACHE_CONFIG_LOCATION = "named-async-cache.xml";

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldCreateACacheManagerEvenIfNoDefaultConfigurationLocationHasBeenSet() throws Exception {
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertNotNull((String)"getObject() should have returned a valid EmbeddedCacheManager, even if no defaulConfigurationLocation has been specified. However, it returned null.", (Object)this.cm);
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldCreateACustomizedCacheManagerIfGivenADefaultConfigurationLocation() throws Exception {
        ClassPathResource infinispanConfig = new ClassPathResource(NAMED_ASYNC_CACHE_CONFIG_LOCATION, this.getClass());
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setConfigurationFileLocation((Resource)infinispanConfig);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertNotNull((String)"getObject() should have returned a valid EmbeddedCacheManager, configured using the configuration file set on SpringEmbeddedCacheManagerFactoryBean. However, it returned null.", (Object)this.cm);
                Cache cacheDefinedInCustomConfiguration = this.cm.getCache(InfinispanEmbeddedCacheManagerFactoryBeanTest.CACHE_NAME_FROM_CONFIGURATION_FILE);
                Configuration configuration = cacheDefinedInCustomConfiguration.getCacheConfiguration();
                AssertJUnit.assertEquals((String)"The cache named [asyncCache] is configured to have asynchonous replication cache mode. Yet, the cache returned from getCache(asyncCache) has a different cache mode. Obviously, SpringEmbeddedCacheManagerFactoryBean did not use the configuration file when instantiating EmbeddedCacheManager.", (Object)CacheMode.REPL_ASYNC, (Object)configuration.clustering().cacheMode());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldReportTheCorrectObjectType() throws Exception {
        final TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"getObjectType() should return the most derived class of the actual EmbeddedCacheManager implementation returned from getObject(). However, it didn't.", this.cm.getClass(), (Object)objectUnderTest.getObjectType());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldDeclareItselfToOnlyProduceSingletons() {
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        AssertJUnit.assertTrue((String)"isSingleton() should always return true. However, it returned false", (boolean)objectUnderTest.isSingleton());
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldStopTheCreateEmbeddedCacheManagerWhenBeingDestroyed() throws Exception {
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        final EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        embeddedCacheManager.getCache();
        objectUnderTest.destroy();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should stop the created EmbeddedCacheManager when being destroyed. However, the created EmbeddedCacheManager is still not terminated.", (Object)ComponentStatus.TERMINATED, (Object)embeddedCacheManager.getStatus());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseExposeGlobalJmxStatisticsPropIfExplicitlySet() throws Exception {
        boolean expectedExposeGlobalJmxStatistics = true;
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setExposeGlobalJmxStatistics(true);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ExposeGlobalJmxStatistics. However, it didn't.", (boolean)true, (boolean)this.cm.getCacheManagerConfiguration().globalJmxStatistics().enabled());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseJmxDomainPropIfExplicitlySet() throws Exception {
        String expectedJmxDomain = "expected.jmx.Domain";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setJmxDomain("expected.jmx.Domain");
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set JmxDomain. However, it didn't.", (String)"expected.jmx.Domain", (String)this.cm.getCacheManagerConfiguration().globalJmxStatistics().domain());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMBeanServerPropertiesPropIfExplicitlySet() throws Exception {
        final Properties expectedMBeanServerProperties = new Properties();
        expectedMBeanServerProperties.setProperty("key", "value");
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMBeanServerProperties(expectedMBeanServerProperties);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MBeanServerProperties. However, it didn't.", (Object)expectedMBeanServerProperties, (Object)this.cm.getCacheManagerConfiguration().globalJmxStatistics().properties());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMBeanServerLookupClassPropIfExplicitlySet() throws Exception {
        PlatformMBeanServerLookup expectedMBeanServerLookup = new PlatformMBeanServerLookup();
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMBeanServerLookupClass(expectedMBeanServerLookup.getClass().getName());
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject(), (MBeanServerLookup)expectedMBeanServerLookup){
            final /* synthetic */ MBeanServerLookup val$expectedMBeanServerLookup;
            {
                this.val$expectedMBeanServerLookup = mBeanServerLookup;
                super(x0);
            }

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MBeanServerLookupClass. However, it didn't.", (String)this.val$expectedMBeanServerLookup.getClass().getName(), (String)this.cm.getCacheManagerConfiguration().globalJmxStatistics().mbeanServerLookup().getClass().getName());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMBeanServerLookupPropIfExplicitlySet() throws Exception {
        PlatformMBeanServerLookup expectedMBeanServerLookup = new PlatformMBeanServerLookup();
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMBeanServerLookup((MBeanServerLookup)expectedMBeanServerLookup);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject(), (MBeanServerLookup)expectedMBeanServerLookup){
            final /* synthetic */ MBeanServerLookup val$expectedMBeanServerLookup;
            {
                this.val$expectedMBeanServerLookup = mBeanServerLookup;
                super(x0);
            }

            public void call() {
                AssertJUnit.assertSame((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MBeanServerLookup. However, it didn't.", (Object)this.val$expectedMBeanServerLookup, (Object)this.cm.getCacheManagerConfiguration().globalJmxStatistics().mbeanServerLookup());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseAllowDuplicateDomainsPropIfExplicitlySet() throws Exception {
        boolean expectedAllowDuplicateDomains = true;
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAllowDuplicateDomains(true);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AllowDuplicateDomains. However, it didn't.", (boolean)true, (boolean)this.cm.getCacheManagerConfiguration().globalJmxStatistics().allowDuplicateDomains());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseCacheManagerNamePropIfExplicitlySet() throws Exception {
        String expectedCacheManagerName = "expected.cache.manager.Name";
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setCacheManagerName("expected.cache.manager.Name");
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set CacheManagerName. However, it didn't.", (String)"expected.cache.manager.Name", (String)this.cm.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseStrictPeerToPeerPropIfExplicitlySet() throws Exception {
        boolean expectedStrictPeerToPeer = true;
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setStrictPeerToPeer(true);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set StrictPeerToPeer. However, it didn't.", (boolean)true, (boolean)this.cm.getCacheManagerConfiguration().transport().strictPeerToPeer());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseAsyncListenerExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        final String expectedAsyncListenerExecutorFactoryClass = MockExecutorFatory.class.getName();
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncListenerExecutorFactoryClass(expectedAsyncListenerExecutorFactoryClass);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncListenerExecutorFactoryClass. However, it didn't.", (String)expectedAsyncListenerExecutorFactoryClass, (String)this.cm.getCacheManagerConfiguration().asyncListenerExecutor().factory().getClass().getName());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseAsyncTransportExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        final String expectedAsyncTransportExecutorFactoryClass = MockExecutorFatory.class.getName();
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncTransportExecutorFactoryClass(expectedAsyncTransportExecutorFactoryClass);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncTransportExecutorFactoryClass. However, it didn't.", (String)expectedAsyncTransportExecutorFactoryClass, (String)this.cm.getCacheManagerConfiguration().asyncTransportExecutor().factory().getClass().getName());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseEvictionScheduledExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        final String expectedEvictionScheduledExecutorFactoryClass = MockScheduleExecutorFactory.class.getName();
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setEvictionScheduledExecutorFactoryClass(expectedEvictionScheduledExecutorFactoryClass);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set EvictionScheduledExecutorFactoryClass. However, it didn't.", (String)expectedEvictionScheduledExecutorFactoryClass, (String)this.cm.getCacheManagerConfiguration().evictionScheduledExecutor().factory().getClass().getName());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseReplicationQueueScheduledExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        final String expectedReplicationQueueScheduledExecutorFactoryClass = MockScheduleExecutorFactory.class.getName();
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setReplicationQueueScheduledExecutorFactoryClass(expectedReplicationQueueScheduledExecutorFactoryClass);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ReplicationQueueScheduledExecutorFactoryClass. However, it didn't.", (String)expectedReplicationQueueScheduledExecutorFactoryClass, (String)this.cm.getCacheManagerConfiguration().replicationQueueScheduledExecutor().factory().getClass().getName());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMarshallerClassPropIfExplicitlySet() throws Exception {
        final String expectedMarshallerClass = VersionAwareMarshaller.class.getName();
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMarshallerClass(expectedMarshallerClass);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MarshallerClass. However, it didn't.", (String)expectedMarshallerClass, (String)this.cm.getCacheManagerConfiguration().serialization().marshaller().getClass().getName());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseTransportNodeNamePropIfExplicitlySet() throws Exception {
        String expectedTransportNodeName = "expected.transport.node.Name";
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setTransportNodeName("expected.transport.node.Name");
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set TransportNodeName. However, it didn't.", (String)"expected.transport.node.Name", (String)this.cm.getCacheManagerConfiguration().transport().nodeName());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseTransportClassPropIfExplicitlySet() throws Exception {
        final String expectedTransportClass = MockTransport.class.getName();
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setTransportClass(expectedTransportClass);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set TransportClass. However, it didn't.", (String)expectedTransportClass, (String)this.cm.getCacheManagerConfiguration().transport().transport().getClass().getName());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseTransportPropertiesPropIfExplicitlySet() throws Exception {
        final Properties expectedTransportProperties = new Properties();
        expectedTransportProperties.setProperty("key", "value");
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setTransportProperties(expectedTransportProperties);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set TransportProperties. However, it didn't.", (Object)expectedTransportProperties, (Object)this.cm.getCacheManagerConfiguration().transport().properties());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseClusterNamePropIfExplicitlySet() throws Exception {
        String expectedClusterName = "expected.cluster.Name";
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setClusterName("expected.cluster.Name");
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ClusterName. However, it didn't.", (String)"expected.cluster.Name", (String)this.cm.getCacheManagerConfiguration().transport().clusterName());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMachineIdPropIfExplicitlySet() throws Exception {
        String expectedMachineId = "expected.machine.Id";
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMachineId("expected.machine.Id");
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MachineId. However, it didn't.", (String)"expected.machine.Id", (String)this.cm.getCacheManagerConfiguration().transport().machineId());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseRackIdPropIfExplicitlySet() throws Exception {
        String expectedRackId = "expected.rack.Id";
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setRackId("expected.rack.Id");
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set RackId. However, it didn't.", (String)"expected.rack.Id", (String)this.cm.getCacheManagerConfiguration().transport().rackId());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseSiteIdPropIfExplicitlySet() throws Exception {
        String expectedSiteId = "expected.site.Id";
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setSiteId("expected.site.Id");
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set SiteId. However, it didn't.", (String)"expected.site.Id", (String)this.cm.getCacheManagerConfiguration().transport().siteId());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseShutdownHookBehaviorPropIfExplicitlySet() throws Exception {
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setShutdownHookBehavior(ShutdownHookBehavior.DONT_REGISTER.name());
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ShutdownHookBehavior. However, it didn't.", (Object)ShutdownHookBehavior.DONT_REGISTER, (Object)this.cm.getCacheManagerConfiguration().shutdown().hookBehavior());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseAsyncListenerExecutorPropertiesPropIfExplicitlySet() throws Exception {
        final Properties expectedAsyncListenerExecutorProperties = new Properties();
        expectedAsyncListenerExecutorProperties.setProperty("key", "value");
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncListenerExecutorProperties(expectedAsyncListenerExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncListenerExecutorProperties. However, it didn't.", (Object)expectedAsyncListenerExecutorProperties, (Object)this.cm.getCacheManagerConfiguration().asyncListenerExecutor().properties());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseAsyncTransportExecutorPropertiesPropIfExplicitlySet() throws Exception {
        final Properties expectedAsyncTransportExecutorProperties = new Properties();
        expectedAsyncTransportExecutorProperties.setProperty("key", "value");
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncTransportExecutorProperties(expectedAsyncTransportExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncTransportExecutorProperties. However, it didn't.", (Object)expectedAsyncTransportExecutorProperties, (Object)this.cm.getCacheManagerConfiguration().asyncTransportExecutor().properties());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseEvictionScheduledExecutorPropertiesPropIfExplicitlySet() throws Exception {
        final Properties expectedEvictionScheduledExecutorProperties = new Properties();
        expectedEvictionScheduledExecutorProperties.setProperty("key", "value");
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setEvictionScheduledExecutorProperties(expectedEvictionScheduledExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set EvictionScheduledExecutorProperties. However, it didn't.", (Object)expectedEvictionScheduledExecutorProperties, (Object)this.cm.getCacheManagerConfiguration().evictionScheduledExecutor().properties());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseReplicationQueueScheduledExecutorPropertiesPropIfExplicitlySet() throws Exception {
        final Properties expectedReplicationQueueScheduledExecutorProperties = new Properties();
        expectedReplicationQueueScheduledExecutorProperties.setProperty("key", "value");
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setReplicationQueueScheduledExecutorProperties(expectedReplicationQueueScheduledExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ReplicationQueueScheduledExecutorProperties. However, it didn't.", (Object)expectedReplicationQueueScheduledExecutorProperties, (Object)this.cm.getCacheManagerConfiguration().replicationQueueScheduledExecutor().properties());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMarshallVersionPropIfExplicitlySet() throws Exception {
        int setMarshallVersion = 1234;
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMarshallVersion((short)1234);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MarshallVersion. However, it didn't.", (short)1234, (short)this.cm.getCacheManagerConfiguration().serialization().version());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseDistributedSyncTimeoutPropIfExplicitlySet() throws Exception {
        long expectedDistributedSyncTimeout = 123456L;
        TestInfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new TestInfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setDistributedSyncTimeout(123456L);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set DistributedSyncTimeout. However, it didn't.", (long)123456L, (long)this.cm.getCacheManagerConfiguration().transport().distributedSyncTimeout());
            }
        });
    }
}

