/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring;

import java.util.Arrays;
import java.util.List;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.spring.ConfigurationOverrides;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.JBossTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="spring.ConfigurationOverridesTest", enabled=false, description="Disabled temporarily, see https://issues.jboss.org/browse/ISPN-2701")
public class ConfigurationOverridesTest {
    public final void configurationOverridesShouldOverrideDeadlockSpinDetectionDurationPropIfExplicitlySet() throws Exception {
        long expectedDeadlockSpinDetectionDuration = 100000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setDeadlockDetectionSpinDuration(Long.valueOf(100000L));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set deadlockDetectionSpinDuration. However, it didn't.", (long)100000L, (long)configuration.deadlockDetection().spinDuration());
    }

    public final void configurationOverridesShouldOverrideEnableDeadlockDetectionPropIfExplicitlySet() throws Exception {
        boolean expectedEnableDeadlockDetection = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEnableDeadlockDetection(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set enableDeadlockDetection property. However, it didn't.", (boolean)true, (boolean)configuration.deadlockDetection().enabled());
    }

    public final void configurationOverridesShouldOverrideUseLockStripingPropIfExplicitlySet() throws Exception {
        boolean expectedUseLockStriping = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUseLockStriping(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set useLockStriping property. However, it didn't.", (boolean)true, (boolean)configuration.locking().useLockStriping());
    }

    public final void configurationOverridesShouldOverrideUnsafeUnreliableReturnValuesPropIfExplicitlySet() throws Exception {
        boolean expectedUnsafeUnreliableReturnValues = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUnsafeUnreliableReturnValues(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set unsafeUnreliableReturnValues property. However, it didn't.", (boolean)true, (boolean)configuration.unsafe().unreliableReturnValues());
    }

    public final void configurationOverridesShouldOverrideRehashRpcTimeoutPropIfExplicitlySet() throws Exception {
        long expectedRehashRpcTimeout = 100000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setRehashRpcTimeout(Long.valueOf(100000L));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set rehashRpcTimeout property. However, it didn't.", (long)100000L, (long)configuration.clustering().stateTransfer().timeout());
    }

    public final void configurationOverridesShouldOverrideWriteSkewCheckPropIfExplicitlySet() throws Exception {
        boolean expectedWriteSkewCheck = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setWriteSkewCheck(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set writeSkewCheck property. However, it didn't.", (boolean)true, (boolean)configuration.locking().writeSkewCheck());
    }

    public final void configurationOverridesShouldOverrideConcurrencyLevelPropIfExplicitlySet() throws Exception {
        int expectedConcurrencyLevel = 10000;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setConcurrencyLevel(Integer.valueOf(10000));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ConcurrencyLevel property. However, it didn't.", (int)10000, (int)configuration.locking().concurrencyLevel());
    }

    public final void configurationOverridesShouldOverrideReplQueueMaxElementsPropIfExplicitlySet() throws Exception {
        int expectedReplQueueMaxElements = 10000;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setReplQueueMaxElements(Integer.valueOf(10000));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ReplQueueMaxElements property. However, it didn't.", (int)10000, (int)configuration.clustering().async().replQueueMaxElements());
    }

    public final void configurationOverridesShouldOverrideReplQueueIntervalPropIfExplicitlySet() throws Exception {
        long expectedReplQueueInterval = 10000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setReplQueueInterval(Long.valueOf(10000L));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ReplQueueInterval property. However, it didn't.", (long)10000L, (long)configuration.clustering().async().replQueueInterval());
    }

    public final void configurationOverridesShouldOverrideReplQueueClassPropIfExplicitlySet() throws Exception {
        String expectedReplQueueClass = "repl.queue.Class";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setReplQueueClass("repl.queue.Class");
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ReplQueueClass property. However, it didn't.", (Object)"repl.queue.Class", configuration.clustering().async().replQueue().getClass());
    }

    public final void configurationOverridesShouldOverrideExposeJmxStatisticsPropIfExplicitlySet() throws Exception {
        boolean expectedExposeJmxStatistics = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setExposeJmxStatistics(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ExposeJmxStatistics property. However, it didn't.", (boolean)true, (boolean)configuration.jmxStatistics().enabled());
    }

    public final void configurationOverridesShouldOverrideInvocationBatchingEnabledPropIfExplicitlySet() throws Exception {
        boolean expectedInvocationBatchingEnabled = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setInvocationBatchingEnabled(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set InvocationBatchingEnabled property. However, it didn't.", (boolean)true, (boolean)configuration.invocationBatching().enabled());
    }

    public final void configurationOverridesShouldOverrideFetchInMemoryStatePropIfExplicitlySet() throws Exception {
        boolean expectedFetchInMemoryState = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setFetchInMemoryState(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set FetchInMemoryState property. However, it didn't.", (boolean)true, (boolean)configuration.clustering().stateTransfer().fetchInMemoryState());
    }

    public final void configurationOverridesShouldOverrideAlwaysProvideInMemoryStatePropIfExplicitlySet() throws Exception {
        boolean expectedAlwaysProvideInMemoryState = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setAlwaysProvideInMemoryState(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set AlwaysProvideInMemoryState property. However, it didn't.", (boolean)true, (boolean)configuration.clustering().stateTransfer().fetchInMemoryState());
    }

    public final void configurationOverridesShouldOverrideLockAcquisitionTimeoutPropIfExplicitlySet() throws Exception {
        long expectedLockAcquisitionTimeout = 1000000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setLockAcquisitionTimeout(Long.valueOf(1000000L));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set LockAcquisitionTimeout property. However, it didn't.", (long)1000000L, (long)configuration.locking().lockAcquisitionTimeout());
    }

    public final void configurationOverridesShouldOverrideSyncReplTimeoutPropIfExplicitlySet() throws Exception {
        long expectedSyncReplTimeout = 100000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setSyncReplTimeout(Long.valueOf(100000L));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set SyncReplTimeout property. However, it didn't.", (long)100000L, (long)configuration.clustering().stateTransfer().timeout());
    }

    public final void configurationOverridesShouldOverrideCacheModeStringPropIfExplicitlySet() throws Exception {
        String expectedCacheModeString = CacheMode.LOCAL.name();
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setCacheModeString(expectedCacheModeString);
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set CacheModeString property. However, it didn't.", (String)expectedCacheModeString, (String)configuration.clustering().cacheModeString());
    }

    public final void configurationOverridesShouldOverrideEvictionWakeUpIntervalPropIfExplicitlySet() throws Exception {
        long expectedExpirationWakeUpInterval = 100000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setExpirationWakeUpInterval(Long.valueOf(100000L));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionWakeUpInterval property. However, it didn't.", (long)100000L, (long)configuration.expiration().wakeUpInterval());
    }

    public final void configurationOverridesShouldOverrideEvictionStrategyPropIfExplicitlySet() throws Exception {
        EvictionStrategy expectedEvictionStrategy = EvictionStrategy.LIRS;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEvictionStrategy(expectedEvictionStrategy);
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionStrategy property. However, it didn't.", (Object)expectedEvictionStrategy, (Object)configuration.eviction().strategy());
    }

    public final void configurationOverridesShouldOverrideEvictionStrategyClassPropIfExplicitlySet() throws Exception {
        String expectedEvictionStrategyClass = "LRU";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEvictionStrategyClass("LRU");
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionStrategyClass property. However, it didn't.", (Object)EvictionStrategy.LRU, (Object)configuration.eviction().strategy());
    }

    public final void configurationOverridesShouldOverrideEvictionThreadPolicyPropIfExplicitlySet() throws Exception {
        EvictionThreadPolicy expectedEvictionThreadPolicy = EvictionThreadPolicy.PIGGYBACK;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEvictionThreadPolicy(expectedEvictionThreadPolicy);
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionThreadPolicy property. However, it didn't.", (Object)expectedEvictionThreadPolicy, (Object)configuration.eviction().threadPolicy());
    }

    public final void configurationOverridesShouldOverrideEvictionThreadPolicyClassPropIfExplicitlySet() throws Exception {
        String expectedEvictionThreadPolicyClass = "PIGGYBACK";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEvictionThreadPolicyClass("PIGGYBACK");
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionThreadPolicyClass property. However, it didn't.", (Object)EvictionThreadPolicy.PIGGYBACK, (Object)configuration.eviction().threadPolicy());
    }

    public final void configurationOverridesShouldOverrideEvictionMaxEntriesPropIfExplicitlySet() throws Exception {
        int expectedEvictionMaxEntries = 1000000;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEvictionMaxEntries(Integer.valueOf(1000000));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionMaxEntries property. However, it didn't.", (int)1000000, (int)configuration.eviction().maxEntries());
    }

    public final void configurationOverridesShouldOverrideExpirationLifespanPropIfExplicitlySet() throws Exception {
        long expectedExpirationLifespan = 1000000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setExpirationLifespan(Long.valueOf(1000000L));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ExpirationLifespan property. However, it didn't.", (long)1000000L, (long)configuration.expiration().lifespan());
    }

    public final void configurationOverridesShouldOverrideExpirationMaxIdlePropIfExplicitlySet() throws Exception {
        long expectedExpirationMaxIdle = 100000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setExpirationMaxIdle(Long.valueOf(100000L));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ExpirationMaxIdle property. However, it didn't.", (long)100000L, (long)configuration.expiration().maxIdle());
    }

    public final void configurationOverridesShouldOverrideTransactionManagerLookupClassPropIfExplicitlySet() throws Exception {
        String expectedTransactionManagerLookupClass = "expected.transaction.manager.lookup.Class";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setTransactionManagerLookupClass("expected.transaction.manager.lookup.Class");
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set TransactionManagerLookupClass property. However, it didn't.", (Object)"expected.transaction.manager.lookup.Class", (Object)configuration.transaction().transactionManagerLookup());
    }

    public final void configurationOverridesShouldOverrideTransactionManagerLookupPropIfExplicitlySet() throws Exception {
        JBossTransactionManagerLookup expectedTransactionManagerLookup = new JBossTransactionManagerLookup();
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setTransactionManagerLookup((TransactionManagerLookup)expectedTransactionManagerLookup);
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set TransactionManagerLookup property. However, it didn't.", (Object)expectedTransactionManagerLookup, (Object)configuration.transaction().transactionManagerLookup());
    }

    public final void configurationOverridesShouldOverrideCacheLoaderManagerConfigPropIfExplicitlySet() throws Exception {
        CacheLoaderManagerConfig expectedCacheLoaderManagerConfig = new CacheLoaderManagerConfig();
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setCacheLoaderManagerConfig(expectedCacheLoaderManagerConfig);
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertSame((String)"ConfigurationOverrides should have overridden default value with explicitly set CacheLoaderManagerConfig property. However, it didn't.", (Object)expectedCacheLoaderManagerConfig, (Object)configuration.loaders().cacheLoaders());
    }

    public final void configurationOverridesShouldOverrideSyncCommitPhasePropIfExplicitlySet() throws Exception {
        boolean expectedSyncCommitPhase = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setSyncCommitPhase(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set SyncCommitPhase property. However, it didn't.", (boolean)true, (boolean)configuration.transaction().syncCommitPhase());
    }

    public final void configurationOverridesShouldOverrideSyncRollbackPhasePropIfExplicitlySet() throws Exception {
        boolean expectedSyncRollbackPhase = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setSyncRollbackPhase(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set SyncRollbackPhase property. However, it didn't.", (boolean)true, (boolean)configuration.transaction().syncRollbackPhase());
    }

    public final void configurationOverridesShouldOverrideUseEagerLockingPropIfExplicitlySet() throws Exception {
        LockingMode expectedLockingMode = LockingMode.PESSIMISTIC;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUseEagerLocking(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set UseEagerLocking property. However, it didn't.", (Object)expectedLockingMode, (Object)configuration.transaction().lockingMode());
    }

    public final void configurationOverridesShouldOverrideUseReplQueuePropIfExplicitlySet() throws Exception {
        boolean expectedUseReplQueue = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUseReplQueue(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set UseReplQueue property. However, it didn't.", (boolean)true, (boolean)configuration.clustering().async().useReplQueue());
    }

    public final void configurationOverridesShouldOverrideIsolationLevelPropIfExplicitlySet() throws Exception {
        IsolationLevel expectedIsolationLevel = IsolationLevel.SERIALIZABLE;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setIsolationLevel(expectedIsolationLevel);
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set IsolationLevel property. However, it didn't.", (Object)expectedIsolationLevel, (Object)configuration.locking().isolationLevel());
    }

    public final void configurationOverridesShouldOverrideStateRetrievalTimeoutPropIfExplicitlySet() throws Exception {
        long expectedStateRetrievalTimeout = 1000000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setStateRetrievalTimeout(Long.valueOf(1000000L));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set StateRetrievalTimeout property. However, it didn't.", (long)1000000L, (long)configuration.clustering().stateTransfer().timeout());
    }

    public final void configurationOverridesShouldOverrideStateRetrievalChunkSizePropIfExplicitlySet() throws Exception {
        int expectedStateRetrievalChunkSize = 123456;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setStateRetrievalChunkSize(Integer.valueOf(123456));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set StateRetrievalChunkSize property. However, it didn't.", (int)123456, (int)configuration.clustering().stateTransfer().chunkSize());
    }

    public final void configurationOverridesShouldOverrideIsolationLevelClassPropIfExplicitlySet() throws Exception {
        String expectedIsolationLevelClass = "REPEATABLE_READ";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setIsolationLevelClass("REPEATABLE_READ");
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set IsolationLevelClass property. However, it didn't.", (Object)IsolationLevel.REPEATABLE_READ, (Object)configuration.locking().isolationLevel());
    }

    public final void configurationOverridesShouldOverrideUseLazyDeserializationPropIfExplicitlySet() throws Exception {
        boolean expectedUseLazyDeserialization = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUseLazyDeserialization(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set UseLazyDeserialization property. However, it didn't.", (boolean)true, (boolean)configuration.storeAsBinary().enabled());
    }

    public final void configurationOverridesShouldOverrideL1CacheEnabledPropIfExplicitlySet() throws Exception {
        boolean expectedL1CacheEnabled = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setL1CacheEnabled(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set L1CacheEnabled property. However, it didn't.", (boolean)true, (boolean)configuration.clustering().l1().enabled());
    }

    public final void configurationOverridesShouldOverrideL1LifespanPropIfExplicitlySet() throws Exception {
        long expectedL1Lifespan = 2300446L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setL1Lifespan(Long.valueOf(2300446L));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set L1Lifespan property. However, it didn't.", (long)2300446L, (long)configuration.clustering().l1().lifespan());
    }

    public final void configurationOverridesShouldOverrideL1OnRehashPropIfExplicitlySet() throws Exception {
        boolean expectedL1OnRehash = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setL1OnRehash(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set L1OnRehash property. However, it didn't.", (boolean)true, (boolean)configuration.clustering().l1().onRehash());
    }

    public final void configurationOverridesShouldOverrideConsistentHashClassPropIfExplicitlySet() throws Exception {
        String expectedConsistentHashClass = "expected.consistent.hash.Class";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setConsistentHashClass("expected.consistent.hash.Class");
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ConsistentHashClass property. However, it didn't.", (String)"expected.consistent.hash.Class", (String)configuration.clustering().hash().consistentHashFactory().getClass().getName());
    }

    public final void configurationOverridesShouldOverrideNumOwnersPropIfExplicitlySet() throws Exception {
        int expectedNumOwners = 675443;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setNumOwners(Integer.valueOf(675443));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set NumOwners property. However, it didn't.", (int)675443, (int)configuration.clustering().hash().numOwners());
    }

    public final void configurationOverridesShouldOverrideRehashEnabledPropIfExplicitlySet() throws Exception {
        boolean expectedRehashEnabled = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setRehashEnabled(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set RehashEnabled property. However, it didn't.", (boolean)true, (boolean)configuration.clustering().stateTransfer().fetchInMemoryState());
    }

    public final void configurationOverridesShouldOverrideRehashWaitTimePropIfExplicitlySet() throws Exception {
        long expectedRehashWaitTime = 1232778L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setRehashWaitTime(Long.valueOf(1232778L));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set RehashWaitTime property. However, it didn't.", (long)1232778L, (long)configuration.clustering().stateTransfer().timeout());
    }

    public final void configurationOverridesShouldOverrideUseAsyncMarshallingPropIfExplicitlySet() throws Exception {
        boolean expectedUseAsyncMarshalling = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUseAsyncMarshalling(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set UseAsyncMarshalling property. However, it didn't.", (boolean)true, (boolean)configuration.clustering().async().asyncMarshalling());
    }

    public final void configurationOverridesShouldOverrideIndexingEnabledPropIfExplicitlySet() throws Exception {
        boolean expectedIndexingEnabled = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setIndexingEnabled(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set IndexingEnabled property. However, it didn't.", (boolean)true, (boolean)configuration.indexing().enabled());
    }

    public final void configurationOverridesShouldOverrideIndexLocalOnlyPropIfExplicitlySet() throws Exception {
        boolean expectedIndexLocalOnly = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setIndexLocalOnly(Boolean.valueOf(true));
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set IndexLocalOnly property. However, it didn't.", (boolean)true, (boolean)configuration.indexing().indexLocalOnly());
    }

    public final void configurationOverridesShouldOverrideCustomInterceptorsPropIfExplicitlySet() throws Exception {
        CustomInterceptorConfig customInterceptor = new CustomInterceptorConfig();
        List<CustomInterceptorConfig> expectedCustomInterceptors = Arrays.asList(customInterceptor);
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setCustomInterceptors(expectedCustomInterceptors);
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        Configuration configuration = defaultConfiguration.build();
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set CustomInterceptors property. However, it didn't.", expectedCustomInterceptors, (Object)configuration.customInterceptors().interceptors());
    }
}

