/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support;

import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class InfinispanDefaultCacheFactoryBean<K, V>
implements FactoryBean<Cache<K, V>>,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheContainer infinispanCacheContainer;
    private Cache<K, V> infinispanCache;

    public void setInfinispanCacheContainer(CacheContainer infinispanCacheContainer) {
        this.infinispanCacheContainer = infinispanCacheContainer;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.infinispanCacheContainer == null) {
            throw new IllegalStateException("No Infinispan CacheContainer has been set");
        }
        this.logger.info((Object)"Initializing named Infinispan cache ...");
        this.infinispanCache = this.infinispanCacheContainer.getCache();
        this.logger.info((Object)("New Infinispan cache [" + this.infinispanCache + "] initialized"));
    }

    public Cache<K, V> getObject() throws Exception {
        return this.infinispanCache;
    }

    public Class<? extends Cache> getObjectType() {
        return this.infinispanCache != null ? this.infinispanCache.getClass() : Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.infinispanCache != null) {
            this.infinispanCache.stop();
        }
    }
}

