/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider.sample;

import java.util.Random;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.spring.provider.sample.entity.Book;
import org.infinispan.spring.provider.sample.service.CachedBookService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.cache.CacheManager;
import org.springframework.test.context.testng.AbstractTransactionalTestNGSpringContextTests;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractTestTemplate
extends AbstractTransactionalTestNGSpringContextTests {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    @AfterMethod
    public void clearBookCache() {
        this.booksCache().clear();
        this.backupCache().clear();
    }

    @Test
    public void demonstrateCachingLoadedBooks() {
        Integer bookToCacheId = 5;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBook(bookToCacheId);
        this.log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.booksCache().get((Object)bookToCacheId))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void demonstrateRemovingBookFromCache() {
        Integer bookToDeleteId = new Random().nextInt(10) + 1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.getBookService().findBook(bookToDeleteId);
        this.log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (this.booksCache().get((Object)bookToDeleteId).equals(bookToDelete)) : "findBook(" + bookToDeleteId + ") should have cached book";
        this.log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        this.getBookService().deleteBook(bookToDeleteId);
        this.log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void demonstrateCacheEvictionUponUpdate() {
        Integer bookToUpdateId = 2;
        assert (!this.booksCache().containsKey((Object)bookToUpdateId)) : "Cache should not initially contain the book with id " + bookToUpdateId;
        this.log.infof("Caching book [ID = %d]", (Object)bookToUpdateId);
        Book bookToUpdate = this.getBookService().findBook(bookToUpdateId);
        assert (this.booksCache().get((Object)bookToUpdateId).equals(bookToUpdate)) : "findBook(" + bookToUpdateId + ") should have cached book";
        this.log.infof("Updating book [%s] ...", (Object)bookToUpdate);
        bookToUpdate.setTitle("Work in Progress");
        this.getBookService().updateBook(bookToUpdate);
        this.log.infof("Book [%s] updated", (Object)bookToUpdate);
        assert (!this.booksCache().containsKey((Object)bookToUpdateId)) : "updateBook(" + bookToUpdate + ") should have removed updated book from cache";
    }

    @Test
    public void demonstrateCachePutOnCreate() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        this.log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBook(bookToCreate);
        this.log.infof("Book [%s] created", (Object)bookToCreate);
        assert (this.booksCache().get((Object)bookToCreate.getIsbn()).equals(bookToCreate)) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testFindConditionMet() {
        Integer bookToCacheId = 5;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookCondition(bookToCacheId);
        this.log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.booksCache().get((Object)bookToCacheId))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void testFindConditionNotMet() {
        Integer bookToCacheId = 1;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookCondition(bookToCacheId);
        this.log.infof("Book [%s] cached", (Object)cachedBook);
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "findBook(" + bookToCacheId + ") should not have cached book";
    }

    @Test
    public void testFindUnlessMet() {
        Integer bookToCacheId = 1;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookUnless(bookToCacheId);
        this.log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.booksCache().get((Object)bookToCacheId))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void testFindUnlessNotMet() {
        Integer bookToCacheId = 5;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookUnless(bookToCacheId);
        this.log.infof("Book [%s] cached", (Object)cachedBook);
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "findBook(" + bookToCacheId + ") should not have cached book";
    }

    @Test
    public void testCreateConditionMet() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        this.log.infof("Creating book [%s] ...", (Object)bookToCreate);
        Book result = this.getBookService().createBookCondition(bookToCreate);
        this.log.infof("Book [%s] created", (Object)bookToCreate);
        assert (bookToCreate.equals(this.booksCache().get((Object)result.getIsbn()))) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testCreateConditionNotMet() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Wrong Path to Infinispan Enlightenment");
        this.log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBookCondition(bookToCreate);
        this.log.infof("Book [%s] created", (Object)bookToCreate);
        assert (bookToCreate.getId() != null) : "Book.id should have been set.";
        assert (!this.booksCache().containsKey((Object)bookToCreate.getIsbn())) : "createBook(" + bookToCreate + ") should not have inserted created book into cache";
    }

    @Test
    public void testCreateUnlessMet() {
        Book bookToCreate = new Book("99-999-999", "Random Author", "Path to Infinispan Enlightenment");
        this.log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBookUnless(bookToCreate);
        this.log.infof("Book [%s] created", (Object)bookToCreate);
        assert (bookToCreate.equals(this.booksCache().get((Object)bookToCreate.getIsbn()))) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testCreateUnlessNotMet() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        this.log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBookUnless(bookToCreate);
        this.log.infof("Book [%s] created", (Object)bookToCreate);
        assert (!this.booksCache().containsKey((Object)bookToCreate.getIsbn())) : "createBook(" + bookToCreate + ") should not have inserted created book into cache";
    }

    @Test
    public void testDeleteConditionMet() {
        Integer bookToDeleteId = 2;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.getBookService().findBook(bookToDeleteId);
        this.log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (bookToDelete.equals(this.booksCache().get((Object)bookToDeleteId))) : "findBook(" + bookToDeleteId + ") should have cached book";
        this.log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        this.getBookService().deleteBookCondition(bookToDeleteId);
        this.log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (!this.booksCache().containsKey((Object)bookToDelete.getId())) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void testDeleteConditionNotMet() {
        Integer bookToDeleteId = 1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.getBookService().findBook(bookToDeleteId);
        this.log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (bookToDelete.equals(this.booksCache().get((Object)bookToDeleteId))) : "findBook(" + bookToDeleteId + ") should have cached book";
        this.log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        this.getBookService().deleteBookCondition(bookToDeleteId);
        this.log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (bookToDelete.equals(this.booksCache().get((Object)bookToDeleteId))) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void testDeleteAllEntries() {
        Integer bookToDeleteId1 = 5;
        Integer bookToDeleteId2 = 6;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId1)) : "Cache should not initially contain the book with id " + bookToDeleteId1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId2)) : "Cache should not initially contain the book with id " + bookToDeleteId2;
        Book bookToDelete1 = this.getBookService().findBook(bookToDeleteId1);
        this.log.infof("Book [%s] cached", (Object)bookToDelete1);
        assert (bookToDelete1.equals(this.booksCache().get((Object)bookToDeleteId1))) : "findBook(" + bookToDeleteId1 + ") should have cached book";
        Book bookToDelete2 = this.getBookService().findBook(bookToDeleteId2);
        this.log.infof("Book [%s] cached", (Object)bookToDelete2);
        assert (bookToDelete2.equals(this.booksCache().get((Object)bookToDeleteId2))) : "findBook(" + bookToDeleteId2 + ") should have cached book";
        this.log.infof("Deleting book [%s] ...", (Object)bookToDelete1);
        this.getBookService().deleteBookAllEntries(bookToDeleteId1);
        this.log.infof("Book [%s] deleted", (Object)bookToDelete1);
        assert (!this.booksCache().containsKey((Object)bookToDelete1.getId())) : "deleteBook(" + bookToDelete1 + ") should have evicted book from cache.";
        assert (!this.booksCache().containsKey((Object)bookToDelete2.getId())) : "deleteBook(" + bookToDelete2 + ") should have evicted book from cache.";
    }

    @Test
    public void testDeleteBookBeforeInvocation() {
        Integer bookToDeleteId = new Random().nextInt(10) + 1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.getBookService().findBook(bookToDeleteId);
        this.log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (bookToDelete.equals(this.booksCache().get((Object)bookToDelete.getId()))) : "findBook(" + bookToDeleteId + ") should have cached book";
        this.log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        try {
            this.getBookService().deleteBookBeforeInvocation(bookToDeleteId);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (!this.booksCache().containsKey((Object)bookToDelete.getId())) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void testCachingCreate() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        this.log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBookCachingBackup(bookToCreate);
        this.log.infof("Book [%s] created", (Object)bookToCreate);
        assert (bookToCreate.equals(this.booksCache().get((Object)bookToCreate.getIsbn()))) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
        assert (bookToCreate.equals(this.backupCache().get((Object)bookToCreate.getIsbn()))) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testCachingFind() {
        Integer bookToCacheId = 5;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        assert (!this.backupCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookCachingBackup(bookToCacheId);
        this.log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.booksCache().get((Object)cachedBook.getId()))) : "findBook(" + bookToCacheId + ") should have cached book";
        assert (cachedBook.equals(this.backupCache().get((Object)cachedBook.getId()))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void testCachingDelete() {
        Integer bookToDeleteId = new Random().nextInt(10) + 1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        assert (!this.backupCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete1 = this.getBookService().findBook(bookToDeleteId);
        this.log.infof("Book [%s] cached", (Object)bookToDelete1);
        Book bookToDelete2 = this.getBookService().findBookBackup(bookToDeleteId);
        this.log.infof("Book [%s] cached", (Object)bookToDelete2);
        assert (bookToDelete1.equals(this.booksCache().get((Object)bookToDeleteId))) : "findBook(" + bookToDeleteId + ") should have cached book";
        assert (bookToDelete1.equals(this.backupCache().get((Object)bookToDeleteId))) : "findBook(" + bookToDeleteId + ") should have cached book";
        this.log.infof("Deleting book [%s] ...", (Object)bookToDelete1);
        this.getBookService().deleteBookCachingBackup(bookToDeleteId);
        this.log.infof("Book [%s] deleted", (Object)bookToDelete1);
        assert (!this.booksCache().containsKey((Object)bookToDelete1.getId())) : "deleteBook(" + bookToDelete1 + ") should have evicted book from cache.";
        assert (!this.backupCache().containsKey((Object)bookToDelete1.getId())) : "deleteBook(" + bookToDelete2 + ") should have evicted book from cache.";
    }

    protected BasicCache<Object, Object> booksCache() {
        return (BasicCache)this.getCacheManager().getCache("books").getNativeCache();
    }

    protected BasicCache<Object, Object> backupCache() {
        return (BasicCache)this.getCacheManager().getCache("backup").getNativeCache();
    }

    protected BasicCache<Object, Object> getCache(String name) {
        return (BasicCache)this.getCacheManager().getCache(name).getNativeCache();
    }

    public abstract CachedBookService getBookService();

    public abstract CacheManager getCacheManager();
}

