/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.provider.SpringEmbeddedCacheManager;
import org.infinispan.spring.provider.SpringRemoteCacheManager;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;

public class ContainerCacheManagerFactoryBean
implements FactoryBean<CacheManager> {
    private CacheContainer cacheContainer;

    public ContainerCacheManagerFactoryBean(CacheContainer cacheContainer) {
        Assert.notNull((Object)cacheContainer, (String)"CacheContainer cannot be null");
        if (!(cacheContainer instanceof EmbeddedCacheManager) && !(cacheContainer instanceof RemoteCacheManager)) {
            throw new IllegalArgumentException("CacheContainer must be either an EmbeddedCacheManager or a RemoteCacheManager ");
        }
        this.cacheContainer = cacheContainer;
    }

    public CacheManager getObject() throws Exception {
        if (this.cacheContainer instanceof EmbeddedCacheManager) {
            return new SpringEmbeddedCacheManager((EmbeddedCacheManager)this.cacheContainer);
        }
        if (this.cacheContainer instanceof RemoteCacheManager) {
            return new SpringRemoteCacheManager((RemoteCacheManager)this.cacheContainer);
        }
        throw new IllegalArgumentException("CacheContainer must be either an EmbeddedCacheManager or a RemoteCacheManager ");
    }

    public Class<?> getObjectType() {
        return CacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

