/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.common.provider;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.NullValue;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class SpringCache
implements Cache {
    public static final SimpleValueWrapper NULL_VALUE_WRAPPER = new SimpleValueWrapper(null);
    private final BasicCache nativeCache;
    private final long readTimeout;
    private final long writeTimeout;
    private final Map<Object, ReentrantLock> synchronousGetLocks = new ConcurrentHashMap<Object, ReentrantLock>();
    private final Map<Object, CompletableFuture> computationResults = new ConcurrentHashMap<Object, CompletableFuture>();
    private static final long BIG_DELAY_NANOS = TimeUnit.DAYS.toNanos(1L);

    public SpringCache(BasicCache nativeCache) {
        this(nativeCache, 0L, 0L);
    }

    public SpringCache(BasicCache nativeCache, long readTimeout, long writeTimeout) {
        Assert.notNull((Object)nativeCache, (String)"A non-null Infinispan cache implementation is required");
        this.nativeCache = nativeCache;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
    }

    public CompletableFuture<?> retrieve(Object key) {
        return this.encodedToValueWrapper(this.nativeCache.getAsync(key));
    }

    private CompletableFuture<Cache.ValueWrapper> encodedToValueWrapper(CompletableFuture<Object> cf) {
        return cf.thenApply(value -> this.encodedToValueWrapper(value));
    }

    public <T> CompletableFuture<T> retrieve(Object key, Supplier<CompletableFuture<T>> valueLoaderAsync) {
        CompletionStage completionStage = SpringCache.handleAndCompose(this.nativeCache.getAsync(key), (v1, ex1) -> {
            if (ex1 != null) {
                return CompletableFuture.failedFuture(ex1);
            }
            if (v1 != null) {
                return CompletableFuture.completedFuture(this.decodeNull(v1));
            }
            CompletableFuture result = new CompletableFuture();
            CompletableFuture computedValue = this.computationResults.putIfAbsent(key, result);
            if (computedValue != null) {
                return computedValue;
            }
            return SpringCache.handleAndCompose((CompletionStage)valueLoaderAsync.get(), (newValue, ex2) -> {
                if (ex2 != null) {
                    result.completeExceptionally((Throwable)ex2);
                    this.computationResults.remove(key);
                } else {
                    this.nativeCache.putIfAbsentAsync(key, this.encodeNull(newValue)).whenComplete((existing, ex3) -> {
                        if (ex3 != null) {
                            result.completeExceptionally((Throwable)ex3);
                        } else if (existing == null) {
                            result.complete(newValue);
                        } else {
                            result.complete(this.decodeNull(existing));
                        }
                        this.computationResults.remove(key);
                    });
                }
                return result;
            });
        });
        return (CompletableFuture)completionStage;
    }

    private static <T, U> CompletionStage<U> handleAndCompose(CompletionStage<T> stage, BiFunction<T, Throwable, CompletionStage<U>> handleFunction) {
        if (SpringCache.isCompletedSuccessfully(stage)) {
            T value = SpringCache.join(stage);
            try {
                return handleFunction.apply(value, null);
            }
            catch (Throwable t) {
                return SpringCache.completedExceptionFuture(t);
            }
        }
        return stage.handle(handleFunction).thenCompose(Function.identity());
    }

    private static <T> CompletableFuture<T> completedExceptionFuture(Throwable ex) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }

    private static boolean isCompletedSuccessfully(CompletionStage<?> stage) {
        CompletableFuture<?> future = stage.toCompletableFuture();
        return future.isDone() && !future.isCompletedExceptionally();
    }

    private static <R> R join(CompletionStage<R> stage) {
        try {
            return SpringCache.await(stage.toCompletableFuture());
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new CompletionException(e);
        }
    }

    private static <T> T await(CompletableFuture<T> future) throws ExecutionException, InterruptedException {
        try {
            return Objects.requireNonNull(future, "Completable Future must be non-null.").get(BIG_DELAY_NANOS, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("This should never happen!", e);
        }
    }

    public String getName() {
        return this.nativeCache.getName();
    }

    public BasicCache<?, ?> getNativeCache() {
        return this.nativeCache;
    }

    public Cache.ValueWrapper get(Object key) {
        try {
            if (this.readTimeout > 0L) {
                return this.encodedToValueWrapper(this.nativeCache.getAsync(key).get(this.readTimeout, TimeUnit.MILLISECONDS));
            }
            return this.encodedToValueWrapper(this.nativeCache.get(key));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public <T> T get(Object key, Class<T> type) {
        try {
            Object value = this.readTimeout > 0L ? this.nativeCache.getAsync(key).get(this.readTimeout, TimeUnit.MILLISECONDS) : this.nativeCache.get(key);
            value = this.decodeNull(value);
            if (value != null && type != null && !type.isInstance(value)) {
                throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + String.valueOf(value));
            }
            return (T)value;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value;
        block7: {
            value = this.nativeCache.get(key);
            if (value == null) {
                ReentrantLock lock = this.synchronousGetLocks.computeIfAbsent(key, k -> new ReentrantLock());
                lock.lock();
                try {
                    value = this.nativeCache.get(key);
                    if (value != null) break block7;
                    try {
                        T newValue = valueLoader.call();
                        value = this.nativeCache.putIfAbsent(key, this.encodeNull(newValue));
                        if (value == null) {
                            value = newValue;
                        }
                    }
                    catch (Exception e) {
                        throw ValueRetrievalExceptionResolver.throwValueRetrievalException(key, valueLoader, e);
                    }
                }
                finally {
                    lock.unlock();
                    this.synchronousGetLocks.remove(key);
                }
            }
        }
        return this.decodeNull(value);
    }

    public void put(Object key, Object value) {
        try {
            if (this.writeTimeout > 0L) {
                this.nativeCache.putAsync(key, this.encodeNull(value)).get(this.writeTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.nativeCache.put(key, this.encodeNull(value));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void put(Object key, Object value, long lifespan, TimeUnit unit) {
        try {
            if (this.writeTimeout > 0L) {
                this.nativeCache.putAsync(key, this.encodeNull(value), lifespan, unit).get(this.writeTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.nativeCache.put(key, this.encodeNull(value), lifespan, unit);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        try {
            if (this.writeTimeout > 0L) {
                return this.encodedToValueWrapper(this.nativeCache.putIfAbsentAsync(key, this.encodeNull(value)).get(this.writeTimeout, TimeUnit.MILLISECONDS));
            }
            return this.encodedToValueWrapper(this.nativeCache.putIfAbsent(key, this.encodeNull(value)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void evict(Object key) {
        try {
            if (this.writeTimeout > 0L) {
                this.nativeCache.removeAsync(key).get(this.writeTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.nativeCache.remove(key);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void clear() {
        try {
            if (this.writeTimeout > 0L) {
                this.nativeCache.clearAsync().get(this.writeTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.nativeCache.clear();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public String toString() {
        return "InfinispanCache [nativeCache = " + String.valueOf(this.nativeCache) + "]";
    }

    private Cache.ValueWrapper encodedToValueWrapper(Object value) {
        if (value == null) {
            return null;
        }
        if (value == NullValue.NULL) {
            return NULL_VALUE_WRAPPER;
        }
        return new SimpleValueWrapper(value);
    }

    private Object encodeNull(Object value) {
        return value != null ? value : NullValue.NULL;
    }

    private <T> T decodeNull(Object value) {
        return (T)(value != NullValue.NULL ? value : null);
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    private static class ValueRetrievalExceptionResolver {
        private ValueRetrievalExceptionResolver() {
        }

        static RuntimeException throwValueRetrievalException(Object key, Callable<?> loader, Throwable ex) {
            return new Cache.ValueRetrievalException(key, loader, ex);
        }
    }
}

