/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.common.session;

import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;

public class PrincipalNameResolver {
    private static final PrincipalNameResolver INSTANCE = new PrincipalNameResolver();
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    private final SpelExpressionParser parser = new SpelExpressionParser();

    public static PrincipalNameResolver getInstance() {
        return INSTANCE;
    }

    public String resolvePrincipal(Session session) {
        String principalName = (String)session.getAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
        if (principalName != null) {
            return principalName;
        }
        Object authentication = session.getAttribute(SPRING_SECURITY_CONTEXT);
        if (authentication != null) {
            Expression expression = this.parser.parseExpression("authentication?.name");
            return (String)expression.getValue(authentication, String.class);
        }
        return null;
    }
}

