/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools;

import java.util.Objects;
import org.w3c.dom.Node;

public class Dependency {
    private final String group;
    private final String artifact;
    private final String version;
    private final Node node;

    Dependency(String group, String artifact, String version, Node node) {
        this.group = group;
        this.artifact = artifact;
        this.version = version;
        this.node = node;
    }

    public String getGroup() {
        return this.group;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getVersion() {
        return this.version;
    }

    public Node getNode() {
        return this.node;
    }

    public String getId() {
        return String.format("%s:%s", this.group, this.artifact);
    }

    public String toString() {
        return "Dependency{group='" + this.group + "', artifact='" + this.artifact + "', version='" + this.version + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return this.group.equals(that.group) && this.artifact.equals(that.artifact) && this.version.equals(that.version) && this.node.equals(that.node);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.artifact, this.version, this.node);
    }
}

