/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.util.Properties;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.SegmentedFileStoreReader;
import org.infinispan.tools.store.migrator.StoreIterator;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.StoreType;
import org.infinispan.tools.store.migrator.file.SingleFileStoreReader;
import org.infinispan.tools.store.migrator.file.SoftIndexFileStoreIterator;
import org.infinispan.tools.store.migrator.jdbc.JdbcStoreReader;
import org.infinispan.tools.store.migrator.rocksdb.RocksDBReader;

class StoreIteratorFactory {
    StoreIteratorFactory() {
    }

    static StoreIterator get(Properties properties) {
        StoreProperties props = new StoreProperties(Element.SOURCE, properties);
        StoreType type = props.storeType();
        switch (type) {
            case JDBC_BINARY: 
            case JDBC_MIXED: 
            case JDBC_STRING: {
                return new JdbcStoreReader(props);
            }
        }
        if (props.isSegmented()) {
            if (StoreType.SINGLE_FILE_STORE == type) {
                return new SegmentedFileStoreReader(props, SingleFileStoreReader::new);
            }
            throw new IllegalArgumentException(String.format("Segmented %s source store not supported", new Object[]{type}));
        }
        switch (type) {
            case LEVELDB: 
            case ROCKSDB: {
                return new RocksDBReader(props);
            }
            case SINGLE_FILE_STORE: {
                return new SingleFileStoreReader(props);
            }
            case SOFT_INDEX_FILE_STORE: {
                return new SoftIndexFileStoreIterator(props);
            }
        }
        return null;
    }
}

