/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.config.v6.rest;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;
import org.infinispan.tools.config.v6.Parser60;
import org.infinispan.tools.config.v6.rest.Attribute;
import org.infinispan.tools.config.v6.rest.Element;

@Namespace(uri="urn:infinispan:config:store:rest:6.0", root="restStore")
public class RestStoreConfigurationParser60
implements ConfigurationParser {
    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REST_STORE: {
                this.parseRestStore(reader, builder.persistence(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseRestStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder loadersBuilder, ClassLoader classLoader) throws XMLStreamException {
        RestStoreConfigurationBuilder builder = new RestStoreConfigurationBuilder(loadersBuilder);
        this.parseRestStoreAttributes(reader, builder, classLoader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_POOL: {
                    this.parseConnectionPool(reader, builder.connectionPool());
                    continue block3;
                }
            }
            Parser60.parseCommonStoreChildren(reader, builder);
        }
        loadersBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseConnectionPool(XMLExtendedStreamReader reader, ConnectionPoolConfigurationBuilder builder) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONNECTION_TIMEOUT: {
                    builder.connectionTimeout(Integer.parseInt(value));
                    continue block8;
                }
                case MAX_CONNECTIONS_PER_HOST: {
                    builder.maxConnectionsPerHost(Integer.parseInt(value));
                    continue block8;
                }
                case MAX_TOTAL_CONNECTIONS: {
                    builder.maxTotalConnections(Integer.parseInt(value));
                    continue block8;
                }
                case BUFFER_SIZE: {
                    builder.bufferSize(Integer.parseInt(value));
                    continue block8;
                }
                case SOCKET_TIMEOUT: {
                    builder.socketTimeout(Integer.parseInt(value));
                    continue block8;
                }
                case TCP_NO_DELAY: {
                    builder.tcpNoDelay(Boolean.parseBoolean(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseRestStoreAttributes(XMLExtendedStreamReader reader, RestStoreConfigurationBuilder builder, ClassLoader classLoader) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            String attributeName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attributeName);
            switch (attribute) {
                case APPEND_CACHE_NAME_TO_PATH: {
                    builder.appendCacheNameToPath(Boolean.parseBoolean(value));
                    continue block7;
                }
                case HOST: {
                    builder.host(value);
                    continue block7;
                }
                case PATH: {
                    builder.path(value);
                    continue block7;
                }
                case PORT: {
                    builder.port(Integer.parseInt(value));
                    continue block7;
                }
                case KEY_TO_STRING_MAPPER: {
                    builder.key2StringMapper(value);
                    continue block7;
                }
                default: {
                    Parser60.parseCommonStoreAttributes(reader, (StoreConfigurationBuilder)builder, attributeName, value, i);
                }
            }
        }
    }
}

