/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.config.v6.remote;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    BALANCING_STRATEGY("balancingStrategy"),
    CONNECT_TIMEOUT("connectTimeout"),
    EXHAUSTED_ACTION("exhaustedAction"),
    FACTORY("factory"),
    FORCE_RETURN_VALUES("forceReturnValues"),
    HOST("host"),
    HOTROD_WRAPPING("hotRodWrapping"),
    MARSHALLER("marshaller"),
    MAX_ACTIVE("maxActive"),
    MAX_IDLE("maxIdle"),
    MAX_TOTAL("maxTotal"),
    MIN_EVICTABLE_IDLE_TIME("minEvictableIdleTime"),
    MIN_IDLE("minIdle"),
    KEY_SIZE_ESTIMATE("keySizeEstimate"),
    PING_ON_STARTUP("pingOnStartup"),
    PORT("port"),
    PROTOCOL_VERSION("protocolVersion"),
    RAW_VALUES("rawValues"),
    REMOTE_CACHE_NAME("remoteCacheName"),
    SOCKET_TIMEOUT("socketTimeout"),
    TCP_NO_DELAY("tcpNoDelay"),
    TEST_WHILE_IDLE("testWhileIdle"),
    TIME_BETWEEN_EVICTION_RUNS("timeBetweenEvictionRuns"),
    TRANSPORT_FACTORY("transportFactory"),
    VALUE_SIZE_ESTIMATE("valueSizeEstimate");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

