/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.licenses;

import gnu.getopt.Getopt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.infinispan.tools.ToolUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LicenseMerger {
    private final DocumentBuilder docBuilder;
    private final Map<String, Document> xmls = new LinkedHashMap<String, Document>();
    private final Document emptyDocument;

    LicenseMerger() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.docBuilder = dbf.newDocumentBuilder();
        this.emptyDocument = this.docBuilder.newDocument();
    }

    private void loadLicenseFromJar(String fileName) throws Exception {
        block12: {
            try (JarFile jar = new JarFile(fileName);){
                JarEntry entry = jar.getJarEntry("META-INF/licenses.xml");
                if (entry != null) {
                    try (InputStream inputStream = jar.getInputStream(entry);){
                        Document doc = this.docBuilder.parse(inputStream);
                        this.xmls.put(ToolUtils.getBaseFileName(fileName), doc);
                        break block12;
                    }
                }
                this.xmls.put(ToolUtils.getBaseFileName(fileName), this.emptyDocument);
            }
        }
    }

    private void loadLicenseFromXML(String fileName) throws Exception {
        Document doc = this.docBuilder.parse(new File(fileName));
        this.xmls.put(ToolUtils.getBaseFileName(fileName), doc);
    }

    void loadLicense(String filename) throws Exception {
        if (filename.endsWith(".jar")) {
            this.loadLicenseFromJar(filename);
        } else if (filename.endsWith(".xml")) {
            this.loadLicenseFromXML(filename);
        } else {
            throw new IllegalArgumentException(filename);
        }
    }

    Node findFirstChildByTagName(Node parent, String tagName) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!tagName.equals(child.getLocalName())) continue;
            return child;
        }
        return null;
    }

    public void write(boolean inclusiveMode, OutputStream os) throws IOException, TransformerException {
        Document aggregated = this.docBuilder.newDocument();
        Element aggregatedDependencies = (Element)aggregated.appendChild(aggregated.createElement("licenseSummary")).appendChild(aggregated.createElement("dependencies"));
        ConcurrentHashMap<String, Node> artifacts = new ConcurrentHashMap<String, Node>();
        for (Map.Entry<String, Document> l : this.xmls.entrySet()) {
            Document doc = l.getValue();
            if (doc == this.emptyDocument) continue;
            Node dependencies = doc.getElementsByTagName("dependencies").item(0);
            for (Node dependency = dependencies.getFirstChild(); dependency != null; dependency = dependency.getNextSibling()) {
                if (!"dependency".equals(dependency.getLocalName())) continue;
                String groupId = this.findFirstChildByTagName(dependency, "groupId").getTextContent().trim();
                String artifactId = this.findFirstChildByTagName(dependency, "artifactId").getTextContent().trim();
                String version = this.findFirstChildByTagName(dependency, "version").getTextContent().trim();
                if (inclusiveMode && !this.xmls.containsKey(String.format("%s-%s", artifactId, version))) continue;
                String artifact = String.format("%s:%s", groupId, artifactId);
                Node dep = dependency;
                artifacts.computeIfAbsent(artifact, a -> aggregated.adoptNode(dep.cloneNode(true)));
            }
        }
        artifacts.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> aggregatedDependencies.appendChild((Node)entry.getValue()));
        ToolUtils.printDocument(aggregated, os);
    }

    public static void main(String[] argv) throws Exception {
        LicenseMerger licenseMerger = new LicenseMerger();
        File outputFile = new File(System.getProperty("user.dir"), "licenses.xml");
        boolean inclusiveMode = false;
        Getopt opts = new Getopt("license-merger", argv, "io:r:");
        int opt = opts.getopt();
        while (opt > -1) {
            switch (opt) {
                case 105: {
                    inclusiveMode = true;
                    break;
                }
                case 111: {
                    outputFile = new File(opts.getOptarg());
                    break;
                }
                case 114: {
                    String[] responseData;
                    for (String filename : responseData = new String(Files.readAllBytes(Paths.get(opts.getOptarg(), new String[0])), StandardCharsets.UTF_8).split("\\s+")) {
                        licenseMerger.loadLicense(filename);
                    }
                    break;
                }
            }
            opt = opts.getopt();
        }
        outputFile.getParentFile().mkdirs();
        for (int i = opts.getOptind(); i < argv.length; ++i) {
            licenseMerger.loadLicense(argv[i]);
        }
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            licenseMerger.write(inclusiveMode, os);
        }
    }
}

