/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreMigrator;
import org.infinispan.tools.store.migrator.TestUtil;
import org.infinispan.tools.store.migrator.marshaller.MarshallerType;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="org.infinispan.tools.store.migrator.AbstractReaderTest", groups={"functional"})
public abstract class AbstractReaderTest
extends AbstractInfinispanTest {
    private static final String TEST_CACHE_NAME = "reader-test";
    protected int segmentCount;

    protected <T extends AbstractReaderTest> T segmented(int segmentCount) {
        this.segmentCount = segmentCount;
        return (T)((Object)this);
    }

    protected String parameters() {
        return "[" + this.segmentCount + "]";
    }

    protected ConfigurationBuilder getTargetCacheConfig() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (this.segmentCount > 0) {
            builder.clustering().hash().numSegments(this.segmentCount);
        }
        return builder;
    }

    protected void configureStoreProperties(Properties properties, Element type) {
        MarshallerType marshallerType = type == Element.SOURCE ? MarshallerType.LEGACY : MarshallerType.CURRENT;
        properties.put(TestUtil.propKey(type, Element.CACHE_NAME), TEST_CACHE_NAME);
        properties.put(TestUtil.propKey(type, Element.MARSHALLER, Element.TYPE), marshallerType.toString());
        properties.put(TestUtil.propKey(type, Element.MARSHALLER, Element.EXTERNALIZERS), "256:" + TestUtil.TestObjectExternalizer.class.getName());
        if (type == Element.TARGET && this.segmentCount > 0) {
            properties.put(TestUtil.propKey(type, Element.SEGMENT_COUNT), String.valueOf(this.segmentCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readerCompatibilityTest() throws Exception {
        Properties properties = new Properties();
        this.configureStoreProperties(properties, Element.SOURCE);
        this.configureStoreProperties(properties, Element.TARGET);
        new StoreMigrator(properties).run();
        GlobalConfiguration globalConfig = new GlobalConfigurationBuilder().serialization().addAdvancedExternalizer(256, (AdvancedExternalizer)new TestUtil.TestObjectExternalizer()).build();
        Configuration config = this.getTargetCacheConfig().build();
        DefaultCacheManager manager = new DefaultCacheManager(globalConfig, config);
        try {
            Cache cache = manager.getCache(TEST_CACHE_NAME);
            for (String key : TestUtil.TEST_MAP.keySet()) {
                Object stored = cache.get((Object)key);
                AssertJUnit.assertNotNull((String)String.format("Key=%s", key), (Object)stored);
                Object expected = TestUtil.TEST_MAP.get(key);
                AssertJUnit.assertNotNull((String)String.format("Key=%s", key), (Object)stored);
                AssertJUnit.assertEquals((Object)expected, (Object)stored);
            }
        }
        finally {
            manager.stop();
        }
    }
}

