/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.tools.store.migrator.TestUtil;
import org.infinispan.tools.store.migrator.marshaller.Infinispan8Marshaller;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="tools.Infinispan8MarshallerTest", groups={"functional"})
public class Infinispan8MarshallerTest {
    private final StreamingMarshaller marshaller;
    private Map<String, byte[]> byteMap;

    public Infinispan8MarshallerTest() {
        HashMap<Integer, TestUtil.TestObjectExternalizer> externalizerMap = new HashMap<Integer, TestUtil.TestObjectExternalizer>();
        externalizerMap.put(256, new TestUtil.TestObjectExternalizer());
        this.marshaller = new Infinispan8Marshaller(externalizerMap);
    }

    @BeforeClass(alwaysRun=true)
    public void beforeTest() throws Exception {
        Path path = new File("src/test/resources/marshalled_bytes_8.x.bin").toPath();
        byte[] bytes = Files.readAllBytes(path);
        this.byteMap = (Map)this.marshaller.objectFromByteBuffer(bytes);
    }

    public void testUnmarshalling() throws Exception {
        for (Map.Entry<String, Object> entry : TestUtil.TEST_MAP.entrySet()) {
            this.unmarshallAndAssertEquality(entry.getKey(), entry.getValue());
        }
    }

    private void unmarshallAndAssertEquality(String key, Object expectedObj) throws Exception {
        byte[] bytes = this.byteMap.get(key);
        assert (bytes != null);
        Object readObj = this.marshaller.objectFromByteBuffer(bytes);
        Assert.assertEquals((Object)readObj, (Object)expectedObj);
    }
}

