/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.test.skip.SkipTestNG;
import org.infinispan.commons.util.Features;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreMigrator;
import org.infinispan.tools.store.migrator.TestUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="org.infinispan.tools.store.migrator.AbstractReaderTest", groups={"functional"})
public abstract class AbstractReaderTest
extends AbstractInfinispanTest {
    private static final String TEST_CACHE_NAME = "reader-test";
    protected int majorVersion = 8;
    protected int segmentCount;

    public <T extends AbstractReaderTest> T majorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
        return (T)((Object)this);
    }

    public <T extends AbstractReaderTest> T segmented(int segmentCount) {
        this.segmentCount = segmentCount;
        return (T)((Object)this);
    }

    protected String parameters() {
        return String.format("[version=%d,segments=%d]", this.majorVersion, this.segmentCount);
    }

    protected ConfigurationBuilder getTargetCacheConfig() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (this.segmentCount > 0) {
            builder.clustering().hash().numSegments(this.segmentCount);
        }
        return builder;
    }

    protected void configureStoreProperties(Properties properties, Element type) {
        int externalizerId = type == Element.TARGET ? 2500 : 256;
        properties.put(TestUtil.propKey(type, Element.CACHE_NAME), TEST_CACHE_NAME);
        properties.put(TestUtil.propKey(type, Element.MARSHALLER, Element.EXTERNALIZERS), externalizerId + ":" + TestUtil.TestObjectExternalizer.class.getName());
        properties.put(TestUtil.propKey(type, Element.VERSION), type == Element.SOURCE ? String.valueOf(this.majorVersion) : Version.getMajor());
        if (type == Element.TARGET && this.segmentCount > 0) {
            properties.put(TestUtil.propKey(type, Element.SEGMENT_COUNT), String.valueOf(this.segmentCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readerCompatibilityTest() throws Exception {
        boolean segmentationAvailable = new Features().isAvailable("data-segmentation");
        SkipTestNG.skipIf((this.segmentCount > 0 && !segmentationAvailable ? 1 : 0) != 0, (String)"Segmentation is disabled");
        Properties properties = new Properties();
        this.configureStoreProperties(properties, Element.SOURCE);
        this.configureStoreProperties(properties, Element.TARGET);
        new StoreMigrator(properties).run();
        GlobalConfigurationBuilder globalConfig = new GlobalConfigurationBuilder();
        globalConfig.serialization().addAdvancedExternalizer(2500, (AdvancedExternalizer)new TestUtil.TestObjectExternalizer());
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalConfig, (ConfigurationBuilder)this.getTargetCacheConfig());
        try {
            Cache cache = manager.getCache(TEST_CACHE_NAME);
            for (String key : TestUtil.TEST_MAP.keySet()) {
                Object stored = cache.get((Object)key);
                AssertJUnit.assertNotNull((String)String.format("Key=%s", key), (Object)stored);
                Object expected = TestUtil.TEST_MAP.get(key);
                AssertJUnit.assertNotNull((String)String.format("Key=%s", key), (Object)stored);
                AssertJUnit.assertEquals((Object)expected, (Object)stored);
            }
            TestUtil.TEST_MAP_UNSUPPORTED.keySet().stream().map(arg_0 -> cache.get(arg_0)).forEach(AssertJUnit::assertNull);
        }
        finally {
            manager.stop();
        }
    }
}

