/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.test.Exceptions;
import org.infinispan.test.data.Person;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.StoreType;
import org.infinispan.tools.store.migrator.TestUtil;
import org.infinispan.tools.store.migrator.jdbc.JdbcConfigurationUtil;
import org.infinispan.tools.store.migrator.marshaller.SerializationConfigUtil;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.Infinispan8Marshaller;
import org.infinispan.tools.store.migrator.marshaller.infinispan9.Infinispan9Marshaller;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="tools.MigratorConfigurationTest", groups={"functional"})
public class MigratorConfigurationTest {
    private static final String DEFAULT_CACHE_NAME = "testCache";
    private static final AtomicInteger externalizerReadCount = new AtomicInteger();
    private static final AtomicInteger externalizerWriteCount = new AtomicInteger();

    @BeforeMethod
    public void init() {
        externalizerReadCount.set(0);
        externalizerWriteCount.set(0);
    }

    public void testCustomMarshallerLoaded() {
        Properties properties = this.createBaseProperties();
        properties.put(TestUtil.propKey(Element.SOURCE, Element.MARSHALLER, Element.CLASS), GenericJBossMarshaller.class.getName());
        StoreProperties props = new StoreProperties(Element.SOURCE, properties);
        Marshaller marshaller = SerializationConfigUtil.getMarshaller((StoreProperties)props);
        Assert.assertNotNull((Object)marshaller);
        Assert.assertTrue((boolean)(marshaller instanceof GenericJBossMarshaller));
    }

    public void testInfinipsan8MarshallerAndExternalizersLoaded() throws Exception {
        String externalizers = String.format("%d:%s", 1, PersonExternalizer.class.getName());
        Properties properties = this.createBaseProperties();
        properties.put(TestUtil.propKey(Element.SOURCE, Element.VERSION), String.valueOf(8));
        properties.put(TestUtil.propKey(Element.SOURCE, Element.MARSHALLER, Element.EXTERNALIZERS), externalizers);
        StoreProperties props = new StoreProperties(Element.SOURCE, properties);
        Marshaller marshaller = SerializationConfigUtil.getMarshaller((StoreProperties)props);
        Assert.assertNotNull((Object)marshaller);
        Assert.assertTrue((boolean)(marshaller instanceof Infinispan8Marshaller));
        byte[] bytes = new byte[]{3, 1, -2, 3, -1, 1, 1};
        Object object = marshaller.objectFromByteBuffer(bytes);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Person));
        Assert.assertEquals((int)1, (int)externalizerReadCount.get());
    }

    public void testInfinispan9MarshallerLoadedAndExternalizersLoaded() throws Exception {
        String externalizers = String.format("%d:%s", 1, PersonExternalizer.class.getName());
        Properties properties = this.createBaseProperties();
        properties.put(TestUtil.propKey(Element.SOURCE, Element.VERSION), String.valueOf(9));
        properties.put(TestUtil.propKey(Element.SOURCE, Element.MARSHALLER, Element.EXTERNALIZERS), externalizers);
        StoreProperties props = new StoreProperties(Element.SOURCE, properties);
        Marshaller marshaller = SerializationConfigUtil.getMarshaller((StoreProperties)props);
        Assert.assertNotNull((Object)marshaller);
        Assert.assertTrue((boolean)(marshaller instanceof Infinispan9Marshaller));
        byte[] bytes = new byte[]{3, 0, 0, 0, 1, 1};
        Object object = marshaller.objectFromByteBuffer(bytes);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Person));
        Assert.assertEquals((int)1, (int)externalizerReadCount.get());
    }

    public void testCurrentMarshallerLoadedAndExternalizersLoaded() throws Exception {
        String externalizers = String.format("%d:%s", 2500, PersonExternalizer.class.getName());
        Properties properties = this.createBaseProperties();
        properties.put(TestUtil.propKey(Element.SOURCE, Element.MARSHALLER, Element.EXTERNALIZERS), externalizers);
        StoreProperties props = new StoreProperties(Element.SOURCE, properties);
        Marshaller marshaller = SerializationConfigUtil.getMarshaller((StoreProperties)props);
        Assert.assertNotNull((Object)marshaller);
        Assert.assertTrue((boolean)(marshaller instanceof PersistenceMarshaller));
        byte[] bytes = marshaller.objectToByteBuffer((Object)new Person(Person.class.getName()));
        Person person = (Person)marshaller.objectFromByteBuffer(bytes);
        Assert.assertNotNull((Object)person);
        Assert.assertEquals((String)Person.class.getName(), (String)person.getName());
        Assert.assertEquals((int)1, (int)externalizerReadCount.get());
        Assert.assertEquals((int)1, (int)externalizerWriteCount.get());
    }

    public void testExceptionOnMarshallerType() {
        Properties properties = this.createBaseProperties();
        properties.put(TestUtil.propKey(Element.SOURCE, Element.MARSHALLER, Element.TYPE), "CURRENT");
        Exceptions.expectException(CacheConfigurationException.class, () -> new StoreProperties(Element.SOURCE, properties));
    }

    public void testCorrectMarshallerLoadedForVersion() {
        Assert.assertTrue((boolean)(this.getMarshallerForVersion(8, Element.SOURCE) instanceof Infinispan8Marshaller));
        Assert.assertTrue((boolean)(this.getMarshallerForVersion(9, Element.SOURCE) instanceof Infinispan9Marshaller));
        Assert.assertTrue((boolean)(this.getMarshallerForVersion(10, Element.SOURCE) instanceof PersistenceMarshaller));
        Exceptions.expectException(CacheConfigurationException.class, () -> this.getMarshallerForVersion(8, Element.TARGET));
        Exceptions.expectException(CacheConfigurationException.class, () -> this.getMarshallerForVersion(9, Element.TARGET));
        Assert.assertNull((Object)this.getMarshallerForVersion(10, Element.TARGET));
    }

    private Marshaller getMarshallerForVersion(int version, Element storeType) {
        Properties properties = this.createBaseProperties(storeType);
        properties.put(TestUtil.propKey(storeType, Element.VERSION), String.valueOf(version));
        StoreProperties props = new StoreProperties(storeType, properties);
        return SerializationConfigUtil.getMarshaller((StoreProperties)props);
    }

    public void testDbPropertiesLoaded() {
        Element[] storeTypes;
        Properties properties = this.createBaseProperties();
        properties.putAll((Map<?, ?>)this.createBaseProperties(Element.TARGET));
        for (Element storeType : storeTypes = new Element[]{Element.SOURCE, Element.TARGET}) {
            properties.put(TestUtil.propKey(storeType, Element.DB, Element.MAJOR_VERSION), "1");
            properties.put(TestUtil.propKey(storeType, Element.DB, Element.MINOR_VERSION), "1");
            properties.put(TestUtil.propKey(storeType, Element.DB, Element.DISABLE_INDEXING), "true");
            properties.put(TestUtil.propKey(storeType, Element.DB, Element.DISABLE_UPSERT), "true");
        }
        for (Element storeType : storeTypes) {
            StoreProperties props = new StoreProperties(storeType, properties);
            JdbcStringBasedStoreConfigurationBuilder builder = (JdbcStringBasedStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
            Configuration cacheConfig = JdbcConfigurationUtil.configureStore((StoreProperties)props, (JdbcStringBasedStoreConfigurationBuilder)builder).build();
            JdbcStringBasedStoreConfiguration config = (JdbcStringBasedStoreConfiguration)cacheConfig.persistence().stores().get(0);
            Assert.assertEquals((Object)1, (Object)config.dbMajorVersion());
            Assert.assertEquals((Object)1, (Object)config.dbMinorVersion());
            Assert.assertTrue((boolean)Boolean.parseBoolean(config.properties().getProperty("infinispan.jdbc.indexing.disabled")));
            Assert.assertTrue((boolean)Boolean.parseBoolean(config.properties().getProperty("infinispan.jdbc.upsert.disabled")));
        }
    }

    private Properties createBaseProperties() {
        return this.createBaseProperties(Element.SOURCE);
    }

    private Properties createBaseProperties(Element orientation) {
        Properties properties = new Properties();
        properties.put(TestUtil.propKey(orientation, Element.CACHE_NAME), DEFAULT_CACHE_NAME);
        properties.put(TestUtil.propKey(orientation, Element.TYPE), StoreType.JDBC_MIXED.toString());
        properties.put(TestUtil.propKey(orientation, Element.DIALECT), DatabaseType.H2.toString());
        properties.put(TestUtil.propKey(orientation, Element.CONNECTION_POOL, Element.CONNECTION_URL), "jdbc:postgresql:postgres");
        properties.put(TestUtil.propKey(orientation, Element.CONNECTION_POOL, Element.DRIVER_CLASS), "org.postgresql.Driver");
        return properties;
    }

    public static class PersonExternalizer
    implements AdvancedExternalizer<Person> {
        public Set<Class<? extends Person>> getTypeClasses() {
            return Collections.singleton(Person.class);
        }

        public void writeObject(ObjectOutput output, Person object) throws IOException {
            externalizerWriteCount.incrementAndGet();
            MarshallUtil.marshallString((String)object.getName(), (ObjectOutput)output);
        }

        public Integer getId() {
            return 1;
        }

        public Person readObject(ObjectInput input) throws IOException {
            externalizerReadCount.incrementAndGet();
            Person person = new Person();
            person.setName(MarshallUtil.unmarshallString((ObjectInput)input));
            return person;
        }
    }
}

