/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.infinispan8;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.ExternalizerTable;
import org.jboss.marshalling.util.IdentityIntMap;

@Immutable
class ListExternalizer
extends AbstractExternalizer<List> {
    private static final int ARRAY_LIST = 0;
    private static final int LINKED_LIST = 1;
    private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(2);

    public ListExternalizer() {
        this.numbers.put(ArrayList.class, 0);
        this.numbers.put(this.getPrivateArrayListClass(), 0);
        this.numbers.put(LinkedList.class, 1);
    }

    public void writeObject(ObjectOutput output, List list) throws IOException {
        int number = this.numbers.get(list.getClass(), -1);
        output.writeByte(number);
        MarshallUtil.marshallCollection((Collection)list, (ObjectOutput)output);
    }

    public List readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        switch (magicNumber) {
            case 0: {
                return (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            }
            case 1: {
                return (List)MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new LinkedList());
            }
        }
        throw new IllegalStateException("Unknown List type: " + magicNumber);
    }

    public Integer getId() {
        return ExternalizerTable.ARRAY_LIST;
    }

    public Set<Class<? extends List>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{ArrayList.class, LinkedList.class, this.getPrivateArrayListClass()});
    }

    private Class<List> getPrivateArrayListClass() {
        return Util.loadClass((String)"java.util.Arrays$ArrayList", (ClassLoader)List.class.getClassLoader());
    }
}

