/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.container.entries.MortalCacheEntry;

public class MortalCacheEntryExternalizer
implements AdvancedExternalizer<MortalCacheEntry> {
    public Set<Class<? extends MortalCacheEntry>> getTypeClasses() {
        return Collections.singleton(MortalCacheEntry.class);
    }

    public Integer getId() {
        return 8;
    }

    public void writeObject(ObjectOutput output, MortalCacheEntry ice) throws IOException {
        output.writeObject(ice.getKey());
        output.writeObject(ice.getValue());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)ice.getCreated());
        output.writeLong(ice.getLifespan());
    }

    public MortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object key = input.readObject();
        Object value = input.readObject();
        long created = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        long lifespan = input.readLong();
        return new MortalCacheEntry(key, value, lifespan, created);
    }
}

