/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.licenses;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.infinispan.tools.licenses.LicenseMerger;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="org.infinispan.tools.licenses.LicenseMergerTest", groups={"functional"})
public class LicenseMergerTest {
    public void testMergeLicenses() throws Exception {
        LicenseMerger merger = new LicenseMerger();
        merger.loadLicense(this.getClass().getClassLoader().getResource("licenses/artifact1-1.0.0.xml").getFile());
        merger.loadLicense(this.getClass().getClassLoader().getResource("licenses/artifact2-1.0.0.xml").getFile());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        merger.write(false, (OutputStream)baos);
        String out = baos.toString(StandardCharsets.UTF_8.name());
        AssertJUnit.assertTrue((boolean)out.contains("artifact1"));
        AssertJUnit.assertTrue((boolean)out.contains("artifact2"));
        AssertJUnit.assertTrue((boolean)out.contains("artifact3"));
    }

    public void testMergeLicensesInclusive() throws Exception {
        LicenseMerger merger = new LicenseMerger();
        merger.loadLicense(this.getClass().getClassLoader().getResource("licenses/artifact1-1.0.0.xml").getFile());
        merger.loadLicense(this.getClass().getClassLoader().getResource("licenses/artifact2-1.0.0.xml").getFile());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        merger.write(true, (OutputStream)baos);
        String out = baos.toString(StandardCharsets.UTF_8.name());
        AssertJUnit.assertTrue((boolean)out.contains("artifact1"));
        AssertJUnit.assertTrue((boolean)out.contains("artifact2"));
        AssertJUnit.assertFalse((boolean)out.contains("artifact3"));
    }
}

