/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.metadata.Metadata;

public class MetadataMortalCacheValueExternalizer
implements AdvancedExternalizer<MetadataMortalCacheValue> {
    public Set<Class<? extends MetadataMortalCacheValue>> getTypeClasses() {
        return Collections.singleton(MetadataMortalCacheValue.class);
    }

    public Integer getId() {
        return 43;
    }

    public void writeObject(ObjectOutput output, MetadataMortalCacheValue icv) throws IOException {
        output.writeObject(icv.getValue());
        output.writeObject(icv.getMetadata());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)icv.getCreated());
    }

    public MetadataMortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object value = input.readObject();
        Metadata metadata = (Metadata)input.readObject();
        long created = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        return new MetadataMortalCacheValue(value, metadata, created);
    }
}

