/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.data.Key;
import org.infinispan.test.data.Person;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.SCIImpl;
import org.infinispan.util.KeyValuePair;

public class TestUtil {
    public static final Map<String, Object> TEST_MAP = new HashMap<String, Object>();
    static final Map<String, Object> TEST_MAP_UNSUPPORTED = new HashMap<String, Object>();

    public static String propKey(Element ... elements) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i].toString());
            if (i == elements.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    static {
        TEST_MAP_UNSUPPORTED.put("List", Arrays.asList(new Person("Alan Shearer"), new Person("Nolberto Solano")));
        TEST_MAP_UNSUPPORTED.put("SingletonList", Collections.singletonList(new Key("Key")));
        TEST_MAP_UNSUPPORTED.put("SingletonMap", Collections.singletonMap("Key", "Value"));
        TEST_MAP_UNSUPPORTED.put("SingletonSet", Collections.singleton(new Key("Key")));
        Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(1L)).build();
        TEST_MAP.put("EmbeddedMetadata", metadata);
        TEST_MAP.put("SimpleClusteredVersion", new SimpleClusteredVersion(1, 1L));
        TEST_MAP.put("CustomExternalizer", new TestObject(1, "Test"));
        TEST_MAP_UNSUPPORTED.put("KeyValuePair", new KeyValuePair((Object)"Key", (Object)"Value"));
        byte[] bytes = "Test".getBytes();
        TEST_MAP_UNSUPPORTED.put("ByteBufferImpl", ByteBufferImpl.create((byte[])bytes));
        InternalMetadataImpl internalMetadata = new InternalMetadataImpl(metadata, 1L, 1L);
        TEST_MAP_UNSUPPORTED.put("InternalMetadataImpl", internalMetadata);
        TEST_MAP_UNSUPPORTED.put("ImmortalCacheEntry", new ImmortalCacheEntry((Object)"Key", (Object)"Value"));
        TEST_MAP_UNSUPPORTED.put("MortalCacheEntry", new MortalCacheEntry((Object)"Key", (Object)"Value", 1L, 1L));
        TEST_MAP_UNSUPPORTED.put("TransientCacheEntry", new TransientCacheEntry((Object)"Key", (Object)"Value", 1L, 1L));
        TEST_MAP_UNSUPPORTED.put("TransientMortalCacheEntry", new TransientMortalCacheEntry((Object)"Key", (Object)"Value", 1L, 1L, 1L));
        TEST_MAP_UNSUPPORTED.put("ImmortalCacheValue", new ImmortalCacheValue((Object)"Value"));
        TEST_MAP_UNSUPPORTED.put("MortalCacheValue", new MortalCacheValue((Object)"Value", 1L, 1L));
        TEST_MAP_UNSUPPORTED.put("TransientCacheValue", new TransientCacheValue((Object)"Value", 1L, 1L));
        TEST_MAP_UNSUPPORTED.put("TransientMortalCacheValue", new TransientMortalCacheValue((Object)"Value", 1L, 1L, 1L, 1L));
        TEST_MAP_UNSUPPORTED.put("MetadataImmortalCacheEntry", new MetadataImmortalCacheEntry((Object)"Key", (Object)"Value", metadata));
        TEST_MAP_UNSUPPORTED.put("MetadataMortalCacheEntry", new MetadataMortalCacheEntry((Object)"Key", (Object)"Value", metadata, 1L));
        TEST_MAP_UNSUPPORTED.put("MetadataTransientCacheEntry", new MetadataTransientCacheEntry((Object)"Key", (Object)"Value", metadata, 1L));
        TEST_MAP_UNSUPPORTED.put("MetadataTransientMortalCacheEntry", new MetadataTransientMortalCacheEntry((Object)"Key", (Object)"Value", metadata, 1L));
        TEST_MAP_UNSUPPORTED.put("MetadataImmortalCacheValue", new MetadataImmortalCacheValue((Object)"Value", metadata));
        TEST_MAP_UNSUPPORTED.put("MetadataMortalCacheValue", new MetadataMortalCacheValue((Object)"Value", metadata, 1L));
        TEST_MAP_UNSUPPORTED.put("MetadataTransientCacheValue", new MetadataTransientCacheValue((Object)"Value", metadata, 1L));
        TEST_MAP_UNSUPPORTED.put("MetadataTransientMortalCacheValue", new MetadataTransientMortalCacheValue((Object)"Value", metadata, 1L, 1L));
    }

    @AutoProtoSchemaBuilder(dependsOn={TestDataSCI.class}, includeClasses={TestObject.class}, schemaFileName="test.tools.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.tools", service=false)
    static interface SCI
    extends SerializationContextInitializer {
        public static final SCI INSTANCE = new SCIImpl();
    }

    public static class TestObjectExternalizer
    implements AdvancedExternalizer<TestObject> {
        public Set<Class<? extends TestObject>> getTypeClasses() {
            return Collections.singleton(TestObject.class);
        }

        public Integer getId() {
            return 256;
        }

        public void writeObject(ObjectOutput objectOutput, TestObject testObject) throws IOException {
            objectOutput.writeInt(testObject.id);
            MarshallUtil.marshallString((String)testObject.someString, (ObjectOutput)objectOutput);
        }

        public TestObject readObject(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            TestObject testObject = new TestObject();
            testObject.id = objectInput.readInt();
            testObject.someString = MarshallUtil.unmarshallString((ObjectInput)objectInput);
            return testObject;
        }
    }

    public static class TestObject {
        @ProtoField(number=1, defaultValue="0")
        int id;
        @ProtoField(value=2)
        String someString;

        TestObject() {
        }

        @ProtoFactory
        TestObject(int id, String someString) {
            this.id = id;
            this.someString = someString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestObject that = (TestObject)o;
            if (this.id != that.id) {
                return false;
            }
            return this.someString != null ? this.someString.equals(that.someString) : that.someString == null;
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.someString != null ? this.someString.hashCode() : 0);
            return result;
        }
    }
}

