/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamAwareMarshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.tools.store.migrator.jdbc.AbstractJdbcEntryIterator;
import org.infinispan.tools.store.migrator.marshaller.SerializationConfigUtil;

abstract class AbstractStringJdbcIterator
extends AbstractJdbcEntryIterator {
    final TwoWayKey2StringMapper key2StringMapper;
    final MarshallableEntryFactory entryFactory;

    AbstractStringJdbcIterator(ConnectionFactory connectionFactory, TableManager tableManager, Marshaller marshaller, TwoWayKey2StringMapper key2StringMapper) {
        super(connectionFactory, tableManager, marshaller);
        this.key2StringMapper = key2StringMapper;
        this.entryFactory = SerializationConfigUtil.getEntryFactory(marshaller);
    }

    abstract MarshallableEntry readMarshalledEntry(Object var1, InputStream var2);

    @Override
    public final boolean hasNext() {
        return (long)this.rowIndex < this.numberOfRows;
    }

    @Override
    public final MarshallableEntry next() {
        try {
            if (this.rs.next()) {
                ++this.rowIndex;
                Object key = this.key2StringMapper.getKeyMapping(this.rs.getString(2));
                return this.readMarshalledEntry(key, this.rs.getBinaryStream(1));
            }
            this.close();
            throw new NoSuchElementException();
        }
        catch (SQLException e) {
            throw new PersistenceException("SQL error while fetching all StoredEntries", (Throwable)e);
        }
    }

    <T> T unmarshall(InputStream inputStream) throws PersistenceException {
        try {
            Object retVal = null;
            if (this.marshaller instanceof StreamingMarshaller) {
                retVal = ((StreamingMarshaller)this.marshaller).objectFromInputStream(inputStream);
            } else if (this.marshaller instanceof StreamAwareMarshaller) {
                retVal = ((StreamAwareMarshaller)this.marshaller).readObject(inputStream);
            }
            return (T)retVal;
        }
        catch (IOException e) {
            throw new PersistenceException("I/O error while unmarshalling from stream", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

