/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.tools.store.migrator.TestUtil;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.Infinispan8Marshaller;
import org.infinispan.tools.store.migrator.marshaller.infinispan9.Infinispan9Marshaller;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(testName="org.infinispan.tools.store.migrator.marshaller.LegacyMarshallerTest", groups={"functional"})
public class LegacyMarshallerTest
extends AbstractInfinispanTest {
    private int majorVersion;
    private StreamingMarshaller marshaller;
    private Map<String, byte[]> byteMap;

    @Factory
    public Object[] factory() {
        return new Object[]{new LegacyMarshallerTest().majorVersion(8), new LegacyMarshallerTest().majorVersion(9)};
    }

    protected String parameters() {
        return "[" + this.majorVersion + "]";
    }

    private LegacyMarshallerTest majorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
        return this;
    }

    @BeforeClass(alwaysRun=true)
    public void beforeTest() throws Exception {
        HashMap<Integer, TestUtil.TestObjectExternalizer> userExts = new HashMap<Integer, TestUtil.TestObjectExternalizer>();
        userExts.put(256, new TestUtil.TestObjectExternalizer());
        this.marshaller = this.majorVersion == 8 ? new Infinispan8Marshaller(userExts) : new Infinispan9Marshaller(userExts);
        String filename = String.format("src/test/resources/infinispan%d/marshalled_bytes.bin", this.majorVersion);
        Path path = new File(filename).toPath();
        byte[] bytes = Files.readAllBytes(path);
        this.byteMap = (Map)this.marshaller.objectFromByteBuffer(bytes);
    }

    public void testUnmarshalling() throws Exception {
        for (Map.Entry<String, Object> entry : TestUtil.TEST_MAP.entrySet()) {
            this.unmarshallAndAssertEquality(entry.getKey(), entry.getValue());
        }
    }

    private void unmarshallAndAssertEquality(String key, Object expectedObj) throws Exception {
        byte[] bytes = this.byteMap.get(key);
        Assert.assertNotNull((Object)bytes);
        Object readObj = this.marshaller.objectFromByteBuffer(bytes);
        Assert.assertEquals((Object)readObj, (Object)expectedObj);
    }
}

