/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.file;

import java.nio.file.Path;
import java.util.Properties;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.tools.store.migrator.AbstractReaderTest;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreType;
import org.infinispan.tools.store.migrator.TestUtil;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(testName="tools.store.migrator.file.SingleFileStoreReaderTest", groups={"functional"})
public class SingleFileStoreReaderTest
extends AbstractReaderTest {
    @Factory
    public Object[] factory() {
        return new Object[]{new SingleFileStoreReaderTest(), new SingleFileStoreReaderTest().majorVersion(9), ((AbstractReaderTest)((Object)new SingleFileStoreReaderTest().majorVersion(9))).targetSegments(59), new SingleFileStoreReaderTest().majorVersion(10), ((AbstractReaderTest)((Object)new SingleFileStoreReaderTest().majorVersion(10))).sourceSegments(4), new SingleFileStoreReaderTest().majorVersion(11), ((AbstractReaderTest)((Object)new SingleFileStoreReaderTest().majorVersion(11))).sourceSegments(4), new SingleFileStoreReaderTest().majorVersion(12), ((AbstractReaderTest)((Object)new SingleFileStoreReaderTest().majorVersion(12))).sourceSegments(4), new SingleFileStoreReaderTest().targetSegments(59)};
    }

    @Override
    public ConfigurationBuilder getTargetCacheConfig() {
        ConfigurationBuilder builder = super.getTargetCacheConfig();
        ((SingleFileStoreConfigurationBuilder)((SingleFileStoreConfigurationBuilder)((SingleFileStoreConfigurationBuilder)builder.persistence().addStore(SingleFileStoreConfigurationBuilder.class)).location(this.getTargetDir()).preload(true)).ignoreModifications(true)).segmented(this.targetSegments > 0);
        return builder;
    }

    @Override
    protected void configureStoreProperties(Properties properties, Element type) {
        super.configureStoreProperties(properties, type);
        properties.put(TestUtil.propKey(type, Element.TYPE), StoreType.SINGLE_FILE_STORE.toString());
        properties.put(TestUtil.propKey(type, Element.LOCATION), type == Element.SOURCE ? this.getSourceDir() : this.getTargetDir());
    }

    private String getSourceDir() {
        String root = String.format("target/test-classes/infinispan%d/singlefilestore/", this.majorVersion);
        if (this.sourceSegments == 0) {
            return root;
        }
        return Path.of(root, new String[0]).resolve("segmented").toString();
    }

    private String getTargetDir() {
        return this.getSourceDir() + "/target-sfs";
    }
}

