/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.annotations.Test;

@Test(groups={"manual"}, testName="test.fwk.TestNameVerifier")
public class TestNameVerifier {
    String dir = Paths.get("src", "test", "java", "org", "infinispan").toString();
    Pattern packageLinePattern = Pattern.compile("package org.infinispan[^;]*");
    Pattern classLinePattern = Pattern.compile("(abstract\\s*)??(public\\s*)(abstract\\s*)??class \\S*");
    Pattern atAnnotationPattern = Pattern.compile("^\\s*@Test[^)]*");
    Pattern testNamePattern = Pattern.compile("testName\\s*=\\s*\"[^\"]*\"");
    String fileCache;
    FilenameFilter javaFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !dir.getAbsolutePath().contains("testng") && name.endsWith(".java");
        }
    };
    FileFilter onlyDirs = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && !pathname.getName().equals("target");
        }
    };

    @Test(groups={"manual"}, description="Do not enable this unless you want your files to be updated with test names!!!")
    public void process() throws Exception {
        File[] javaFiles;
        for (File file : javaFiles = this.getAllJavaFiles()) {
            if (!this.needsUpdate(file)) continue;
            System.out.println("Updating file: " + file.getAbsolutePath());
            this.updateFile(file);
        }
    }

    private void updateFile(File file) throws Exception {
        String javaString = this.fileCache;
        String testName = this.getTestName(javaString, file.getName());
        String testNameStr = ", testName = \"" + testName + "\"";
        javaString = this.replaceAtTestAnnotation(javaString, testNameStr);
        this.persistNewFile(file, javaString);
    }

    private void persistNewFile(File file, String javaString) throws Exception {
        if (file.delete()) {
            System.out.println("!!!!!!!!!! error processing file " + file.getName());
            return;
        }
        file.createNewFile();
        PrintWriter writter = new PrintWriter(file);
        writter.append(javaString);
        writter.close();
    }

    private String replaceAtTestAnnotation(String javaString, String testNameStr) {
        Matcher matcher = this.atAnnotationPattern.matcher(javaString);
        boolean found = matcher.find();
        assert (found) : javaString;
        String theMatch = matcher.group();
        return matcher.replaceFirst(theMatch + testNameStr);
    }

    private String getTestName(String javaString, String filename) {
        String classNamePart = this.getClassNamePart(javaString, filename);
        if (classNamePart.indexOf("abstract") >= 0) {
            return null;
        }
        classNamePart = classNamePart.substring("public class ".length());
        String packagePart = this.getPackagePart(javaString, filename);
        String packagePrepend = packagePart != null && !packagePart.isEmpty() ? packagePart + "." : "";
        return packagePrepend + classNamePart;
    }

    private String getClassNamePart(String javaString, String filename) {
        Matcher matcher = this.classLinePattern.matcher(javaString);
        boolean found = matcher.find();
        assert (found) : "could not determine class name for file: " + filename;
        return matcher.group();
    }

    private String getPackagePart(String javaString, String filename) {
        Matcher matcher = this.packageLinePattern.matcher(javaString);
        boolean found = matcher.find();
        assert (found) : "Could not determine package name for file: " + filename;
        String theMatch = matcher.group();
        String partial = theMatch.substring("package org.infinispan".length());
        if (partial.trim().isEmpty()) {
            return partial.trim();
        }
        return partial.substring(1);
    }

    private boolean needsUpdate(File file) throws Exception {
        String javaFileStr = this.getFileAsString(file);
        if (javaFileStr.indexOf(" testName = \"") > 0) {
            return false;
        }
        int atTestIndex = javaFileStr.indexOf("@Test");
        int classDeclarationIndex = javaFileStr.indexOf("public class");
        return atTestIndex > 0 && atTestIndex < classDeclarationIndex;
    }

    private String getFileAsString(File file) throws Exception {
        String line;
        StringBuilder builder = new StringBuilder();
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        while ((line = fileReader.readLine()) != null) {
            builder.append(line).append("\n");
        }
        this.fileCache = builder.toString();
        return this.fileCache;
    }

    private File[] getAllJavaFiles() {
        List<File> listOfFiles = this.getFiles();
        return listOfFiles.toArray(new File[listOfFiles.size()]);
    }

    private void addJavaFiles(File file, ArrayList<File> result) {
        assert (file.isDirectory());
        File[] javaFiles = file.listFiles(this.javaFilter);
        result.addAll(Arrays.asList(javaFiles));
        for (File dir : file.listFiles(this.onlyDirs)) {
            this.addJavaFiles(dir, result);
        }
    }

    public void verifyTestName() throws Exception {
        File[] javaFiles = this.getAllJavaFiles();
        StringBuilder errorMessage = new StringBuilder("Following test class(es) do not have an appropriate test names: \n");
        boolean hasErrors = false;
        for (File file : javaFiles) {
            String expectedName = this.incorrectTestName(file);
            if (expectedName == null) continue;
            errorMessage.append(file.getAbsoluteFile()).append(" (Expected test name '").append(expectedName).append("', was '").append(this.existingTestName(file)).append("'\n");
            hasErrors = true;
        }
        assert (!hasErrors) : errorMessage.append("The rules for writing unit tests are described on http://www.jboss.org/community/wiki/ParallelTestSuite");
    }

    private String incorrectTestName(File file) throws Exception {
        String fileAsStr = this.getFileAsString(file);
        boolean containsTestAnnotation = this.atAnnotationPattern.matcher(fileAsStr).find();
        if (!containsTestAnnotation) {
            return null;
        }
        String expectedTestName = this.getTestName(fileAsStr, file.getName());
        if (expectedTestName == null) {
            return null;
        }
        String existingTestName = this.existingTestName(file);
        if (existingTestName == null || !existingTestName.equals(expectedTestName)) {
            return expectedTestName;
        }
        return null;
    }

    private String existingTestName(File file) throws Exception {
        String fileAsStr = this.getFileAsString(file);
        boolean containsTestAnnotation = this.atAnnotationPattern.matcher(fileAsStr).find();
        if (!containsTestAnnotation) {
            return null;
        }
        String expectedTestName = this.getTestName(fileAsStr, file.getName());
        if (expectedTestName == null) {
            return null;
        }
        Matcher matcher = this.testNamePattern.matcher(fileAsStr);
        if (!matcher.find()) {
            return expectedTestName;
        }
        String name = matcher.group().trim();
        int firstIndexOfQuote = name.indexOf(34);
        return name.substring(firstIndexOfQuote + 1, name.length() - 1);
    }

    private List<File> getFiles() {
        File file = new File(".");
        assert (file.isDirectory());
        ArrayList<File> result = new ArrayList<File>();
        this.addJavaFiles(file, result);
        return result;
    }
}

