/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.jdbc;

import java.util.Properties;
import java.util.stream.IntStream;
import org.h2.Driver;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreMigrator;
import org.infinispan.tools.store.migrator.StoreType;
import org.infinispan.tools.store.migrator.TestUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="org.infinispan.tools.store.migrator.marshaller.jdbc.JdbcReaderTest", groups={"functional"})
public class JdbcReaderTest
extends AbstractInfinispanTest {
    private static final int NUM_ENTRIES = 100;
    private static final String CACHE_NAME = "jdbc-cache";
    private static final String JDBC_URL = "jdbc:h2:mem:JdbcReaderTest;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE";
    private static final String SFS_LOCATION = CommonsTestingUtil.tmpDirectory(JdbcReaderTest.class);

    @AfterClass
    public void cleanup() {
        Util.recursiveFileRemove((String)SFS_LOCATION);
    }

    @Test
    public void jdbcReaderTest() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        JdbcStringBasedStoreConfigurationBuilder jdbcB = (JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)jdbcB.table().createOnStart(true)).dropOnExit(false)).tableNamePrefix("prefix")).idColumnName("ID_COLUMN")).idColumnType("VARCHAR(255)")).dataColumnName("DATA_COLUMN")).dataColumnType("BINARY VARYING")).timestampColumnName("TIMESTAMP_COLUMN")).timestampColumnType("BIGINT")).segmented(false);
        jdbcB.connectionPool().driverClass(Driver.class).connectionUrl(JDBC_URL).username("sa");
        try (DefaultCacheManager cm = new DefaultCacheManager();){
            Cache cache = cm.createCache(CACHE_NAME, builder.build());
            IntStream.range(0, 100).forEach(i -> cache.put((Object)i, (Object)i));
        }
        Properties properties = new Properties();
        properties.put(TestUtil.propKey(Element.SOURCE, Element.CACHE_NAME), CACHE_NAME);
        properties.put(TestUtil.propKey(Element.SOURCE, Element.TYPE), StoreType.JDBC_STRING.toString());
        properties.put(TestUtil.propKey(Element.SOURCE, Element.DIALECT), "h2");
        properties.put(TestUtil.propKey(Element.SOURCE, Element.CONNECTION_POOL, Element.CONNECTION_URL), JDBC_URL);
        properties.put(TestUtil.propKey(Element.SOURCE, Element.CONNECTION_POOL, Element.DRIVER_CLASS), Driver.class.getName());
        properties.put(TestUtil.propKey(Element.SOURCE, Element.CONNECTION_POOL, Element.USERNAME), "sa");
        properties.put(TestUtil.propKey(Element.SOURCE, Element.TABLE, Element.STRING, Element.TABLE_NAME_PREFIX), "prefix");
        properties.put(TestUtil.propKey(Element.SOURCE, Element.TABLE, Element.STRING, Element.ID, Element.NAME), "ID_COLUMN");
        properties.put(TestUtil.propKey(Element.SOURCE, Element.TABLE, Element.STRING, Element.ID, Element.TYPE), "VARCHAR(255)");
        properties.put(TestUtil.propKey(Element.SOURCE, Element.TABLE, Element.STRING, Element.DATA, Element.NAME), "DATA_COLUMN");
        properties.put(TestUtil.propKey(Element.SOURCE, Element.TABLE, Element.STRING, Element.DATA, Element.TYPE), "BINARY VARYING");
        properties.put(TestUtil.propKey(Element.SOURCE, Element.TABLE, Element.STRING, Element.SEGMENT, Element.NAME), "SEGMENT_COLUMN");
        properties.put(TestUtil.propKey(Element.SOURCE, Element.TABLE, Element.STRING, Element.SEGMENT, Element.TYPE), "BIGINT");
        properties.put(TestUtil.propKey(Element.SOURCE, Element.TABLE, Element.STRING, Element.TIMESTAMP, Element.NAME), "TIMESTAMP_COLUMN");
        properties.put(TestUtil.propKey(Element.SOURCE, Element.TABLE, Element.STRING, Element.TIMESTAMP, Element.TYPE), "BIGINT");
        properties.put(TestUtil.propKey(Element.SOURCE, Element.SEGMENT_COUNT), "256");
        properties.put(TestUtil.propKey(Element.TARGET, Element.TYPE), StoreType.SINGLE_FILE_STORE.toString());
        properties.put(TestUtil.propKey(Element.TARGET, Element.CACHE_NAME), CACHE_NAME);
        properties.put(TestUtil.propKey(Element.TARGET, Element.LOCATION), SFS_LOCATION);
        new StoreMigrator(properties).run();
        builder = new ConfigurationBuilder();
        builder.persistence().addSingleFileStore().location(SFS_LOCATION);
        try (DefaultCacheManager cm = new DefaultCacheManager();){
            Cache cache = cm.createCache(CACHE_NAME, builder.build());
            AssertJUnit.assertEquals((int)100, (int)cache.size());
            IntStream.range(0, 100).forEach(i -> AssertJUnit.assertEquals((int)i, (int)((Integer)cache.get((Object)i))));
        }
    }
}

