/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreIterator;
import org.infinispan.tools.store.migrator.StoreProperties;

public class SegmentedFileStoreReader
implements StoreIterator {
    final int numSegments;
    final Function<StoreProperties, StoreIterator> storeFactory;
    final List<StoreIterator> storeIterators;

    public SegmentedFileStoreReader(StoreProperties properties, Function<StoreProperties, StoreIterator> storeFactory) {
        properties.required(Element.SEGMENT_COUNT);
        this.numSegments = Integer.parseInt(properties.get(Element.SEGMENT_COUNT));
        this.storeFactory = storeFactory;
        Path root = Path.of(properties.get(Element.LOCATION), new String[0]);
        this.storeIterators = new ArrayList<StoreIterator>(this.numSegments);
        for (int i = 0; i < this.numSegments; ++i) {
            StoreProperties p = new StoreProperties(properties);
            String segment = root.resolve(Integer.toString(i)).toString();
            p.put(segment, Element.LOCATION);
            StoreIterator it = storeFactory.apply(p);
            this.storeIterators.add(it);
        }
    }

    @Override
    public void close() throws Exception {
        for (StoreIterator it : this.storeIterators) {
            it.close();
        }
    }

    @Override
    public Iterator<MarshallableEntry> iterator() {
        return new SegmentedStoreIterator();
    }

    class SegmentedStoreIterator
    implements Iterator<MarshallableEntry> {
        int currentSegment;
        List<Iterator<MarshallableEntry>> entryIterators;

        SegmentedStoreIterator() {
            this.entryIterators = SegmentedFileStoreReader.this.storeIterators.stream().map(Iterable::iterator).collect(Collectors.toList());
        }

        @Override
        public boolean hasNext() {
            for (int nextSegment = this.currentSegment; nextSegment < SegmentedFileStoreReader.this.numSegments; ++nextSegment) {
                if (!this.entryIterators.get(nextSegment).hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public MarshallableEntry next() {
            while (this.currentSegment < SegmentedFileStoreReader.this.numSegments) {
                Iterator<MarshallableEntry> it = this.entryIterators.get(this.currentSegment);
                if (it.hasNext()) {
                    return it.next();
                }
                ++this.currentSegment;
            }
            throw new NoSuchElementException();
        }
    }
}

